/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.validation;

import com.alphaserve.twofactor.core.dtolayer.dtos.CredentialName;
import com.alphaserve.twofactor.core.services.UserService;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.alphaserve.twofactor.core.validation.core.Validator;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Named
@Component
public class CredentialDTOValidator
implements Validator<CredentialName> {
    private static final int MAX_CREDENTIAL_NAME_LENGTH = 255;
    @ComponentImport
    private I18nResolver i18nResolver;
    private UserService userService;

    @Inject
    public CredentialDTOValidator(I18nResolver i18nResolver, UserService userService) {
        this.i18nResolver = i18nResolver;
        this.userService = userService;
    }

    @Override
    public ValidationResult validate(CredentialName credentialName) {
        ValidationResult validationResult = ValidationResult.init(this.i18nResolver);
        if (StringUtils.isBlank(credentialName.getName()) || credentialName.getName().length() > 255) {
            validationResult.addError("webauthn.user.config.credential.name.empty");
        }
        try {
            if (this.userService.getCredentialCountByName(credentialName.getName().trim()) != 0L) {
                validationResult.addError("webauthn.user.config.credential.with.name.exist");
            }
        }
        catch (NullPointerException e) {
            validationResult.addError("auth.text.user-auth-deleted-error");
        }
        return validationResult;
    }
}

