/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.servlets.impl;

import com.alphaserve.twofactor.core.Plugin2FACoreContext;
import com.alphaserve.twofactor.core.dtolayer.dtos.TOTPMobileLoginDTO;
import com.alphaserve.twofactor.core.model.LogActionType;
import com.alphaserve.twofactor.core.model.entities.cache.wraper.Auth2FACacheWrapper;
import com.alphaserve.twofactor.core.security.AuthFilterManager;
import com.alphaserve.twofactor.core.security.FilterState;
import com.alphaserve.twofactor.core.services.AuthLoginService;
import com.alphaserve.twofactor.core.services.ClusterService;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.Force2FAService;
import com.alphaserve.twofactor.core.services.PluginInfoService;
import com.alphaserve.twofactor.core.services.TotpService;
import com.alphaserve.twofactor.core.services.UserActionService;
import com.alphaserve.twofactor.core.services.entities.Auth2FAService;
import com.alphaserve.twofactor.core.services.entities.FailLogin2FAService;
import com.alphaserve.twofactor.core.services.entities.IpFilterService;
import com.alphaserve.twofactor.core.services.entities.LoggerActionService;
import com.alphaserve.twofactor.core.services.entities.RememberMeService;
import com.alphaserve.twofactor.core.services.servlets.FilterService;
import com.alphaserve.twofactor.core.utils.CacheUtils;
import com.alphaserve.twofactor.core.utils.UrlUtils;
import com.alphaserve.twofactor.core.validation.HttpResourceUrlValidation;
import com.alphaserve.twofactor.core.validation.User2faEnabledValidation;
import com.alphaserve.twofactor.core.validation.XsrfTokenValidator;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.alphaserve.twofactor.core.validation.core.Validator;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.io.IOException;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Qualifier;

@Named
public class FilterServiceImpl
implements FilterService {
    public static final String SKIM_PAGE = "/plugins/servlet/authplugin/skim";
    public static final String MOBILE = "AtlassianMobileApp";
    @ComponentImport
    protected final UserManager userManager;
    protected final AuthLoginService authLoginService;
    protected final ConfigurationService configurationService;
    protected final Auth2FAService auth2FAService;
    protected final LoggerActionService loggerActionService;
    protected final RememberMeService rememberMeService;
    protected final IpFilterService ipFilterService;
    protected final Force2FAService force2FAService;
    protected AuthFilterManager authFilterManager;
    protected final FailLogin2FAService failLogin2FAService;
    protected Validator<UserProfile> userProfileValidator;
    protected final TotpService totpService;
    protected final PluginInfoService pluginInfoService;
    protected final User2faEnabledValidation user2faEnabledValidation;
    protected final Validator<TOTPMobileLoginDTO> totpMobileLoginDTOValidator;
    protected final UserActionService userActionService;
    protected final XsrfTokenValidator xsrfTokenValidator;
    @ComponentImport
    protected final PluginAccessor pluginAccessor;
    protected final ClusterService clusterService;
    protected final Plugin2FACoreContext pluginContext;
    protected final HttpResourceUrlValidation resourceUrlValidation;
    protected final String baseUrl;

    @Inject
    public FilterServiceImpl(@Qualifier(value="userManager") UserManager userManager, AuthLoginService authLoginService, ConfigurationService configurationService, Auth2FAService auth2FAService, LoggerActionService loggerActionService, RememberMeService rememberMeService, IpFilterService ipFilterService, Force2FAService force2FAService, FailLogin2FAService failLogin2FAService, Validator<UserProfile> userProfileValidator, TotpService totpService, PluginInfoService pluginInfoService, User2faEnabledValidation user2faEnabledValidation, Validator<TOTPMobileLoginDTO> totpMobileLoginDTOValidator, UserActionService userActionService, XsrfTokenValidator xsrfTokenValidator, PluginAccessor pluginAccessor, ClusterService clusterService, Plugin2FACoreContext pluginContext, AuthFilterManager authFilterManager, HttpResourceUrlValidation resourceUrlValidation) {
        this.userManager = userManager;
        this.authLoginService = authLoginService;
        this.configurationService = configurationService;
        this.auth2FAService = auth2FAService;
        this.loggerActionService = loggerActionService;
        this.rememberMeService = rememberMeService;
        this.ipFilterService = ipFilterService;
        this.force2FAService = force2FAService;
        this.failLogin2FAService = failLogin2FAService;
        this.userProfileValidator = userProfileValidator;
        this.totpService = totpService;
        this.pluginInfoService = pluginInfoService;
        this.user2faEnabledValidation = user2faEnabledValidation;
        this.totpMobileLoginDTOValidator = totpMobileLoginDTOValidator;
        this.userActionService = userActionService;
        this.xsrfTokenValidator = xsrfTokenValidator;
        this.pluginAccessor = pluginAccessor;
        this.authFilterManager = authFilterManager;
        this.clusterService = clusterService;
        this.pluginContext = pluginContext;
        this.resourceUrlValidation = resourceUrlValidation;
        this.baseUrl = this.pluginContext.getBaseUrl(UrlMode.RELATIVE);
    }

    @Override
    public void doLoginFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.doLoginFilter(servletRequest, servletResponse, filterChain, false);
    }

    @Override
    public void doLoginFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain, boolean isReadOnlyMode) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse res = (HttpServletResponse)servletResponse;
        if (this.resourceUrlValidation.isResourceRequest(req)) {
            filterChain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        UserProfile remoteUser = this.userManager.getRemoteUser();
        if (Objects.nonNull(remoteUser)) {
            Auth2FACacheWrapper auth2FA = this.auth2FAService.getWrappedEntityByUserKey(remoteUser.getUserKey());
            if (!this.authLoginService.isLogged(req.getSession(), auth2FA) && this.filterUser(filterChain, req, res, isReadOnlyMode, auth2FA, remoteUser)) {
                return;
            }
        }
        filterChain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    @Override
    public void doDeleteUserFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String login;
        UserProfile userProfile;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        ValidationResult validationResult = this.userProfileValidator.validate(this.userManager.getRemoteUser());
        if (!(this.authLoginService.isPermitted(request.getSession()) && validationResult.hasErrors() || (validationResult = this.xsrfTokenValidator.validate(request, response)).hasErrors() || !Objects.nonNull(userProfile = this.userManager.getUserProfile(login = request.getParameter(this.pluginContext.getDeleteUsernameField()))) || !Objects.nonNull(this.userManager.getRemoteUser()) || userProfile.getUsername().equals(this.userManager.getRemoteUser().getUsername()))) {
            this.totpService.reset(userProfile, request);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Override
    public void doBeforeMobileLoginFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String instanceUsername = request.getParameter("alpha_auth_username");
        if (this.isMobileLogin(request) && this.authLoginService.isUserHave2fa(instanceUsername)) {
            String instanceCode = request.getParameter("tfa-login-key");
            if (this.authFilterManager.isUserInIPList(request, instanceUsername, this.configurationService) || this.validateMobileLogin(request, instanceUsername, instanceCode)) {
                this.setMobileAuthLoginResult(request, true);
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    @Override
    public void doBeforeDispatchMobileLoginFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Object attribute;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        UserProfile remoteUser = this.userManager.getRemoteUser();
        if (this.isMobileLogin(request) && Objects.nonNull(remoteUser) && this.authLoginService.isUserHave2fa() && Objects.nonNull(attribute = request.getSession().getAttribute("alpha-auth-mobile-login"))) {
            if (!((Boolean)attribute).booleanValue()) {
                this.userActionService.logout(request, response);
                this.loggerActionService.add(remoteUser.getUsername(), LogActionType.PASS_2FA_FAILED, this.ipFilterService.getClientIpAddress(request));
            } else {
                this.authLoginService.login2fa(request.getSession());
                this.loggerActionService.add(remoteUser.getUsername(), LogActionType.PASS_2FA_SUCCESS, this.ipFilterService.getClientIpAddress(request));
                request.getSession().removeAttribute("alpha-auth-mobile-login");
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    @Override
    public void doXsrfFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        ValidationResult validationResult;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (UrlUtils.normalizeURL(request.getRequestURI()).contains("/rest/authpluginresources/1.0/") && request.getMethod().equals("POST") && (validationResult = this.xsrfTokenValidator.validate(request, response)).hasErrors()) {
            response.sendError(403, "XSRF check failed");
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private boolean isMobileLogin(HttpServletRequest request) {
        return Objects.nonNull(request.getHeader("User-Agent")) && request.getHeader("User-Agent").contains(MOBILE) && this.pluginInfoService.isPluginLicensed();
    }

    private boolean validateMobileLogin(HttpServletRequest request, String instanceUsername, String instanceCode) {
        if (Objects.isNull(instanceUsername) || Objects.isNull(instanceCode)) {
            this.setMobileAuthLoginResult(request, false);
            return false;
        }
        ValidationResult validationResult = this.user2faEnabledValidation.validate(instanceUsername);
        if (validationResult.hasErrors()) {
            this.setMobileAuthLoginResult(request, false);
            return false;
        }
        validationResult = this.totpMobileLoginDTOValidator.validate(TOTPMobileLoginDTO.builder().code(instanceCode).username(instanceUsername).build());
        if (validationResult.hasErrors()) {
            this.setMobileAuthLoginResult(request, false);
            return false;
        }
        return true;
    }

    private void setMobileAuthLoginResult(HttpServletRequest request, boolean value) {
        request.getSession().setAttribute("alpha-auth-mobile-login", (Object)value);
    }

    protected boolean filterUser(FilterChain filterChain, HttpServletRequest req, HttpServletResponse res, boolean isReadOnlyMode, Auth2FACacheWrapper auth2FA, UserProfile remoteUser) throws IOException, ServletException {
        String requestUri = req.getRequestURI();
        FilterState authResult = this.authFilterManager.getAuthResult(this.auth2FAService, this.authLoginService, this.loggerActionService, this.rememberMeService, this.ipFilterService, req, this.force2FAService, this.configurationService, this.failLogin2FAService, this.pluginAccessor, auth2FA, remoteUser, this.clusterService, requestUri);
        switch (authResult) {
            case LOGGED_IN: 
            case PASS: {
                filterChain.doFilter((ServletRequest)req, (ServletResponse)res);
                break;
            }
            case FORCE: {
                if (isReadOnlyMode) {
                    filterChain.doFilter((ServletRequest)req, (ServletResponse)res);
                    break;
                }
                String forcePage = this.baseUrl + "/plugins/servlet/authplugin/tfaconfiguration";
                if (!requestUri.equals(forcePage)) {
                    CacheUtils.setNoCache(res);
                    res.sendRedirect(forcePage + "?targetUrl=" + UrlUtils.getTargetURL(req, this.baseUrl));
                    break;
                }
                filterChain.doFilter((ServletRequest)req, (ServletResponse)res);
                break;
            }
            case SKIM_FAILED: {
                res.sendRedirect(this.baseUrl + SKIM_PAGE);
                break;
            }
            case LOCKED: {
                String lockedPage = this.baseUrl + "/plugins/servlet/authplugin/locked";
                if (!requestUri.equals(lockedPage)) {
                    CacheUtils.setNoCache(res);
                    res.sendRedirect(lockedPage);
                    break;
                }
                filterChain.doFilter((ServletRequest)req, (ServletResponse)res);
                break;
            }
            case NOT_ALLOWED: {
                break;
            }
            default: {
                if (!Objects.nonNull(this.userManager.getRemoteUser())) break;
                CacheUtils.setNoCache(res);
                res.sendRedirect(this.baseUrl + "/plugins/servlet/authplugin/authlogin" + "?targetUrl=" + UrlUtils.getTargetURL(req, this.baseUrl));
            }
        }
        return true;
    }
}

