/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.rest.impl;

import com.alphaserve.twofactor.core.dtolayer.converter.DoForwardConverter;
import com.alphaserve.twofactor.core.dtolayer.dtos.BulkResetDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.MobileLoginDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.TOTPLoginDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.TOTPMobileLoginDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.TOTPRepresentation;
import com.alphaserve.twofactor.core.dtolayer.dtos.UsernameDTO;
import com.alphaserve.twofactor.core.model.AuthType;
import com.alphaserve.twofactor.core.model.entities.Auth2FA;
import com.alphaserve.twofactor.core.model.exceptions.ForceException;
import com.alphaserve.twofactor.core.model.exceptions.LockedException;
import com.alphaserve.twofactor.core.model.exceptions.QRCodeOnlyAuthorizedException;
import com.alphaserve.twofactor.core.services.AuthLoginService;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.LoginActionService;
import com.alphaserve.twofactor.core.services.PluginInfoService;
import com.alphaserve.twofactor.core.services.ServiceDeskService;
import com.alphaserve.twofactor.core.services.TotpService;
import com.alphaserve.twofactor.core.services.UserService;
import com.alphaserve.twofactor.core.services.entities.Auth2FAService;
import com.alphaserve.twofactor.core.services.entities.FailLogin2FAService;
import com.alphaserve.twofactor.core.services.entities.SecretKeyService;
import com.alphaserve.twofactor.core.services.rest.TOTPRestService;
import com.alphaserve.twofactor.core.services.servlets.MobileService;
import com.alphaserve.twofactor.core.validation.AdminPermittedValidation;
import com.alphaserve.twofactor.core.validation.DisableTotpValidation;
import com.alphaserve.twofactor.core.validation.LoggedTwoFactorValidation;
import com.alphaserve.twofactor.core.validation.MobileSecretKeyValidation;
import com.alphaserve.twofactor.core.validation.ReserveCodeValidation;
import com.alphaserve.twofactor.core.validation.SecretKeyValidation;
import com.alphaserve.twofactor.core.validation.TrustedUserValidation;
import com.alphaserve.twofactor.core.validation.User2faEnabledValidation;
import com.alphaserve.twofactor.core.validation.XsrfTokenValidator;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.alphaserve.twofactor.core.validation.core.Validator;
import com.atlassian.sal.api.user.UserProfile;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.gson.Gson;
import com.google.zxing.WriterException;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class TOTPRestServiceImpl
implements TOTPRestService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TOTPRestServiceImpl.class);
    private final AdminPermittedValidation adminPermittedValidation;
    private final Validator<UsernameDTO> usernameValidator;
    private final TotpService totpService;
    private final AuthLoginService authLoginService;
    private final UserService userService;
    private final LoginActionService loginActionService;
    private final PluginInfoService pluginInfoService;
    private final SecretKeyValidation secretKeyValidation;
    private final LoggedTwoFactorValidation loggedTwoFactorValidation;
    private final DoForwardConverter<Auth2FA, TOTPRepresentation> totpDTOConverter;
    private final ReserveCodeValidation reserveCodeValidation;
    private final Auth2FAService auth2FAService;
    private final User2faEnabledValidation user2faEnabledValidation;
    private final Validator<TOTPMobileLoginDTO> totpMobileLoginDTOValidator;
    private final FailLogin2FAService failLogin2FAService;
    private final MobileService mobileService;
    private final XsrfTokenValidator xsrfTokenValidator;
    private final DisableTotpValidation disableTotpValidation;
    private final ServiceDeskService serviceDeskService;
    private final Validator<BulkResetDTO> bulkResetDTOValidator;
    private final TrustedUserValidation trustedUserValidation;
    private final ConfigurationService configurationService;
    private final SecretKeyService secretKeyService;

    @Inject
    public TOTPRestServiceImpl(AdminPermittedValidation adminPermittedValidation, Validator<UsernameDTO> usernameValidator, TotpService totpService, AuthLoginService authLoginService, UserService userService, LoginActionService loginActionService, PluginInfoService pluginInfoService, SecretKeyValidation secretKeyValidation, LoggedTwoFactorValidation loggedTwoFactorValidation, DoForwardConverter<Auth2FA, TOTPRepresentation> totpDTOConverter, ReserveCodeValidation reserveCodeValidation, Auth2FAService auth2FAService, User2faEnabledValidation user2faEnabledValidation, MobileSecretKeyValidation totpMobileLoginDTOValidator, FailLogin2FAService failLogin2FAService, MobileService mobileService, XsrfTokenValidator xsrfTokenValidator, DisableTotpValidation disableTotpValidation, ServiceDeskService serviceDeskService, Validator<BulkResetDTO> bulkResetDTOValidator, TrustedUserValidation trustedUserValidation, ConfigurationService configurationService, SecretKeyService secretKeyService) {
        this.adminPermittedValidation = adminPermittedValidation;
        this.usernameValidator = usernameValidator;
        this.totpService = totpService;
        this.authLoginService = authLoginService;
        this.userService = userService;
        this.loginActionService = loginActionService;
        this.pluginInfoService = pluginInfoService;
        this.secretKeyValidation = secretKeyValidation;
        this.loggedTwoFactorValidation = loggedTwoFactorValidation;
        this.totpDTOConverter = totpDTOConverter;
        this.reserveCodeValidation = reserveCodeValidation;
        this.auth2FAService = auth2FAService;
        this.user2faEnabledValidation = user2faEnabledValidation;
        this.totpMobileLoginDTOValidator = totpMobileLoginDTOValidator;
        this.failLogin2FAService = failLogin2FAService;
        this.mobileService = mobileService;
        this.xsrfTokenValidator = xsrfTokenValidator;
        this.disableTotpValidation = disableTotpValidation;
        this.serviceDeskService = serviceDeskService;
        this.bulkResetDTOValidator = bulkResetDTOValidator;
        this.trustedUserValidation = trustedUserValidation;
        this.configurationService = configurationService;
        this.secretKeyService = secretKeyService;
    }

    @Override
    public Response resetTwoFactorForUser(HttpServletRequest request, HttpServletResponse response, UsernameDTO usernameDTO) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, response);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        validationResult = this.trustedUserValidation.validate(request.getSession());
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        validationResult = this.usernameValidator.validate(usernameDTO);
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        this.totpService.reset(usernameDTO.getUsername(), request);
        return this.ok();
    }

    @Override
    public Response login(HttpServletRequest request, HttpServletResponse response, TOTPLoginDTO totpLoginDTO) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, response);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        if (this.authLoginService.isLogged(request.getSession())) {
            return this.ok();
        }
        UserProfile userProfile = this.userService.getUserProfile();
        if (!this.pluginInfoService.isPluginLicensed()) {
            this.loginActionService.login(userProfile, request, response, AuthType.TOTP_SECURITY_KEY, false);
            return this.ok();
        }
        validationResult = this.user2faEnabledValidation.validate();
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        validationResult = this.secretKeyValidation.validate(totpLoginDTO);
        if (validationResult.hasErrors()) {
            this.loginActionService.failLogin(userProfile, request);
            return this.getBadValidationResponse(validationResult);
        }
        this.totpService.login(userProfile, request, response, totpLoginDTO.isRememberMe(), Integer.parseInt(totpLoginDTO.getCode()));
        return this.ok();
    }

    @Override
    public Response generateQRImage() {
        UserProfile userProfile = this.userService.getUserProfile();
        try {
            return this.ok(this.totpService.getQRImageUrl(userProfile));
        }
        catch (WriterException | IOException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (QRCodeOnlyAuthorizedException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @Override
    public Response disableTOTP(HttpServletRequest request, HttpServletResponse response) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, response);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        validationResult = this.disableTotpValidation.validate();
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        validationResult = this.loggedTwoFactorValidation.validate(request.getSession());
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        if (!this.authLoginService.isLogged(request.getSession())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.totpService.revoke(this.userService.getUserProfile(), request);
        this.authLoginService.logout2fa(request.getSession());
        return this.ok();
    }

    @Override
    public Response enableTOTP(HttpServletRequest request, HttpServletResponse response, TOTPLoginDTO totpLoginDTO) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, response);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        UserProfile userProfile = this.userService.getUserProfile();
        validationResult = this.secretKeyValidation.validate(totpLoginDTO);
        Auth2FA auth2FA = this.totpService.getByUser(userProfile);
        if (auth2FA.getConfirmed() && auth2FA.getActive()) {
            return this.badRequest();
        }
        if (validationResult.hasErrors()) {
            this.loginActionService.failLogin(userProfile, request);
            return this.getBadValidationResponse(validationResult);
        }
        this.totpService.enable(userProfile, Integer.parseInt(totpLoginDTO.getCode()));
        this.loginActionService.login(userProfile, request, response, AuthType.TOTP_ENABLE_SECURITY_KEY, false);
        return this.ok();
    }

    @Override
    public Response getTOTP() {
        UserProfile userProfile = this.userService.getUserProfile();
        Auth2FA auth2FA = this.totpService.getByUser(userProfile);
        if (auth2FA.getActive() && auth2FA.getConfirmed()) {
            return this.badRequest();
        }
        TOTPRepresentation totpRepresentation = this.totpDTOConverter.doForward(auth2FA);
        return Response.ok((Object)new Gson().toJson(totpRepresentation)).build();
    }

    @Override
    public Response loginWithReserveCode(HttpServletRequest request, HttpServletResponse response, TOTPLoginDTO totpLoginDTO) {
        return this.loginWithReserveCode(request, response, totpLoginDTO, false);
    }

    @Override
    public Response loginWithReserveCode(HttpServletRequest request, HttpServletResponse response, TOTPLoginDTO totpLoginDTO, boolean isReadOnlyMode) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, response);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        UserProfile userProfile = this.userService.getUserProfile();
        validationResult = this.user2faEnabledValidation.validate();
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        validationResult = this.reserveCodeValidation.validate(totpLoginDTO, isReadOnlyMode);
        if (validationResult.hasErrors()) {
            this.loginActionService.failLogin(userProfile, request);
            return this.getBadValidationResponse(validationResult);
        }
        this.totpService.loginReserveCode(userProfile, request, response, totpLoginDTO.getCode());
        return this.ok();
    }

    @Override
    public Response finishRegistration(HttpServletRequest request, HttpServletResponse response) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, response);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        UserProfile userProfile = this.userService.getUserProfile();
        Auth2FA auth2FA = this.totpService.getByUser(userProfile);
        if (this.auth2FAService.isUserAllowedToFinishRegistration(userProfile)) {
            this.totpService.finishRegistration(userProfile);
            request.getSession().setAttribute("download-codes-" + userProfile.getUserKey().getStringValue(), (Object)System.currentTimeMillis());
            return this.ok();
        }
        if (this.secretKeyService.isAllowedToDownload(request, auth2FA)) {
            return this.ok();
        }
        return this.badRequest();
    }

    @Override
    public Response isAllowedMobile(HttpServletRequest request, HttpServletResponse response, MobileLoginDTO mobileLoginDTO) {
        return this.isAllowedMobile(request, response, mobileLoginDTO, false);
    }

    @Override
    public Response isAllowedMobile(HttpServletRequest request, HttpServletResponse response, MobileLoginDTO mobileLoginDTO, boolean isReadOnlyMode) {
        try {
            return !this.authLoginService.isAllowedMobile(request, mobileLoginDTO.getUsername(), isReadOnlyMode) ? this.ok() : this.badRequest();
        }
        catch (LockedException e) {
            return this.badRequest(this.mobileService.doGetLockedError());
        }
        catch (ForceException e) {
            return this.badRequest(this.mobileService.doGetForcedError());
        }
    }

    @Override
    public Response validateTOTP(HttpServletRequest request, TOTPMobileLoginDTO totpMobileLoginDTO) {
        UserProfile userProfile = this.userService.getUserProfile(totpMobileLoginDTO.getUsername());
        if (this.failLogin2FAService.isLocked(userProfile.getUserKey().getStringValue(), request)) {
            return this.badRequest(this.mobileService.doGetLockedError());
        }
        ValidationResult validationResult = this.user2faEnabledValidation.validate(totpMobileLoginDTO.getUsername());
        if (validationResult.hasErrors()) {
            return this.badRequest(this.mobileService.doGetWrongCodeError(validationResult.getErrors().get(0).getErrorCodeMessage()));
        }
        validationResult = this.totpMobileLoginDTOValidator.validate(totpMobileLoginDTO);
        if (validationResult.hasErrors()) {
            this.loginActionService.failLogin(userProfile, request);
            return this.badRequest(this.mobileService.doGetWrongCodeError(validationResult.getErrors().get(0).getErrorCodeMessage()));
        }
        return this.ok();
    }

    @Override
    public Response isRequired2fa(HttpServletRequest request, HttpServletResponse response) {
        return this.serviceDeskService.isRequired2fa(request, response) ? this.ok() : this.badRequest();
    }

    @Override
    public Response bulkResetTwoFactor(HttpServletRequest request, HttpServletResponse response, BulkResetDTO bulkResetDTO) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, response);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        validationResult = this.configurationService.getAuthTrustedBulkEnable() ? this.trustedUserValidation.validate(request.getSession()) : this.adminPermittedValidation.validate(request.getSession());
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        validationResult = this.bulkResetDTOValidator.validate(bulkResetDTO);
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        this.totpService.bulkReset(bulkResetDTO, request);
        return this.ok();
    }

    private Response getBadValidationResponse(ValidationResult validationResult) {
        try {
            return this.badRequest(mapper.writeValueAsString(validationResult.getErrors()));
        }
        catch (JsonProcessingException e) {
            log.error("Can't convert errors to JSON", e);
            return this.badRequest();
        }
    }
}

