/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.rest.impl;

import com.alphaserve.twofactor.core.dtolayer.dtos.ConfigDTO;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.PluginInfoService;
import com.alphaserve.twofactor.core.services.rest.ConfigRestService;
import com.alphaserve.twofactor.core.validation.AdminPermittedValidation;
import com.alphaserve.twofactor.core.validation.XsrfTokenValidator;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.alphaserve.twofactor.core.validation.core.Validator;
import com.fasterxml.jackson.core.JsonProcessingException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ConfigRestServiceImpl
implements ConfigRestService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigRestServiceImpl.class);
    private static final String CHECKED_VALUE = "true";
    private Validator<ConfigDTO> configDTOValidator;
    private AdminPermittedValidation adminPermittedValidation;
    private final ConfigurationService configurationService;
    private final PluginInfoService pluginInfoService;
    private final XsrfTokenValidator xsrfTokenValidator;

    @Inject
    public ConfigRestServiceImpl(Validator<ConfigDTO> configDTOValidator, AdminPermittedValidation adminPermittedValidation, ConfigurationService configurationService, PluginInfoService pluginInfoService, XsrfTokenValidator xsrfTokenValidator) {
        this.configDTOValidator = configDTOValidator;
        this.adminPermittedValidation = adminPermittedValidation;
        this.configurationService = configurationService;
        this.pluginInfoService = pluginInfoService;
        this.xsrfTokenValidator = xsrfTokenValidator;
    }

    @Override
    public Response resetToDefault(HttpServletRequest request, HttpServletResponse response) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, response);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        validationResult = this.adminPermittedValidation.validate(request.getSession());
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        this.pluginInfoService.deleteAllData();
        return this.ok();
    }

    @Override
    public Response saveConfigurations(HttpServletRequest request, HttpServletResponse response, ConfigDTO configDTO) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, response);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        validationResult = this.adminPermittedValidation.validate(request.getSession());
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        validationResult = this.configDTOValidator.validate(configDTO);
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        this.configurationService.saveAdminConfiguration(configDTO);
        return this.ok();
    }

    private Response getBadValidationResponse(ValidationResult validationResult) {
        try {
            return this.badRequest(mapper.writeValueAsString(validationResult.getErrors()));
        }
        catch (JsonProcessingException e) {
            log.error("Can't convert errors to JSON", e);
            return this.badRequest();
        }
    }
}

