/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.rest.core;

import com.alphaserve.twofactor.core.dtolayer.dtos.PaginationWrapper;
import com.alphaserve.twofactor.core.validation.core.ValidationError;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.atlassian.activeobjects.tx.Transactional;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.ws.rs.core.Response;

@Transactional
public interface RestService {
    public static final ObjectMapper mapper = new ObjectMapper();

    default public Response badRequest() {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    default public Response badRequest(String value) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)value).build();
    }

    default public Response badRequest(List<ValidationError> errors) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(errors).build();
    }

    default public Response notFoundRequest(String value) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)value).build();
    }

    default public Response ok(String value) {
        return Response.ok((Object)value).build();
    }

    default public Response ok(boolean value) {
        return Response.ok((Object)value).build();
    }

    default public Response ok(PaginationWrapper<?> value) {
        return Response.ok(value).build();
    }

    default public Response ok(List<?> values) {
        return Response.ok(values).entity(values).build();
    }

    default public Response ok() {
        return Response.ok().build();
    }

    default public Response getNotFoundValidationResponse(ValidationResult validationResult) {
        return this.notFoundRequest(validationResult.getErrors().get(0).getErrorCodeMessage());
    }
}

