/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.impl;

import com.alphaserve.twofactor.core.model.AuthType;
import com.alphaserve.twofactor.core.model.LogActionType;
import com.alphaserve.twofactor.core.services.AuthLoginService;
import com.alphaserve.twofactor.core.services.LoginActionService;
import com.alphaserve.twofactor.core.services.entities.FailLogin2FAService;
import com.alphaserve.twofactor.core.services.entities.IpFilterService;
import com.alphaserve.twofactor.core.services.entities.LoggerActionService;
import com.alphaserve.twofactor.core.services.entities.RememberMeService;
import com.atlassian.sal.api.user.UserProfile;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Named
public class LoginActionServiceImpl
implements LoginActionService {
    private final RememberMeService rememberMeService;
    private final AuthLoginService authLoginService;
    private final IpFilterService ipFilterService;
    private final LoggerActionService loggerActionService;
    private final FailLogin2FAService failLogin2FAService;

    @Inject
    public LoginActionServiceImpl(RememberMeService rememberMeService, AuthLoginService authLoginService, IpFilterService ipFilterService, LoggerActionService loggerActionService, FailLogin2FAService failLogin2FAService) {
        this.rememberMeService = rememberMeService;
        this.authLoginService = authLoginService;
        this.ipFilterService = ipFilterService;
        this.loggerActionService = loggerActionService;
        this.failLogin2FAService = failLogin2FAService;
    }

    @Override
    public void login(UserProfile userProfile, HttpServletRequest req, HttpServletResponse resp, AuthType authType, boolean rememberMe) {
        LogActionType pass2faSuccess;
        this.authLoginService.login2fa(req.getSession());
        switch (authType) {
            case TOTP_ENABLE_SECURITY_KEY: {
                pass2faSuccess = LogActionType.ADD;
                break;
            }
            default: {
                pass2faSuccess = LogActionType.PASS_2FA_SUCCESS;
            }
        }
        this.loggerActionService.add(userProfile.getUsername(), pass2faSuccess, this.ipFilterService.getClientIpAddress(req));
        this.rememberMeService.rememberUser(req, resp, rememberMe);
        this.rememberMeService.rememberUserClusterSession(req, resp);
    }

    @Override
    public void failLogin(UserProfile userProfile, HttpServletRequest request) {
        this.loggerActionService.add(userProfile.getUsername(), LogActionType.PASS_2FA_FAILED, this.ipFilterService.getClientIpAddress(request));
        this.failLogin2FAService.add(userProfile.getUserKey().getStringValue(), this.failLogin2FAService.convertIpToString(this.ipFilterService.getClientIpAddress(request)));
    }
}

