/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.impl;

import com.alphaserve.twofactor.core.Plugin2FACoreContext;
import com.alphaserve.twofactor.core.dtolayer.dtos.ConfigDTO;
import com.alphaserve.twofactor.core.model.IpValidator;
import com.alphaserve.twofactor.core.model.entities.IpFilter;
import com.alphaserve.twofactor.core.model.entities.cache.wraper.WhitelistUrlsCacheWrapper;
import com.alphaserve.twofactor.core.model.exceptions.ParseIPException;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.entities.IpFilterService;
import com.alphaserve.twofactor.core.utils.StringUsefulUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.Arrays;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ConfigurationServiceImpl
implements ConfigurationService {
    protected final PluginSettings ps;
    protected final IpFilterService ipFilterService;
    protected final Plugin2FACoreContext pluginContext;
    protected final WhitelistUrlsCacheWrapper cachedWhitelistUrls;
    private static final Logger log = LoggerFactory.getLogger(ConfigurationServiceImpl.class);

    @Inject
    public ConfigurationServiceImpl(@ComponentImport PluginSettingsFactory pluginSettingsFactory, IpFilterService ipFilterService, Plugin2FACoreContext pluginContext) {
        this.ps = pluginSettingsFactory.createGlobalSettings();
        this.ipFilterService = ipFilterService;
        this.pluginContext = pluginContext;
        this.cachedWhitelistUrls = new WhitelistUrlsCacheWrapper();
        this.cachedWhitelistUrls.cacheUpdatedWhitelistUrls(this.loadSettingPlugin("whitelistUrls", ""));
    }

    @Override
    public int getAuthKeySize() {
        try {
            return Integer.parseInt(this.loadSettingPlugin("authKeySize", this.pluginContext.getDefaultKeySize() + ""));
        }
        catch (NumberFormatException e) {
            return this.pluginContext.getDefaultKeySize();
        }
    }

    @Override
    public String getAuthLabel() {
        return this.loadSettingPlugin("authLabel", this.pluginContext.getDefaultAuthLabel());
    }

    @Override
    public Long getTimeStep() {
        try {
            return Long.parseLong(this.loadSettingPlugin("authTimeStep", this.pluginContext.getDefaultTimeStep() + ""));
        }
        catch (NumberFormatException e) {
            return Integer.toUnsignedLong(this.pluginContext.getDefaultTimeStep());
        }
    }

    @Override
    public String[] getAuthForceGroupsList() {
        return this.loadSettingPlugin("authForceGroupsList", this.pluginContext.getDefaultForceGroupsList()).split(",");
    }

    @Override
    public String[] getAuthForceAllExceptGroupsList() {
        return this.loadArraySettingPlugin("authForceAllExceptGroupsList", new String[0]);
    }

    @Override
    public String getAuthForceType() {
        return this.loadSettingPlugin("authForceType", this.pluginContext.getDefaultForceType());
    }

    @Override
    public int getRememberMeExpireHours() {
        try {
            return Integer.parseInt(this.loadSettingPlugin("rememberMeExpireHours", this.pluginContext.getDefaultRememberMeExpireHours() + ""));
        }
        catch (NumberFormatException e) {
            return this.pluginContext.getDefaultRememberMeExpireHours();
        }
    }

    @Override
    public boolean getAuthLoggerEnable() {
        return this.loadSettingPluginBoolean("authLoggerEnable", true);
    }

    @Override
    public boolean getAuthIPWhitelistEnable() {
        return this.loadSettingPluginBoolean("authIpWhitelistEnable", false);
    }

    @Override
    public boolean getAuthU2FEnable() {
        return this.loadSettingPluginBoolean("authU2FEnable", true);
    }

    @Override
    public boolean getRememberMeFeatureEnable() {
        return this.loadSettingPluginBoolean("authRememberMeEnable", false);
    }

    @Override
    public boolean getAuthDuoEnable() {
        return this.loadSettingPluginBoolean("authDuoEnable", false);
    }

    @Override
    public boolean getOAuthWhitelistEnable() {
        return this.loadSettingPluginBoolean("oauthWhitelistEnable", false);
    }

    @Override
    public boolean getAuthBruteForceEnable() {
        return this.loadSettingPluginBoolean("authBruteForceEnable", false);
    }

    @Override
    public int getNumberAttempts() {
        try {
            return Integer.parseInt(this.loadSettingPlugin("numberAttempts", "3"));
        }
        catch (NumberFormatException e) {
            return 3;
        }
    }

    @Override
    public int getLockoutPeriod() {
        try {
            return Integer.parseInt(this.loadSettingPlugin("lockoutPeriod", "15"));
        }
        catch (NumberFormatException e) {
            return 15;
        }
    }

    @Override
    public boolean getAutoLoginEnable() {
        return this.loadSettingPluginBoolean("autoLoginEnable", false);
    }

    @Override
    public boolean getHideDeactivate2fa() {
        return this.loadSettingPluginBoolean("hideDeactivate2fa", false);
    }

    @Override
    public boolean getHide2faInServiceDesk() {
        return this.loadSettingPluginBoolean("hide2faInServiceDesk", false);
    }

    @Override
    public String getAuthPermissionType() {
        return this.loadSettingPlugin("authPermissionType", "permissionNone");
    }

    @Override
    public String getAuthLimitationType() {
        return this.loadSettingPlugin("permissionLimitationType", "permissionLimitationNone");
    }

    @Override
    public String[] getAuthPermissionGroupsList() {
        return this.loadArraySettingPlugin("authPermissionGroupsList", new String[0]);
    }

    @Override
    public String[] getAuthPermissionUsersList() {
        return this.loadArraySettingPlugin("authPermissionUsersList", new String[0]);
    }

    @Override
    public String[] getAuthLimitationGroupsList() {
        return this.loadArraySettingPlugin("limitationGroupsList", new String[0]);
    }

    @Override
    public String[] getAuthLimitationUsersList() {
        return this.loadArraySettingPlugin("limitationUsersList", new String[0]);
    }

    @Override
    public boolean getAuthTrustedBulkEnable() {
        return this.loadSettingPluginBoolean("authTrustedBulkEnable", false);
    }

    @Override
    public boolean getRestEndpointsRestriction() {
        return this.loadSettingPluginBoolean("restEndpointsRestriction", false);
    }

    @Override
    public void setAuthKeySize(String authKeySize) {
        this.ps.put("authKeySize", (Object)authKeySize);
    }

    @Override
    public void setAuthLabel(String authLabel) {
        this.ps.put("authLabel", (Object)authLabel);
    }

    @Override
    public void setTimeStep(String timeStep) {
        this.ps.put("authTimeStep", (Object)timeStep);
    }

    @Override
    public void setAuthForceGroupsList(String[] authForceGroupsList, String forceType) {
        if (Objects.isNull(authForceGroupsList)) {
            return;
        }
        String groups = StringUsefulUtils.getComaSplitStringFromList(Arrays.asList(authForceGroupsList));
        if (forceType.equals("forceGroups")) {
            this.ps.put("authForceGroupsList", (Object)groups);
        }
    }

    @Override
    public void setAuthForceAllExceptGroupsList(String[] authForceAllExceptGroupsList, String forceType) {
        if (Objects.isNull(authForceAllExceptGroupsList)) {
            authForceAllExceptGroupsList = new String[]{};
        }
        String groups = StringUsefulUtils.getComaSplitStringFromList(Arrays.asList(authForceAllExceptGroupsList));
        if (forceType.equals("forceAllExceptGroups")) {
            this.ps.put("authForceAllExceptGroupsList", (Object)groups);
        }
    }

    @Override
    public void setAuthForceType(String authForceType) {
        this.ps.put("authForceType", (Object)authForceType);
    }

    @Override
    public void setRememberMeExpireHours(String rememberMeExpireHours) {
        this.ps.put("rememberMeExpireHours", (Object)rememberMeExpireHours);
    }

    @Override
    public void setAuthLoggerEnable(boolean authLoggerEnable) {
        this.ps.put("authLoggerEnable", (Object)Boolean.toString(authLoggerEnable));
    }

    @Override
    public void setAuthIPWhitelistEnable(boolean authIPWhitelistEnable) {
        this.ps.put("authIpWhitelistEnable", (Object)Boolean.toString(authIPWhitelistEnable));
    }

    @Override
    public void setAuthU2FEnable(boolean authU2FEnable) {
        this.ps.put("authU2FEnable", (Object)Boolean.toString(authU2FEnable));
    }

    @Override
    public void setRememberMeFeatureEnable(boolean rememberMeFeatureEnable) {
        this.ps.put("authRememberMeEnable", (Object)Boolean.toString(rememberMeFeatureEnable));
    }

    @Override
    public void setHideDeactivate2fa(boolean hide) {
        this.ps.put("hideDeactivate2fa", (Object)Boolean.toString(hide));
    }

    @Override
    public void setHide2faInServiceDesk(boolean hide) {
        this.ps.put("hide2faInServiceDesk", (Object)Boolean.toString(hide));
    }

    @Override
    public boolean isUserInIpWhitelist(HttpServletRequest request) {
        if (this.getAuthIPWhitelistEnable()) {
            for (IpFilter ipFilter : this.ipFilterService.getAll()) {
                try {
                    IpValidator ipValidator = new IpValidator(ipFilter.getIpAddress());
                    if (!ipValidator.matches(this.ipFilterService.getClientIpAddress(request), ipFilter.isLocalIp())) continue;
                    return true;
                }
                catch (ParseIPException e) {
                    log.warn("2FA plugin warn: Failed to parse ip address");
                }
            }
        }
        return false;
    }

    @Override
    public String[] getAuthForceDirectoriesList() {
        return this.loadArraySettingPlugin("directoriesList", new String[0]);
    }

    @Override
    public String[] getAuthForceAllExceptDirectoriesList() {
        return this.loadArraySettingPlugin("authForceAllExceptDirectoriesList", new String[0]);
    }

    @Override
    public boolean getAllowedToSkimByPlugin() {
        return this.loadSettingPluginBoolean("allowedToSkimByPlugin", false);
    }

    @Override
    public void saveAdminConfiguration(ConfigDTO configDTO) {
        this.ipFilterService.overrideWhiteFilters(configDTO.getWhitelistNameSetting(), configDTO.getWhitelistIpSetting(), configDTO.getWhitelistIpConfig());
        this.setAuthForceType(configDTO.getAuthForceType());
        this.setAuthForceGroupsList(configDTO.getAuthForceGroupsList(), configDTO.getAuthForceType());
        this.setAuthForceAllExceptGroupsList(configDTO.getAuthForceAllExceptGroupsList(), configDTO.getAuthForceType());
        this.setAuthLabel(configDTO.getAuthLabel());
        this.setAuthLoggerEnable(Objects.nonNull(configDTO.getAuthLoggerEnable()));
        this.setAuthIPWhitelistEnable(Objects.nonNull(configDTO.getAuthIpWhitelistEnable()));
        this.setAuthKeySize(configDTO.getAuthKeySize());
        this.setTimeStep(configDTO.getAuthTimeStep());
        this.setAuthU2FEnable(Objects.nonNull(configDTO.getAuthU2FEnable()));
        this.setRememberMeFeatureEnable(Objects.nonNull(configDTO.getAuthRememberMeEnable()));
        if (Objects.nonNull(configDTO.getAuthRememberMeEnable())) {
            this.setRememberMeExpireHours(configDTO.getRememberMeExpireHours());
        }
        this.setAuthDuoEnable(Objects.nonNull(configDTO.getAuthDuoEnable()));
        this.setOAuthWhitelistEnable(Objects.nonNull(configDTO.getOauthWhitelistEnable()));
        this.setAuthBruteForceEnable(Objects.nonNull(configDTO.getAuthBruteForceEnable()));
        this.setNumberAttempts(configDTO.getNumberAttempts());
        this.setLockoutPeriod(configDTO.getLockoutPeriod());
        this.setHideDeactivate2fa(Objects.nonNull(configDTO.getHideDeactivate2fa()));
        this.setHide2faInServiceDesk(Objects.nonNull(configDTO.getHide2faInServiceDesk()));
        this.setAutoLoginEnable(Objects.nonNull(configDTO.getAutoLoginEnable()));
        this.setAuthPermissionType(configDTO.getAuthPermissionType());
        this.setAuthLimitationType(configDTO.getPermissionLimitationType());
        this.setAuthPermissionGroupsList(configDTO.getAuthPermissionGroupsList(), configDTO.getAuthPermissionType());
        this.setAuthPermissionUsersList(configDTO.getAuthPermissionUsersList(), configDTO.getAuthPermissionType());
        this.setAuthLimitationGroupsList(configDTO.getLimitationGroupsList(), configDTO.getPermissionLimitationType());
        this.setAuthLimitationUsersList(configDTO.getLimitationUsersList(), configDTO.getPermissionLimitationType());
        this.setAuthTrustedBulkEnable(Objects.nonNull(configDTO.getAuthTrustedBulkEnable()));
        this.setRestEndpointsRestriction(Objects.nonNull(configDTO.getRestEndpointsRestriction()));
        this.setWebAuthnAttestationType(configDTO.getWebAuthnAttestationType());
        this.setWebAuthnAuthenticatorType(configDTO.getWebAuthnAuthenticatorType());
        this.setWebAuthnUserVerification(configDTO.getWebAuthnUserVerification());
        this.setWebAuthnResidentKey(configDTO.isWebAuthnResidentKey());
        this.setWhitelistUrls(configDTO.getWhitelistUrls().trim());
        this.setAuthForceDirectoriesList(configDTO.getDirectoriesList(), configDTO.getAuthForceType());
        this.setAuthForceAllExceptDirectoriesList(configDTO.getAuthForceAllExceptDirectoriesList(), configDTO.getAuthForceType());
        this.setAllowedToSkimByPlugin(Objects.nonNull(configDTO.getAllowedToSkimByPlugin()));
    }

    @Override
    public void setAuthDuoEnable(boolean authDuoEnable) {
        this.ps.put("authDuoEnable", (Object)Boolean.toString(authDuoEnable));
    }

    @Override
    public void setOAuthWhitelistEnable(boolean oAuthWhitelistEnable) {
        this.ps.put("oauthWhitelistEnable", (Object)Boolean.toString(oAuthWhitelistEnable));
    }

    @Override
    public void setAuthBruteForceEnable(boolean enable) {
        this.ps.put("authBruteForceEnable", (Object)Boolean.toString(enable));
    }

    @Override
    public void setNumberAttempts(String numberAttempts) {
        this.ps.put("numberAttempts", (Object)numberAttempts);
    }

    @Override
    public void setLockoutPeriod(String lockoutPeriod) {
        this.ps.put("lockoutPeriod", (Object)lockoutPeriod);
    }

    @Override
    public void setAutoLoginEnable(boolean autoLoginEnable) {
        this.ps.put("autoLoginEnable", (Object)Boolean.toString(autoLoginEnable));
    }

    @Override
    public void setAuthPermissionType(String authPermissionType) {
        this.ps.put("authPermissionType", (Object)authPermissionType);
    }

    @Override
    public void setAuthLimitationType(String authLimitationType) {
        this.ps.put("permissionLimitationType", (Object)authLimitationType);
    }

    @Override
    public void setAuthPermissionGroupsList(String[] authPermissionGroupsList, String permissionType) {
        if (Objects.isNull(authPermissionGroupsList)) {
            authPermissionGroupsList = new String[]{};
        }
        String groups = StringUsefulUtils.getComaSplitStringFromList(Arrays.asList(authPermissionGroupsList));
        if (permissionType.equals("permissionGroups")) {
            this.ps.put("authPermissionGroupsList", (Object)groups);
        }
    }

    @Override
    public void setAuthPermissionUsersList(String[] authPermissionUsersList, String permissionType) {
        if (Objects.isNull(authPermissionUsersList)) {
            authPermissionUsersList = new String[]{};
        }
        String users = StringUsefulUtils.getComaSplitStringFromList(Arrays.asList(authPermissionUsersList));
        if (permissionType.equals("permissionUsers")) {
            this.ps.put("authPermissionUsersList", (Object)users);
        }
    }

    @Override
    public void setAuthLimitationGroupsList(String[] authLimitationGroupsList, String permissionType) {
        if (Objects.isNull(authLimitationGroupsList)) {
            authLimitationGroupsList = new String[]{};
        }
        String groups = StringUsefulUtils.getComaSplitStringFromList(Arrays.asList(authLimitationGroupsList));
        if (permissionType.equals("permissionLimitationGroups")) {
            this.ps.put("limitationGroupsList", (Object)groups);
        }
    }

    @Override
    public void setAuthLimitationUsersList(String[] authLimitationUsersList, String permissionType) {
        if (Objects.isNull(authLimitationUsersList)) {
            authLimitationUsersList = new String[]{};
        }
        String users = StringUsefulUtils.getComaSplitStringFromList(Arrays.asList(authLimitationUsersList));
        if (permissionType.equals("permissionLimitationUsers")) {
            this.ps.put("limitationUsersList", (Object)users);
        }
    }

    @Override
    public void setAuthTrustedBulkEnable(boolean authTrustedBulkEnable) {
        this.ps.put("authTrustedBulkEnable", (Object)Boolean.toString(authTrustedBulkEnable));
    }

    @Override
    public void setRestEndpointsRestriction(boolean endpointsRestriction) {
        this.ps.put("restEndpointsRestriction", (Object)Boolean.toString(endpointsRestriction));
    }

    protected String[] loadArraySettingPlugin(String settingName, String[] defaultValue) {
        String settingResult = (String)this.ps.get(settingName);
        if (Objects.isNull(settingResult) || settingResult.isEmpty()) {
            return defaultValue;
        }
        return settingResult.split(",");
    }

    @Override
    public String getWebAuthnAttestationType() {
        return this.loadSettingPlugin("webAuthnAttestationType", this.pluginContext.getDefaultAttestationType());
    }

    @Override
    public void setWebAuthnAttestationType(String type) {
        this.ps.put("webAuthnAttestationType", (Object)type);
    }

    @Override
    public String getWebAuthnAuthenticatorType() {
        return this.loadSettingPlugin("webAuthnAuthenticatorType", null);
    }

    @Override
    public void setWebAuthnAuthenticatorType(String type) {
        this.ps.put("webAuthnAuthenticatorType", (Object)type);
    }

    @Override
    public String getWebAuthnUserVerification() {
        return this.loadSettingPlugin("webAuthnUserVerification", this.pluginContext.getDefaultUserVerification());
    }

    @Override
    public void setWebAuthnUserVerification(String value) {
        this.ps.put("webAuthnUserVerification", (Object)value);
    }

    @Override
    public boolean getWebAuthnResidentKey() {
        return this.loadSettingPluginBoolean("webAuthnResidentKey", Boolean.parseBoolean(this.pluginContext.getDefaultResidentKey()));
    }

    @Override
    public void setWebAuthnResidentKey(boolean use) {
        this.setWebAuthnResidentKey(Boolean.toString(use));
    }

    @Override
    public void setWebAuthnResidentKey(String use) {
        this.ps.put("webAuthnResidentKey", (Object)use);
    }

    @Override
    public void setWhitelistUrls(String whitelistUrls) {
        this.ps.put("whitelistUrls", (Object)whitelistUrls);
        this.cachedWhitelistUrls.cacheUpdatedWhitelistUrls(whitelistUrls);
    }

    @Override
    public String[] getWhitelistUrls() {
        return this.cachedWhitelistUrls.getWhitelistUrls();
    }

    @Override
    public void setAuthForceDirectoriesList(String[] authForceDirectoriesList, String forceType) {
        if (Objects.isNull(authForceDirectoriesList)) {
            authForceDirectoriesList = new String[]{};
        }
        String groups = StringUsefulUtils.getComaSplitStringFromList(Arrays.asList(authForceDirectoriesList));
        if (forceType.equals("forceDirectories")) {
            this.ps.put("directoriesList", (Object)groups);
        }
    }

    @Override
    public void setAuthForceAllExceptDirectoriesList(String[] authForceAllExceptDirectoriesList, String forceType) {
        if (Objects.isNull(authForceAllExceptDirectoriesList)) {
            authForceAllExceptDirectoriesList = new String[]{};
        }
        String groups = StringUsefulUtils.getComaSplitStringFromList(Arrays.asList(authForceAllExceptDirectoriesList));
        if (forceType.equals("forceAllExceptDirectories")) {
            this.ps.put("authForceAllExceptDirectoriesList", (Object)groups);
        }
    }

    @Override
    public void setAllowedToSkimByPlugin(boolean allowedToSkimByPlugin) {
        this.ps.put("allowedToSkimByPlugin", (Object)Boolean.toString(allowedToSkimByPlugin));
    }

    protected String loadSettingPlugin(String settingName, String defaultValue) {
        String settingResult = (String)this.ps.get(settingName);
        if (Objects.isNull(settingResult)) {
            try {
                this.ps.put(settingName, (Object)defaultValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defaultValue;
        }
        return settingResult;
    }

    protected boolean loadSettingPluginBoolean(String settingName, boolean defaultSetting) {
        String settingResult = (String)this.ps.get(settingName);
        String defaultValue = Boolean.toString(defaultSetting);
        if (Objects.isNull(settingResult)) {
            try {
                this.ps.put(settingName, (Object)defaultValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defaultSetting;
        }
        return Boolean.parseBoolean(settingResult);
    }
}

