/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.export.impl;

import com.alphaserve.twofactor.core.dtolayer.dtos.logger.LogActionDTO;
import com.alphaserve.twofactor.core.services.export.ExcelExportService;
import com.alphaserve.twofactor.core.services.export.OwnTimeZoneManager;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

@Named
public class CsvExportService
extends ExcelExportService {
    @Inject
    public CsvExportService(I18nResolver i18nResolver, OwnTimeZoneManager timeZoneManager) {
        super(i18nResolver, timeZoneManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteArrayOutputStream getLogs(List<LogActionDTO> logs) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        this.generate(workbook, sheet, logs);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        CSVPrinter csvPrinter = null;
        try {
            csvPrinter = new CSVPrinter(new OutputStreamWriter(outputStream), CSVFormat.DEFAULT);
            Iterator<Row> rowIterator = sheet.rowIterator();
            while (rowIterator.hasNext()) {
                Row row = rowIterator.next();
                Iterator<Cell> cellIterator = row.cellIterator();
                while (cellIterator.hasNext()) {
                    Cell cell = cellIterator.next();
                    switch (cell.getCellType()) {
                        case STRING: {
                            csvPrinter.print(cell.getStringCellValue());
                            break;
                        }
                        case NUMERIC: {
                            if (cell.getCellStyle().getDataFormat() == 164) {
                                SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                date.setTimeZone(this.timeZoneManager.getUserTimeZone());
                                csvPrinter.print(date.format(cell.getDateCellValue()));
                                break;
                            }
                            csvPrinter.print(cell.getNumericCellValue());
                            break;
                        }
                        case BOOLEAN: {
                            csvPrinter.print(cell.getBooleanCellValue());
                            break;
                        }
                        case BLANK: {
                            csvPrinter.print("");
                        }
                    }
                }
                csvPrinter.println();
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        finally {
            try {
                if (csvPrinter != null) {
                    csvPrinter.flush();
                    csvPrinter.close();
                }
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
            }
            catch (IOException ioe) {
                this.logger.error(ioe.getMessage());
            }
        }
        return outputStream;
    }
}

