/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.entities.impl;

import com.alphaserve.twofactor.core.dtolayer.dtos.IpFilterDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.IpRepresentation;
import com.alphaserve.twofactor.core.model.IpHeaderModels;
import com.alphaserve.twofactor.core.model.entities.IpFilter;
import com.alphaserve.twofactor.core.services.database.TwoFADatabaseToolkit;
import com.alphaserve.twofactor.core.services.entities.IpFilterService;
import com.alphaserve.twofactor.core.utils.IpUtils;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class IpFilterServiceImpl
implements IpFilterService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IpFilterServiceImpl.class);
    protected final TwoFADatabaseToolkit dbToolkit;
    private static final String IP_REMOTE_HEADER = "REQ_REMOTE_ADDR";

    @Inject
    public IpFilterServiceImpl(TwoFADatabaseToolkit dbToolkit) {
        this.dbToolkit = dbToolkit;
    }

    @Override
    public List<IpFilter> getAll() {
        IpFilter[] ipFilters = this.dbToolkit.useActiveObjects(ao -> (IpFilter[])ao.executeInTransaction(() -> (IpFilter[])ao.find(IpFilter.class, Query.select())), this.dbToolkit::returnNull);
        if (ipFilters == null) {
            return new ArrayList<IpFilter>();
        }
        return Lists.newArrayList(ipFilters);
    }

    @Override
    public void deleteById(int id) {
        this.dbToolkit.useActiveObjects(ao -> ao.executeInTransaction(() -> ao.deleteWithSQL(IpFilter.class, "ID = ?", new Object[]{id})));
    }

    @Override
    public void deleteAll() {
        this.dbToolkit.useActiveObjects(ao -> ao.executeInTransaction(() -> ao.deleteWithSQL(IpFilter.class, "ID > ?", new Object[]{-1})));
    }

    @Override
    public IpFilter getById(int id) {
        return this.dbToolkit.useActiveObjects(ao -> (IpFilter)ao.executeInTransaction(() -> (IpFilter)ao.get(IpFilter.class, (Object)id)), this.dbToolkit::returnNull);
    }

    @Override
    public IpFilter add(IpFilterDTO ipFilterDTO) {
        return this.add(ipFilterDTO.getIpConfig(), ipFilterDTO.getIpName(), ipFilterDTO.isLocal());
    }

    public IpFilter add(String ipConfig, String name, boolean isLocal) {
        return this.dbToolkit.useActiveObjects(ao -> (IpFilter)ao.executeInTransaction(() -> {
            IpFilter ipFilter = (IpFilter)ao.create(IpFilter.class, new DBParam[0]);
            ipFilter.setIpAddress(ipConfig);
            ipFilter.setIpName(name);
            ipFilter.setLocalIp(isLocal);
            ipFilter.save();
            return ipFilter;
        }), this.dbToolkit::returnNull);
    }

    @Override
    public void overrideWhiteFilters(String[] filterNames, String[] filterIps, Boolean[] filterLocalSet) {
        this.deleteAll();
        if (Objects.isNull(filterNames) || Objects.isNull(filterIps) || Objects.isNull(filterLocalSet)) {
            return;
        }
        for (int i = 0; i < filterIps.length; ++i) {
            this.add(filterIps[i], filterNames[i], filterLocalSet[i]);
        }
    }

    @Override
    public List<IpRepresentation> getClientIpAddress(HttpServletRequest request) {
        ArrayList<IpRepresentation> ipAddresses = new ArrayList<IpRepresentation>();
        for (String header : IpHeaderModels.IP_HEADER_ALL_CANDIDATES) {
            String ip = request.getHeader(header);
            ipAddresses.addAll(this.getValidIpAddresses(ip, header));
        }
        ipAddresses.add(new IpRepresentation(request.getRemoteAddr(), IP_REMOTE_HEADER));
        return ipAddresses;
    }

    private List<IpRepresentation> getValidIpAddresses(String headerIp, String header) {
        String[] split;
        ArrayList<IpRepresentation> validIpAddresses = new ArrayList<IpRepresentation>();
        if (Objects.isNull(headerIp)) {
            return validIpAddresses;
        }
        for (String ipEntry : split = headerIp.split(", ")) {
            if (!Objects.nonNull(ipEntry) || ipEntry.isEmpty() || "unknown".equalsIgnoreCase(ipEntry)) continue;
            try {
                ipEntry = IpUtils.substringPort(ipEntry);
                InetAddress.getByName(ipEntry);
                validIpAddresses.add(new IpRepresentation(ipEntry, header));
            }
            catch (UnknownHostException e) {
                log.error("Wrong IP", e);
            }
        }
        return validIpAddresses;
    }
}

