/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.entities.impl;

import com.alphaserve.twofactor.core.model.entities.Credential;
import com.alphaserve.twofactor.core.services.database.TwoFADatabaseToolkit;
import com.alphaserve.twofactor.core.services.entities.CredentialService;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Named
@Component
public class CredentialServiceImpl
implements CredentialService {
    @ComponentImport
    protected final UserManager salUserManager;
    protected final TwoFADatabaseToolkit dbToolkit;

    @Inject
    public CredentialServiceImpl(@Qualifier(value="userManager") UserManager salUserManager, TwoFADatabaseToolkit dbToolkit) {
        this.salUserManager = salUserManager;
        this.dbToolkit = dbToolkit;
    }

    @Override
    public Credential add(String userKey, String publicKeyCose, String type, String keyId, String userIdentityId, String name, Date createdAt) {
        return this.dbToolkit.useActiveObjects(ao -> (Credential)ao.executeInTransaction(() -> {
            Credential credential = (Credential)ao.create(Credential.class, new DBParam[0]);
            credential.setUserKey(userKey);
            credential.setPublicKeyCose(publicKeyCose);
            credential.setType(type);
            credential.setKeyId(keyId);
            credential.setCreatedAt(createdAt);
            credential.setUserIdentityId(userIdentityId);
            credential.setName(name);
            credential.save();
            return credential;
        }), this.dbToolkit::returnNull);
    }

    @Override
    public Credential getById(int id) {
        return this.dbToolkit.useActiveObjects(ao -> (Credential)ao.executeInTransaction(() -> (Credential)ao.get(Credential.class, (Object)id)), this.dbToolkit::returnNull);
    }

    @Override
    public boolean deleteByIdAndUserKey(Long id, String userKey) {
        return this.dbToolkit.useActiveObjects(ao -> ao.deleteWithSQL(Credential.class, "ID = ? AND USER_KEY = ?", new Object[]{id, userKey}) > 0, this.dbToolkit::returnFalse);
    }

    @Override
    public List<Credential> getByUserKey(String userKey) {
        return this.dbToolkit.useActiveObjects(ao -> {
            Query query = Query.select().where("USER_KEY = ?", new Object[]{userKey});
            Credential[] userCredentials = (Credential[])ao.executeInTransaction(() -> (Credential[])ao.find(Credential.class, query));
            return this.getResult(userCredentials);
        }, Collections::emptyList);
    }

    @Override
    public Set<Credential> getSetByUserKey(String userKey) {
        return new HashSet<Credential>(this.getByUserKey(userKey));
    }

    @Override
    public List<Credential> getByUserIdentityId(String identityId) {
        return this.dbToolkit.useActiveObjects(ao -> {
            Query query = this.isPostgreSQL() ? Query.select().where("to_char(USER_IDENTITY_ID) = ?", new Object[]{identityId}) : Query.select().where("USER_IDENTITY_ID = ?", new Object[]{identityId});
            Credential[] userCredentials = (Credential[])ao.executeInTransaction(() -> (Credential[])ao.find(Credential.class, query));
            return this.getResult(userCredentials);
        }, Collections::emptyList);
    }

    @Override
    public List<Credential> getByUserIdentityIdAndKeyId(String userIdentityId, String keyId) {
        return this.dbToolkit.useActiveObjects(ao -> {
            Query query = this.isPostgreSQL() ? Query.select().where("to_char(USER_IDENTITY_ID) = ? AND to_char(KEY_ID) = ?", new Object[]{userIdentityId, keyId}) : Query.select().where("USER_IDENTITY_ID = ? AND KEY_ID = ?", new Object[]{userIdentityId, keyId});
            Credential[] userCredentials = (Credential[])ao.executeInTransaction(() -> (Credential[])ao.find(Credential.class, query));
            return this.getResult(userCredentials);
        }, Collections::emptyList);
    }

    @Override
    public List<Credential> getByKeyId(String keyId) {
        return this.dbToolkit.useActiveObjects(ao -> {
            Query query = this.isPostgreSQL() ? Query.select().where("to_char(KEY_ID) = ?", new Object[]{keyId}) : Query.select().where("KEY_ID = ?", new Object[]{keyId});
            Credential[] userCredentials = (Credential[])ao.executeInTransaction(() -> (Credential[])ao.find(Credential.class, query));
            return this.getResult(userCredentials);
        }, Collections::emptyList);
    }

    @Override
    public void delete(Credential credential) {
        this.dbToolkit.useActiveObjects(ao -> ao.delete(new RawEntity[]{credential}));
    }

    private List<Credential> getResult(Credential[] credentials) {
        if (Objects.isNull(credentials)) {
            return new ArrayList<Credential>();
        }
        return Arrays.asList(credentials);
    }

    @Override
    public long getCredentialCountByName(String name, String userKey) {
        return this.dbToolkit.useActiveObjects(ao -> (Integer)ao.executeInTransaction(() -> ao.count(Credential.class, Query.select().where("NAME = ? AND USER_KEY = ?", new Object[]{name, userKey}))), () -> 0).intValue();
    }

    @Override
    public void deleteList(List<Credential> credentials) {
        for (Credential credential : credentials) {
            this.delete(credential);
        }
    }

    @Override
    public boolean hasRemoteUserU2FDevice() {
        UserProfile remoteUser = this.salUserManager.getRemoteUser();
        if (Objects.isNull(remoteUser)) {
            return false;
        }
        return this.dbToolkit.useActiveObjects(ao -> (Integer)ao.executeInTransaction(() -> ao.count(Credential.class, Query.select().where("USER_KEY = ?", new Object[]{remoteUser.getUserKey().getStringValue()}))) > 0, this.dbToolkit::returnFalse);
    }

    @Override
    public void deleteByUserKey(String userKey) {
        this.dbToolkit.useActiveObjects(ao -> ao.deleteWithSQL(Credential.class, "USER_KEY = ?", new Object[]{userKey}));
    }

    private boolean isPostgreSQL() {
        return this.dbToolkit.openAOModuleMetaData().getDatabaseType().equals((Object)DatabaseType.ORACLE);
    }
}

