/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.model;

import com.alphaserve.twofactor.core.Plugin2FACoreContext;
import com.alphaserve.twofactor.core.model.AuthLoggerJob;
import com.alphaserve.twofactor.core.services.entities.RememberMeService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component(value="RememberMeCleanerService")
public class RememberMeCleanerService
implements LifecycleAware {
    private static final long INTERVAL_MILLIS = 86400000L;
    private static final String REMEMBER_ME_JOB_RUNNER = "RememberMeJobRunner";
    private static final Logger log = LoggerFactory.getLogger(RememberMeCleanerService.class);
    @ComponentImport
    private final SchedulerService schedulerService;
    private final RememberMeService rememberMeService;
    private final JobRunnerKey jobRunnerKey;
    private final JobId jobId;

    @Autowired
    public RememberMeCleanerService(SchedulerService schedulerService, RememberMeService rememberMeService, Plugin2FACoreContext pluginContext) {
        this.schedulerService = schedulerService;
        this.rememberMeService = rememberMeService;
        this.jobRunnerKey = JobRunnerKey.of((String)(pluginContext.getPluginKey() + ":" + REMEMBER_ME_JOB_RUNNER));
        this.jobId = JobId.of((String)(pluginContext.getPluginKey() + ":" + REMEMBER_ME_JOB_RUNNER));
    }

    public void onStart() {
        Schedule schedule = Schedule.forInterval((long)86400000L, (Date)new Date(System.currentTimeMillis() + 86400000L));
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)this.jobRunnerKey).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(schedule);
        try {
            this.schedulerService.registerJobRunner(this.jobRunnerKey, (JobRunner)new AuthLoggerJob(this.rememberMeService));
            this.schedulerService.scheduleJob(this.jobId, jobConfig);
            log.info("RememberMeCleanerService JobRunner Registered");
        }
        catch (SchedulerServiceException e) {
            log.error("RememberMeCleanerService job cannot be created: {}", (Object)e.getMessage());
        }
    }

    public void onStop() {
        log.info("Stopping RememberMeCleanerService Job Runner");
        this.schedulerService.unregisterJobRunner(this.jobRunnerKey);
    }
}

