/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.model;

import java.text.SimpleDateFormat;
import java.util.Date;

public class FiltersAggregate {
    private String username;
    private Date startDate;
    private Date finishDate;
    private String action;
    private String userIp;

    public FiltersAggregate(String username, String startDate, String finishDate, String action, String userIp) {
        this.username = username;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.startDate = this.parseDate(startDate, dateFormat, "00:00:00");
        this.finishDate = this.parseDate(finishDate, dateFormat, "23:59:59");
        this.action = action;
        this.userIp = userIp;
    }

    private Date parseDate(String date, SimpleDateFormat dateFormat, String time) {
        try {
            return dateFormat.parse(date + " " + time);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date getFinishDate() {
        return this.finishDate;
    }

    public String getUsername() {
        return this.username;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public String getAction() {
        return this.action;
    }

    public String getUserIp() {
        return this.userIp;
    }
}

