/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.factory;

import com.alphaserve.twofactor.core.dtolayer.dtos.wrapper.UrlRecord;
import java.net.URL;
import java.util.Objects;
import lombok.NonNull;

public final class UrlRecordFactory {
    private UrlRecordFactory() {
    }

    public static UrlRecord createUrlRecord(String baseUrl, String url) {
        return new UrlRecord(baseUrl, url);
    }

    public static UrlRecord autoResolveAndCreateUrlRecord(String baseUrl, @NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (Objects.isNull(baseUrl)) {
            return new UrlRecord(url);
        }
        return UrlRecordFactory.createUrlRecord(baseUrl, url);
    }

    public static UrlRecord[] autoResolveAndCreateUrlRecords(String baseUrl, String ... args) {
        UrlRecord[] records = new UrlRecord[args.length];
        for (int i = 0; i < records.length; ++i) {
            records[i] = UrlRecordFactory.autoResolveAndCreateUrlRecord(baseUrl, args[i]);
        }
        return records;
    }

    public static UrlRecord[] autoResolveAndCreateUrlRecords(@NonNull URL baseUrl, String ... urls) {
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        return UrlRecordFactory.autoResolveAndCreateUrlRecords(baseUrl.getPath(), urls);
    }
}

