/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.dtolayer.dtos.wrapper;

import com.alphaserve.twofactor.core.utils.UrlUtils;
import java.util.Objects;

public class UrlRecord {
    private final String rawUrl;
    private final String urlPart;

    public UrlRecord(String urlPart) {
        this.rawUrl = null;
        this.urlPart = urlPart;
    }

    public UrlRecord(String baseUrl, String urlPart) {
        this.rawUrl = UrlUtils.concatenateUrlParts(baseUrl, urlPart);
        this.urlPart = urlPart;
    }

    public boolean containsRawUrlInSource(String source) {
        return source.contains(this.rawUrl);
    }

    public boolean startsWithRawUrlInSource(String source) {
        return source.startsWith(this.rawUrl);
    }

    public boolean containsUrlPartInSource(String source) {
        return source.contains(this.urlPart);
    }

    public boolean startsWithPartInSource(String source) {
        return source.startsWith(this.urlPart);
    }

    public String getUrl() {
        return Objects.nonNull(this.rawUrl) ? this.rawUrl : this.urlPart;
    }
}

