/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.dtolayer.dtos;

import java.util.Objects;
import javax.annotation.Nullable;
import lombok.Generated;

public class PersonDTO {
    @Nullable
    private Boolean active = null;
    private String username;
    private String email;
    private String key;

    public static PersonDTO createActiveUser(String email, String name, String key) {
        return new PersonDTO(true, email, name, key);
    }

    public static PersonDTO createActiveUser(PersonDTO personDTO) {
        return PersonDTO.createActiveUser(personDTO.email, personDTO.username, personDTO.key);
    }

    public static PersonDTO createInactiveUser(String email, String name, String key) {
        return new PersonDTO(false, email, name, key);
    }

    public static PersonDTO createInactiveUser(PersonDTO personDTO) {
        return PersonDTO.createInactiveUser(personDTO.email, personDTO.username, personDTO.key);
    }

    public boolean isActiveIn2FA() {
        return Objects.nonNull(this.active) && this.active != false;
    }

    public boolean isInactiveIn2FA() {
        return !this.isActiveIn2FA();
    }

    @Generated
    public static PersonDTOBuilder builder() {
        return new PersonDTOBuilder();
    }

    @Generated
    public PersonDTO(@Nullable Boolean active, String username, String email, String key) {
        this.active = active;
        this.username = username;
        this.email = email;
        this.key = key;
    }

    @Generated
    public PersonDTO() {
    }

    @Nullable
    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public void setActive(@Nullable Boolean active) {
        this.active = active;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PersonDTO)) {
            return false;
        }
        PersonDTO other = (PersonDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PersonDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PersonDTO(active=" + this.getActive() + ", username=" + this.getUsername() + ", email=" + this.getEmail() + ", key=" + this.getKey() + ")";
    }

    @Generated
    public static class PersonDTOBuilder {
        @Generated
        private Boolean active;
        @Generated
        private String username;
        @Generated
        private String email;
        @Generated
        private String key;

        @Generated
        PersonDTOBuilder() {
        }

        @Generated
        public PersonDTOBuilder active(@Nullable Boolean active) {
            this.active = active;
            return this;
        }

        @Generated
        public PersonDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public PersonDTOBuilder email(String email) {
            this.email = email;
            return this;
        }

        @Generated
        public PersonDTOBuilder key(String key) {
            this.key = key;
            return this;
        }

        @Generated
        public PersonDTO build() {
            return new PersonDTO(this.active, this.username, this.email, this.key);
        }

        @Generated
        public String toString() {
            return "PersonDTO.PersonDTOBuilder(active=" + this.active + ", username=" + this.username + ", email=" + this.email + ", key=" + this.key + ")";
        }
    }
}

