/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.dtolayer.converter;

import com.alphaserve.twofactor.core.dtolayer.converter.DoForwardConverter;
import com.alphaserve.twofactor.core.dtolayer.dtos.U2FDeviceRepresentation;
import com.alphaserve.twofactor.core.model.entities.U2FDevice;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.LocaleResolver;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class U2FDeviceDTOConverter
implements DoForwardConverter<U2FDevice, U2FDeviceRepresentation> {
    @ComponentImport
    private final LocaleResolver localeResolver;

    @Inject
    public U2FDeviceDTOConverter(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }

    @Override
    public U2FDeviceRepresentation doForward(U2FDevice entity) {
        Locale locale = this.localeResolver.getLocale();
        String createdAt = new SimpleDateFormat("MMMM dd, yyyy", locale).format(entity.getCreatedAt());
        return U2FDeviceRepresentation.builder().id(entity.getID()).creationDate(createdAt).name(entity.getName()).userId(entity.getUserId()).userKey(entity.getUserKey()).username(entity.getUsername()).build();
    }
}

