/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.dtolayer.converter;

import com.alphaserve.twofactor.core.dtolayer.converter.DTOConverter;
import com.alphaserve.twofactor.core.dtolayer.dtos.SecretKeyRepresentation;
import com.alphaserve.twofactor.core.model.entities.SecretKey;
import com.alphaserve.twofactor.core.services.entities.SecretKeyService;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class SecretKeyDTOConverter
implements DTOConverter<SecretKey, SecretKeyRepresentation> {
    private final SecretKeyService secretKeyService;

    @Inject
    public SecretKeyDTOConverter(SecretKeyService secretKeyService) {
        this.secretKeyService = secretKeyService;
    }

    @Override
    public SecretKey doForward(SecretKeyRepresentation dto) {
        return this.secretKeyService.getByKey(dto.getAuthenticatorKey(), dto.getKey());
    }

    @Override
    public SecretKeyRepresentation doBackward(SecretKey entity) {
        return new SecretKeyRepresentation(entity.getAuthId(), entity.getKey());
    }
}

