/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.dtolayer.converter;

import com.alphaserve.twofactor.core.dtolayer.converter.DoForwardConverter;
import com.alphaserve.twofactor.core.dtolayer.dtos.U2FDeviceRepresentation;
import com.alphaserve.twofactor.core.model.entities.Credential;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.LocaleResolver;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class CredentionnalDTOConverter
implements DoForwardConverter<Credential, U2FDeviceRepresentation> {
    @ComponentImport
    private final LocaleResolver localeResolver;

    @Inject
    public CredentionnalDTOConverter(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }

    @Override
    public U2FDeviceRepresentation doForward(Credential credential) {
        Locale locale = this.localeResolver.getLocale();
        String createdAt = new SimpleDateFormat("MMMM dd, yyyy", locale).format(credential.getCreatedAt());
        return U2FDeviceRepresentation.builder().id(credential.getID()).name(credential.getName()).creationDate(createdAt).build();
    }
}

