/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.dtolayer.converter;

import com.alphaserve.twofactor.core.dtolayer.converter.DoForwardConverter;
import com.alphaserve.twofactor.core.dtolayer.dtos.CredentialDTO;
import com.alphaserve.twofactor.core.model.entities.Credential;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.LocaleResolver;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.stereotype.Component;

@Named
@Component
public class CredentialDTOConverterIml
implements DoForwardConverter<Credential, CredentialDTO> {
    @ComponentImport
    private final LocaleResolver localeResolver;

    @Inject
    public CredentialDTOConverterIml(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }

    @Override
    public CredentialDTO doForward(Credential entity) {
        Locale locale = this.localeResolver.getLocale();
        String createdAt = new SimpleDateFormat("MMMM dd, yyyy", locale).format(entity.getCreatedAt());
        return CredentialDTO.builder().id(entity.getID()).creationDate(createdAt).name(entity.getName()).build();
    }
}

