/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.confluence.authplugin.services;

import com.alphaserve.twofactor.core.dtolayer.converter.DoForwardConverter;
import com.alphaserve.twofactor.core.dtolayer.dtos.CommonTwoFANextPageDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.GroupDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.PersonDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.TwoFAPage;
import com.alphaserve.twofactor.core.dtolayer.dtos.TwoFAPageRequest;
import com.alphaserve.twofactor.core.services.AuthLoginService;
import com.alphaserve.twofactor.core.services.UserActionService;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerException;
import com.atlassian.user.search.query.EmailTermQuery;
import com.atlassian.user.search.query.GroupNameTermQuery;
import com.atlassian.user.search.query.MultiTermBooleanQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.UserNameTermQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class UserActionServiceImpl
implements UserActionService {
    private static final Logger logger = LoggerFactory.getLogger(UserActionService.class);
    private static final int MATCHING_RULE_SELECTION_TRIGGER = 1000;
    @ConfluenceImport
    private final UserAccessor userAccessor;
    private final AuthLoginService authLoginService;
    private final DoForwardConverter<User, PersonDTO> personDTOConverter;
    private final DoForwardConverter<Group, GroupDTO> groupDTOConverter;

    @Inject
    public UserActionServiceImpl(UserAccessor userAccessor, AuthLoginService authLoginService, DoForwardConverter<User, PersonDTO> personDTOConverter, DoForwardConverter<Group, GroupDTO> groupDTOConverter) {
        this.userAccessor = userAccessor;
        this.personDTOConverter = personDTOConverter;
        this.authLoginService = authLoginService;
        this.groupDTOConverter = groupDTOConverter;
    }

    private boolean hasNextPage(int nextPage, Pager<?> pager) {
        try {
            pager.skipTo(nextPage);
            return true;
        }
        catch (PagerException ignore) {
            return false;
        }
    }

    private TwoFAPage<PersonDTO> collectUsers(int currentPage, int limit, Pager<User> pager) {
        int localLimit = limit + 1;
        int startFrom = limit * currentPage % 100;
        int page = (currentPage + 1) * limit / 100;
        ArrayList<PersonDTO> result = new ArrayList<PersonDTO>(localLimit);
        while (this.hasNextPage(page++, pager)) {
            int index = 0;
            for (User user : pager) {
                if (index++ >= startFrom) {
                    result.add(this.personDTOConverter.doForward(user));
                }
                if (result.size() < localLimit) continue;
                break;
            }
            if (index >= 100) continue;
            break;
        }
        CommonTwoFANextPageDTO nextPageInfo = null;
        if (result.size() >= localLimit) {
            nextPageInfo = new CommonTwoFANextPageDTO(currentPage + 1);
        }
        return new TwoFAPage<PersonDTO>(nextPageInfo, (PersonDTO[])result.stream().limit(limit).toArray(PersonDTO[]::new));
    }

    private String selectMatchingRuleForUser(List<User> users) {
        return users.size() < 1000 ? "contains" : "starts_with";
    }

    @Override
    public List<PersonDTO> findUsers(String username) {
        List usersAsList;
        try {
            List firstPageOfUsers = this.userAccessor.getUsers().getCurrentPage();
            usersAsList = StringUtil.isBlank(username) ? firstPageOfUsers.stream().limit(30L).collect(Collectors.toList()) : this.userAccessor.findUsersAsList((Query)new UserNameTermQuery(username, this.selectMatchingRuleForUser(firstPageOfUsers)));
        }
        catch (EntityException e) {
            logger.info("Username #" + username + " not found");
            return new ArrayList<PersonDTO>();
        }
        return this.personDTOConverter.doForwardList(usersAsList);
    }

    @Override
    public TwoFAPage<PersonDTO> findUsers(String name, TwoFAPageRequest pageRequest) {
        try {
            int currentPage = CommonTwoFANextPageDTO.getPageValueFromPageRequest(pageRequest);
            Pager pager = this.userAccessor.findUsers((Query)new UserNameTermQuery(name, "contains")).pager();
            return this.collectUsers(currentPage, pageRequest.getLimit(), (Pager<User>)pager);
        }
        catch (EntityException exception) {
            logger.error("Something went wrong in 'findUsers'", exception);
            return TwoFAPage.emptyPage(PersonDTO.class);
        }
    }

    @Override
    public TwoFAPage<PersonDTO> findUsersByEmail(String email, TwoFAPageRequest pageRequest) {
        try {
            int currentPage = CommonTwoFANextPageDTO.getPageValueFromPageRequest(pageRequest);
            Pager pager = this.userAccessor.findUsers((Query)new EmailTermQuery(email, "contains")).pager();
            return this.collectUsers(currentPage, pageRequest.getLimit(), (Pager<User>)pager);
        }
        catch (EntityException exception) {
            logger.error("Something went wrong in 'findUsersByEmail'", exception);
            return TwoFAPage.emptyPage(PersonDTO.class);
        }
    }

    @Override
    public TwoFAPage<PersonDTO> requestedActiveUser(TwoFAPageRequest pageRequest) {
        int currentPage = CommonTwoFANextPageDTO.getPageValueFromPageRequest(pageRequest);
        Pager pager = this.userAccessor.getUsers();
        return this.collectUsers(currentPage, pageRequest.getLimit(), (Pager<User>)pager);
    }

    @Override
    public List<GroupDTO> findGroups(String name) {
        try {
            List groups = this.userAccessor.findGroups((Query)new GroupNameTermQuery(name, "contains")).pager().getCurrentPage().stream().limit(15L).collect(Collectors.toList());
            return this.groupDTOConverter.doForwardList(groups);
        }
        catch (EntityException e) {
            logger.info("Group with name #" + name + " not found");
            return new ArrayList<GroupDTO>();
        }
    }

    @Override
    public void logout(HttpServletRequest request, HttpServletResponse response) {
        this.authLoginService.logout2fa(request.getSession());
        request.getSession().setAttribute("seraph_defaultauthenticator_user", null);
    }

    @Override
    public List<String> findUsersKeyByGroup(String groupName) {
        Iterable members = this.userAccessor.getMembers(this.userAccessor.getGroup(groupName));
        ArrayList<String> usersKey = new ArrayList<String>();
        for (ConfluenceUser user : members) {
            usersKey.add(user.getKey().getStringValue());
        }
        return usersKey;
    }

    @Override
    public List<PersonDTO> findSelectedUsers(String ... usernames) {
        if (usernames.length > 0) {
            try {
                Query[] queries = (Query[])Arrays.stream(usernames).map(UserNameTermQuery::new).toArray(UserNameTermQuery[]::new);
                return this.personDTOConverter.doForwardList(this.userAccessor.findUsersAsList(MultiTermBooleanQuery.anyOf((Query[])queries)));
            }
            catch (EntityException e) {
                logger.info("Usernames {} not found", (Object)Arrays.toString(usernames));
            }
        }
        return new ArrayList<PersonDTO>();
    }
}

