/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.confluence.authplugin.resources;

import com.alphaserve.twofactor.core.dtolayer.dtos.BulkResetDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.MobileLoginDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.TOTPLoginDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.TOTPMobileLoginDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.UsernameDTO;
import com.alphaserve.twofactor.core.services.rest.TOTPRestService;
import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.xwork.RequireSecurityToken;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Named
@Path(value="/totp_resources")
public class TOTPResources {
    private TOTPRestService totpRestService;
    @ComponentImport(value="com.atlassian.confluence.api.service.accessmode.AccessModeService")
    private final AccessModeService accessModeService;

    @Inject
    public TOTPResources(TOTPRestService totpRestService, AccessModeService accessModeService) {
        this.totpRestService = totpRestService;
        this.accessModeService = accessModeService;
    }

    @POST
    @Produces(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/reset_user_2fa")
    public final Response resetUser2FA(@Context HttpServletRequest request, @Context HttpServletResponse response, UsernameDTO usernameDTO) {
        return this.totpRestService.resetTwoFactorForUser(request, response, usernameDTO);
    }

    @POST
    @Produces(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/login")
    @ReadOnlyAccessAllowed
    public final Response login(@Context HttpServletRequest request, @Context HttpServletResponse response, TOTPLoginDTO totpLoginDTO) {
        return this.totpRestService.login(request, response, totpLoginDTO);
    }

    @GET
    @Produces(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/get_qr_image")
    public final Response generateQRImage() {
        return this.totpRestService.generateQRImage();
    }

    @POST
    @Produces(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/disable_totp")
    public final Response disableTOTP(@Context HttpServletRequest request, @Context HttpServletResponse response) {
        return this.totpRestService.disableTOTP(request, response);
    }

    @POST
    @Produces(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/enable_totp")
    public final Response enableTotp(@Context HttpServletRequest request, @Context HttpServletResponse response, TOTPLoginDTO totpLoginDTO) {
        return this.totpRestService.enableTOTP(request, response, totpLoginDTO);
    }

    @GET
    @Produces(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/get_totp")
    public final Response getTOTP() {
        return this.totpRestService.getTOTP();
    }

    @POST
    @Produces(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/reserve_key_login")
    @ReadOnlyAccessAllowed
    public final Response reserveCodeLogin(@Context HttpServletRequest request, @Context HttpServletResponse response, TOTPLoginDTO totpLoginDTO) {
        return this.totpRestService.loginWithReserveCode(request, response, totpLoginDTO, this.accessModeService.isReadOnlyAccessModeEnabled());
    }

    @POST
    @Produces(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/finish_registration")
    public final Response finishRegistration(@Context HttpServletRequest request, @Context HttpServletResponse response) {
        return this.totpRestService.finishRegistration(request, response);
    }

    @POST
    @Produces(value={"application/json"})
    @AnonymousSiteAccess
    @Path(value="/is_allowed")
    public final Response isAllowed(@Context HttpServletRequest request, @Context HttpServletResponse response, MobileLoginDTO mobileLoginDTO) {
        return this.totpRestService.isAllowedMobile(request, response, mobileLoginDTO);
    }

    @POST
    @Produces(value={"application/json"})
    @AnonymousSiteAccess
    @Path(value="/validate")
    public final Response login(@Context HttpServletRequest request, @Context HttpServletResponse response, TOTPMobileLoginDTO totpMobileLoginDTO) {
        return this.totpRestService.validateTOTP(request, totpMobileLoginDTO);
    }

    @POST
    @Produces(value={"application/json"})
    @RequireSecurityToken(value=true)
    @Path(value="/bulk_reset_2fa")
    public final Response bulkReset2FA(@Context HttpServletRequest request, @Context HttpServletResponse response, BulkResetDTO bulkResetDTO) {
        return this.totpRestService.bulkResetTwoFactor(request, response, bulkResetDTO);
    }
}

