AJS.$(document).ready(function () {
    window.onbeforeunload = null;

    var u2fDeviceAddFlowContainer = AJS.$(".u2f-device-add-flow-container");
    var u2fDeviceAddInitContainer = AJS.$(".u2f-device-add-init-container");
    var u2fDeviceAddNameContainer = AJS.$(".u2f-device-add-name-container");
    var u2fDeviceAddActionContainer = AJS.$(".u2f-device-add-action-container");

    var u2fAddDeviceButton = AJS.$(".u2f-device-control-add-button");
    var u2fAddDeviceSubmitNameButton = AJS.$(".u2f-device-control-add-name-button");

    var u2fAddDeviceNameInput = AJS.$("#u2f-add-device-name-input");
    var atlToken = AJS.$("input:hidden[name=atl_token]");

    u2fAddDeviceSubmitNameButton.unbind("click");
    u2fAddDeviceSubmitNameButton.bind("click", function () {
        submitU2FAddNameDevice();
    });

    u2fAddDeviceButton.unbind("click");
    u2fAddDeviceButton.bind("click", function () {
        initU2FRegisterDevice();
    });

    function initU2FRegisterDevice() {
        u2fDeviceAddFlowContainer.hide();
        u2fDeviceAddNameContainer.show();
    }

    function submitU2FAddNameDevice() {
        u2fDeviceAddFlowContainer.hide();
        u2fDeviceAddActionContainer.show();
        initU2fRegister();
    }

    function returnU2FStartPositionAddDevice() {
        u2fDeviceAddFlowContainer.hide();
        u2fDeviceAddInitContainer.show();
        u2fAddDeviceNameInput.val("");
    }


    function initU2fRegister() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/webauth_resources/init_registration?atl_token=" + atlToken.val(),
            type: "POST",
            dataType: "JSON",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify({
                name: u2fAddDeviceNameInput.val()
            }),
            cache: false,
            success: function (data) {
                initRegistration(data);
            },
            error: function (data) {
                returnU2FStartPositionAddDevice();
                parseUserErrors(data);
            }
        });
    }

    function initRegistration(data) {
        data.challenge = stringToByteArray(data.challenge);
        data.user.id = stringToByteArray(data.user.id);
        data.excludeCredentials = data.excludeCredentials.map(function (credential) {
            credential.id = stringToByteArray(credential.id);
            return credential;
        });
        navigator.credentials.create({
            publicKey: data
        }).then(function (publicKeyCredential) {
            if (publicKeyCredential.response instanceof AuthenticatorAttestationResponse) {
                registerPublicKeyCredential(publicKeyCredential);
            } else {
                alphaServe2FAErrorMessageFlag(AJS.I18n.getText("webauthn.register.public.key.error"));
            }
        }, function (error) {
            if (error.name === 'InvalidStateError' && messageNotSupportedByBrowser()) {
                alphaServe2FAErrorMessageFlag(AJS.I18n.getText("webauthn.user.config.credential.already.exist"));
            } else if (error.name !== 'InvalidStateError' && error.name !== 'NotAllowedError') {
                if (error.message) {
                    alphaServe2FAErrorMessageFlag(error.message);
                }
            } else {
                if (error.message) {
                    alphaServe2FAErrorMessageFlag(error.message);
                    console.error(error.message);
                } else {
                    alphaServe2FAErrorMessageFlag(AJS.I18n.getText("auth.text.generic.error.something-went-wrong"));
                }
                console.error(error);
            }
            returnU2FStartPositionAddDevice();
        }).catch(function (error) {
            alphaServe2FAErrorMessageFlag(error.message);
            console.error(error);
        })
    }

    function registerPublicKeyCredential(publicKeyCredential) {
        var clientExtensionResults = [];

        try {
            clientExtensionResults = publicKeyCredential.getClientExtensionResults();
        } catch (e) {
            alphaServe2FAErrorMessageFlag(AJS.I18n.getText("webauthn.register.public.key.error"));
        }

        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/webauth_resources/finish_registration?atl_token=" + atlToken.val(),
            type: "POST",
            data: JSON.stringify({
                id: publicKeyCredential.id,
                type: publicKeyCredential.type,
                response: {
                    attestationObject: arrayBufferToString(publicKeyCredential.response.attestationObject),
                    clientDataJSON: arrayBufferToString(publicKeyCredential.response.clientDataJSON),
                },
                clientExtensionResults: clientExtensionResults
            }),
            contentType: "application/json; charset=utf-8",
            dataType: "text",
            cache: false,
            success: function (data) {
                returnU2FStartPositionAddDevice();
                getRemoteUserU2FDevices(atlToken.val());
                alphaServe2FASuccessMessageFlag(AJS.I18n.getText("webauthn.register.credential.added"));
            },
            error: function (data) {
                returnU2FStartPositionAddDevice();
                alphaServe2FAErrorMessageFlag(AJS.I18n.getText("auth.text.unknown-error"));
            }
        });
        returnU2FStartPositionAddDevice();
    }
});