var REQUESTED_TASK = null;
const REQUEST_DELAY = 500;
const LIMIT_OF_USERS_ON_THE_PAGE = 500;
const TWOFA_APP_CONTEXT = {
    private: {
        altToken: null,
    },
    elements: {
        loaderBlock: null,
        emptyTableMessageBlock: null,
        tableBlock: {
            rootElement: null,
            tableElement: null,
            allUsersMessage: null,
            tableBodyElement: null,
            tableLimitMessage: null,
            form: {
                searchInputElement: null,
                userStatusElement: {
                    rootElement: null,
                    wrapper: null,
                },
                rootElement: null,
            },
            paginationBlock: {
                rootElement: null,
                loadMoreButton: null,
            },
        },
    },
    fields: {
        nextPageInfo: null,
        totalNumberOfUsers: 0,
        showStatuses: 'SHOW_ALL',
        searchBy: 'USER_NAME',
        search: '',
    },
};

function showLoader() {
    TWOFA_APP_CONTEXT.elements.emptyTableMessageBlock.hide();
    TWOFA_APP_CONTEXT.elements.tableBlock.allUsersMessage.hide();
    TWOFA_APP_CONTEXT.elements.tableBlock.paginationBlock.loadMoreButton.hide();
    TWOFA_APP_CONTEXT.elements.loaderBlock.show();
}

function hideLoader() {
    TWOFA_APP_CONTEXT.elements.loaderBlock.hide();
}

function buildHTMLForNewRow(userData) {
    const status = userData.active
        ? '<span class="aui-icon aui-icon-small aui-iconfont-check-circle-filled" role="img" aria-label="active-user"></span>'
        : '<span class="aui-icon aui-icon-small aui-iconfont-cross-circle" role="img" aria-label="inactive-user"></span>';
    const email = userData.email;
    const name = userData.username;
    return '<tr>'
        + '<td>' + status + '</td>'
        + '<td>' + name + '</td>'
        + '<td>' + email + '</td>'
        + '</tr>';
}

function doRequest(requestFunc, delay) {
    if (REQUESTED_TASK !== null) {
        clearInterval(REQUESTED_TASK);
    }

    REQUESTED_TASK = setTimeout(requestFunc, delay);
}

function get2FAUsers() {
    showLoader();
    AJS.$.ajax({
        url: AJS.contextPath() + "/rest/authpluginresources/1.0/tfausers/getUsers?atl_token=" + TWOFA_APP_CONTEXT.private.altToken.val(),
        type: "POST",
        contentType: "application/json; charset=utf-8",
        dataType: 'json',
        data: JSON.stringify({
            searchValue: TWOFA_APP_CONTEXT.fields.search,
            searchBy: TWOFA_APP_CONTEXT.fields.searchBy,
            userState: TWOFA_APP_CONTEXT.fields.showStatuses,
            platformBasedNextPageInfo: TWOFA_APP_CONTEXT.fields.nextPageInfo,
        }),
        success: function (data) {
            if (data.result.length > 0) {
                TWOFA_APP_CONTEXT.fields.totalNumberOfUsers += data.result.length;
                const withinLimits = TWOFA_APP_CONTEXT.fields.totalNumberOfUsers <= LIMIT_OF_USERS_ON_THE_PAGE;

                if (data.platformBasedPageInfo && withinLimits) {
                    TWOFA_APP_CONTEXT.elements.tableBlock.tableLimitMessage.hide();
                    TWOFA_APP_CONTEXT.elements.tableBlock.paginationBlock.loadMoreButton.show();
                } else {
                    TWOFA_APP_CONTEXT.elements.tableBlock.paginationBlock.loadMoreButton.hide();

                    if (!withinLimits) {
                        TWOFA_APP_CONTEXT.elements.tableBlock.tableLimitMessage.show();
                    } else {
                        TWOFA_APP_CONTEXT.elements.tableBlock.allUsersMessage.show();
                    }
                }

                const usersHtml = data.result.map(function (userData) {
                    return buildHTMLForNewRow(userData);
                }).join('');

                TWOFA_APP_CONTEXT.elements.emptyTableMessageBlock.hide();
                TWOFA_APP_CONTEXT.elements.tableBlock.rootElement.show();
                TWOFA_APP_CONTEXT.elements.tableBlock.tableElement.show();
                const tablePtr = TWOFA_APP_CONTEXT.elements.tableBlock.tableBodyElement;
                tablePtr.html(tablePtr.html() + usersHtml);
            } else {
                TWOFA_APP_CONTEXT.elements.tableBlock.tableElement.hide();
                TWOFA_APP_CONTEXT.elements.emptyTableMessageBlock.show();
            }

            TWOFA_APP_CONTEXT.fields.nextPageInfo = data.platformBasedPageInfo;
            hideLoader();
        }
    });
}

function setDefaultSettings() {
    TWOFA_APP_CONTEXT.fields.nextPageInfo = null;
    TWOFA_APP_CONTEXT.fields.totalNumberOfUsers = 0;
    TWOFA_APP_CONTEXT.elements.tableBlock.tableBodyElement.empty();
}

function disableUserStatusElement() {
    TWOFA_APP_CONTEXT.elements.tableBlock.form.userStatusElement.rootElement.prop('disabled', true);
    TWOFA_APP_CONTEXT.elements.tableBlock.form.userStatusElement.wrapper.css('opacity', '0.5');
}

function enableUserStatusElement() {
    TWOFA_APP_CONTEXT.elements.tableBlock.form.userStatusElement.rootElement.prop('disabled', false);
    TWOFA_APP_CONTEXT.elements.tableBlock.form.userStatusElement.wrapper.css('opacity', '1');
}

function init2FAUsersPage() {
    TWOFA_APP_CONTEXT.private.altToken = AJS.$("input:hidden[name=atl_token]");
    TWOFA_APP_CONTEXT.elements.loaderBlock = AJS.$("#two-fa-loader");
    TWOFA_APP_CONTEXT.elements.emptyTableMessageBlock = AJS.$("#empty-table-message-block");
    TWOFA_APP_CONTEXT.elements.tableBlock.rootElement = AJS.$("#table-block");
    TWOFA_APP_CONTEXT.elements.tableBlock.tableElement = AJS.$("#table-block-table");
    TWOFA_APP_CONTEXT.elements.tableBlock.allUsersMessage = AJS.$("#table-block-all-users-message");
    TWOFA_APP_CONTEXT.elements.tableBlock.tableBodyElement = AJS.$("#table-body");
    TWOFA_APP_CONTEXT.elements.tableBlock.tableLimitMessage = AJS.$("#table-block-pagination-message");
    TWOFA_APP_CONTEXT.elements.tableBlock.paginationBlock.rootElement = AJS.$("#table-block-pagination");
    TWOFA_APP_CONTEXT.elements.tableBlock.paginationBlock.loadMoreButton = AJS.$("#table-block-load-more-button");
    TWOFA_APP_CONTEXT.elements.tableBlock.form.searchInputElement = AJS.$("#twofa-search-input");
    TWOFA_APP_CONTEXT.elements.tableBlock.form.rootElement = AJS.$("#table-block-from");
    TWOFA_APP_CONTEXT.elements.tableBlock.form.userStatusElement.rootElement = AJS.$("#twofa-user-status").auiSelect2();
    TWOFA_APP_CONTEXT.elements.tableBlock.form.userStatusElement.wrapper = AJS.$("#table-block-twofa-user-status-wrapper");

    const twoFaSearchBySelect = AJS.$("#twofa-search-by");

    TWOFA_APP_CONTEXT.elements.tableBlock.form.searchInputElement.on("keyup", function () {
        TWOFA_APP_CONTEXT.fields.search = this.value;

        if (TWOFA_APP_CONTEXT.fields.search) {
            showLoader();
            setDefaultSettings();
            doRequest(get2FAUsers, REQUEST_DELAY);
            disableUserStatusElement();
        } else {
            enableUserStatusElement();
        }
    });
    AJS.$("#twofa-user-status").change(function () {
        TWOFA_APP_CONTEXT.fields.showStatuses = this.value;
        setDefaultSettings();
        get2FAUsers();
    });
    AJS.$("#table-block-load-more-button").on('click', function () {
        TWOFA_APP_CONTEXT.elements.tableBlock.paginationBlock.loadMoreButton.hide();
        get2FAUsers();
    });
    AJS.$("#table-block-clean-input-button").on('click', function () {
        TWOFA_APP_CONTEXT.fields.search = "";
        TWOFA_APP_CONTEXT.elements.tableBlock.form.searchInputElement.val("");
        showLoader();
        setDefaultSettings();
        doRequest(get2FAUsers, REQUEST_DELAY);
        enableUserStatusElement();
    });
    twoFaSearchBySelect.change(function () {
        TWOFA_APP_CONTEXT.fields.searchBy = this.value;
    });

    if (twoFaSearchBySelect.children().length > 1) {
        AJS.$("#twofa-search-by").auiSelect2();
    } else {
        twoFaSearchBySelect.hide();
    }

    get2FAUsers();
}

AJS.$(document).ready(init2FAUsersPage);
