/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.fasterxml.jackson.databind.JsonNode;
import com.yubico.internal.util.CertificateParser;
import com.yubico.webauthn.data.AttestationObject;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

interface X5cAttestationStatementVerifier {
    default public Optional<X509Certificate> getX5cAttestationCertificate(AttestationObject attestationObject) throws CertificateException {
        return this.getAttestationTrustPath(attestationObject).flatMap(certs -> certs.stream().findFirst());
    }

    default public Optional<List<X509Certificate>> getAttestationTrustPath(AttestationObject attestationObject) throws CertificateException {
        JsonNode x5cNode = this.getX5cArray(attestationObject);
        if (x5cNode != null && x5cNode.isArray()) {
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(x5cNode.size());
            for (JsonNode binary : x5cNode) {
                if (binary.isBinary()) {
                    try {
                        certs.add(CertificateParser.parseDer(binary.binaryValue()));
                        continue;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("binary.isBinary() was true but binary.binaryValue() failed", e);
                    }
                }
                throw new IllegalArgumentException(String.format("Each element of \"x5c\" property of attestation statement must be a binary value, was: %s", new Object[]{binary.getNodeType()}));
            }
            return Optional.of(certs);
        }
        return Optional.empty();
    }

    default public JsonNode getX5cArray(AttestationObject attestationObject) {
        return attestationObject.getAttestationStatement().get("x5c");
    }
}

