/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.upokecenter.cbor.CBORObject;
import com.yubico.internal.util.BinaryUtil;
import com.yubico.internal.util.ByteInputStream;
import com.yubico.internal.util.CertificateParser;
import com.yubico.internal.util.ExceptionUtil;
import com.yubico.webauthn.AttestationStatementVerifier;
import com.yubico.webauthn.Crypto;
import com.yubico.webauthn.WebAuthnCodecs;
import com.yubico.webauthn.X5cAttestationStatementVerifier;
import com.yubico.webauthn.data.AttestationObject;
import com.yubico.webauthn.data.AttestationType;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.COSEAlgorithmIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TpmAttestationStatementVerifier
implements AttestationStatementVerifier,
X5cAttestationStatementVerifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TpmAttestationStatementVerifier.class);
    private static final String TPM_VER = "2.0";
    static final ByteArray TPM_GENERATED_VALUE = ByteArray.fromBase64("/1RDRw==");
    static final ByteArray TPM_ST_ATTEST_CERTIFY = ByteArray.fromBase64("gBc=");
    static final int TPM_ALG_NULL = 16;
    private static final String OID_TCG_AT_TPM_MANUFACTURER = "2.23.133.2.1";
    private static final String OID_TCG_AT_TPM_MODEL = "2.23.133.2.2";
    private static final String OID_TCG_AT_TPM_VERSION = "2.23.133.2.3";

    TpmAttestationStatementVerifier() {
    }

    @Override
    public AttestationType getAttestationType(AttestationObject attestation) {
        return AttestationType.ATTESTATION_CA;
    }

    @Override
    public boolean verifyAttestationSignature(AttestationObject attestationObject, ByteArray clientDataJsonHash) {
        TpmsAttest certInfo;
        TpmtPublic pubArea;
        ByteArray sig;
        List<X509Certificate> x5c;
        ObjectNode attStmt = attestationObject.getAttestationStatement();
        JsonNode verNode = attStmt.get("ver");
        ExceptionUtil.assertTrue(verNode != null && verNode.isTextual() && verNode.textValue().equals(TPM_VER), "attStmt.ver must equal \"%s\", was: %s", TPM_VER, verNode);
        JsonNode algNode = attStmt.get("alg");
        ExceptionUtil.assertTrue(algNode != null && algNode.canConvertToLong(), "attStmt.alg must be set to an integer value, was: %s", algNode);
        COSEAlgorithmIdentifier alg = COSEAlgorithmIdentifier.fromId(algNode.longValue()).orElseThrow(() -> new IllegalArgumentException("Unknown COSE algorithm identifier: " + algNode));
        JsonNode x5cNode = attStmt.get("x5c");
        ExceptionUtil.assertTrue(x5cNode != null && x5cNode.isArray(), "attStmt.x5c must be set to an array value, was: %s", x5cNode);
        try {
            x5c = this.getAttestationTrustPath(attestationObject).orElseThrow(() -> new IllegalArgumentException("Failed to parse \"x5c\" attestation certificate chain in \"tpm\" attestation statement."));
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        X509Certificate aikCert = x5c.get(0);
        JsonNode sigNode = attStmt.get("sig");
        ExceptionUtil.assertTrue(sigNode != null && sigNode.isBinary(), "attStmt.sig must be set to a binary value, was: %s", sigNode);
        try {
            sig = new ByteArray(sigNode.binaryValue());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JsonNode certInfoNode = attStmt.get("certInfo");
        ExceptionUtil.assertTrue(certInfoNode != null && certInfoNode.isBinary(), "attStmt.certInfo must be set to a binary value, was: %s", certInfoNode);
        JsonNode pubAreaNode = attStmt.get("pubArea");
        ExceptionUtil.assertTrue(pubAreaNode != null && pubAreaNode.isBinary(), "attStmt.pubArea must be set to a binary value, was: %s", pubAreaNode);
        try {
            pubArea = TpmtPublic.parse(pubAreaNode.binaryValue());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse TPMT_PUBLIC data structure.", e);
        }
        try {
            certInfo = TpmsAttest.parse(certInfoNode.binaryValue());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse TPMS_ATTEST data structure.", e);
        }
        try {
            this.verifyPublicKeysMatch(attestationObject, pubArea);
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException("Failed to verify that public key in TPM attestation matches public key in authData.", e);
        }
        ByteArray attToBeSigned = attestationObject.getAuthenticatorData().getBytes().concat(clientDataJsonHash);
        try {
            this.validateCertInfo(alg, aikCert, sig, pubArea, certInfo, attToBeSigned, attestationObject);
        }
        catch (CertificateParsingException e) {
            throw new RuntimeException("Failed to verify TPM attestation.", e);
        }
        return true;
    }

    private void validateCertInfo(COSEAlgorithmIdentifier alg, X509Certificate aikCert, ByteArray sig, TpmtPublic pubArea, TpmsAttest certInfo, ByteArray attToBeSigned, AttestationObject attestationObject) throws CertificateParsingException {
        ByteArray expectedExtraData;
        switch (alg) {
            case ES256: 
            case RS256: {
                expectedExtraData = Crypto.sha256(attToBeSigned);
                break;
            }
            case ES384: 
            case RS384: {
                expectedExtraData = Crypto.sha384(attToBeSigned);
                break;
            }
            case ES512: 
            case RS512: {
                expectedExtraData = Crypto.sha512(attToBeSigned);
                break;
            }
            case RS1: {
                try {
                    expectedExtraData = Crypto.sha1(attToBeSigned);
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("Failed to hash attToBeSigned to verify TPM attestation.", e);
                }
            }
            default: {
                throw new UnsupportedOperationException("Signing algorithm not implemented: " + (Object)((Object)alg));
            }
        }
        ExceptionUtil.assertTrue(certInfo.extraData.equals(expectedExtraData), "Incorrect certInfo.extraData.", new Object[0]);
        ExceptionUtil.assertTrue(certInfo.attestedName.equals(pubArea.name()), "Incorrect certInfo.attestedName.", new Object[0]);
        ExceptionUtil.assertTrue(Crypto.verifySignature(aikCert, certInfo.getRawBytes(), sig, alg), "Incorrect TPM attestation signature.", new Object[0]);
        this.verifyX5cRequirements(aikCert, attestationObject.getAuthenticatorData().getAttestedCredentialData().get().getAaguid());
    }

    private void verifyPublicKeysMatch(AttestationObject attestationObject, TpmtPublic pubArea) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        PublicKey credentialPubKey = WebAuthnCodecs.importCosePublicKey(attestationObject.getAuthenticatorData().getAttestedCredentialData().get().getCredentialPublicKey());
        switch (pubArea.signAlg) {
            case 1: {
                TpmsRsaParms params = (TpmsRsaParms)pubArea.parameters;
                Tpm2bPublicKeyRsa unique = (Tpm2bPublicKeyRsa)pubArea.unique;
                RSAPublicKeySpec spec = new RSAPublicKeySpec(new BigInteger(1, unique.bytes.getBytes()), BigInteger.valueOf(params.exponent));
                KeyFactory kf = KeyFactory.getInstance("RSA");
                PublicKey signedCredentialPublicKey = kf.generatePublic(spec);
                ExceptionUtil.assertTrue(Arrays.equals(credentialPubKey.getEncoded(), signedCredentialPublicKey.getEncoded()), "Signed public key in TPM attestation is not identical to credential public key in authData.", new Object[0]);
                break;
            }
            case 35: {
                COSEAlgorithmIdentifier tpmAlgId;
                TpmsEccParms params = (TpmsEccParms)pubArea.parameters;
                TpmsEccPoint unique = (TpmsEccPoint)pubArea.unique;
                COSEAlgorithmIdentifier algId = COSEAlgorithmIdentifier.fromPublicKey(attestationObject.getAuthenticatorData().getAttestedCredentialData().get().getCredentialPublicKey()).get();
                CBORObject cosePubkey = CBORObject.DecodeFromBytes(attestationObject.getAuthenticatorData().getAttestedCredentialData().get().getCredentialPublicKey().getBytes());
                switch (params.curve_id) {
                    case 3: {
                        tpmAlgId = COSEAlgorithmIdentifier.ES256;
                        break;
                    }
                    case 4: {
                        tpmAlgId = COSEAlgorithmIdentifier.ES384;
                        break;
                    }
                    case 5: {
                        tpmAlgId = COSEAlgorithmIdentifier.ES512;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported elliptic curve: " + params.curve_id);
                    }
                }
                ExceptionUtil.assertTrue(algId.equals((Object)tpmAlgId), "Signed public key in TPM attestation is not identical to credential public key in authData; elliptic curve differs: %s != %s", new Object[]{tpmAlgId, algId});
                byte[] cosePubkeyX = cosePubkey.get(CBORObject.FromObject(-2)).GetByteString();
                byte[] cosePubkeyY = cosePubkey.get(CBORObject.FromObject(-3)).GetByteString();
                ExceptionUtil.assertTrue(new BigInteger(1, unique.x.getBytes()).equals(new BigInteger(1, cosePubkeyX)), "Signed public key in TPM attestation is not identical to credential public key in authData; EC X coordinate differs: %s != %s", unique.x, new ByteArray(cosePubkeyX));
                ExceptionUtil.assertTrue(new BigInteger(1, unique.y.getBytes()).equals(new BigInteger(1, cosePubkeyY)), "Signed public key in TPM attestation is not identical to credential public key in authData; EC Y coordinate differs: %s != %s", unique.y, new ByteArray(cosePubkeyY));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported algorithm for credential public key: " + pubArea.signAlg);
            }
        }
    }

    private void verifyX5cRequirements(X509Certificate cert, ByteArray aaguid) throws CertificateParsingException {
        ExceptionUtil.assertTrue(cert.getVersion() == 3, "Invalid TPM attestation certificate: Version MUST be 3, but was: %s", cert.getVersion());
        ExceptionUtil.assertTrue(cert.getSubjectX500Principal().getName().isEmpty(), "Invalid TPM attestation certificate: subject MUST be empty, but was: %s", cert.getSubjectX500Principal());
        boolean foundManufacturer = false;
        boolean foundModel = false;
        boolean foundVersion = false;
        for (List<?> n : cert.getSubjectAlternativeNames()) {
            if ((Integer)n.get(0) != 4) continue;
            if (n.get(1) instanceof String) {
                try {
                    for (Rdn rdn : new LdapName((String)n.get(1)).getRdns()) {
                        javax.naming.directory.Attributes attrs = rdn.toAttributes();
                        foundManufacturer = foundManufacturer || attrs.get(OID_TCG_AT_TPM_MANUFACTURER) != null;
                        foundModel = foundModel || attrs.get(OID_TCG_AT_TPM_MODEL) != null;
                        foundVersion = foundVersion || attrs.get(OID_TCG_AT_TPM_VERSION) != null;
                    }
                    continue;
                }
                catch (InvalidNameException e) {
                    throw new RuntimeException("Failed to decode subject alternative name in TPM attestation cert", e);
                }
            }
            log.debug("Unknown type of SubjectAlternativeNames entry: {}", n.get(1));
        }
        ExceptionUtil.assertTrue(foundManufacturer && foundModel && foundVersion, "Invalid TPM attestation certificate: The Subject Alternative Name extension MUST be set as defined in [TPMv2-EK-Profile] section 3.2.9.%s%s%s", foundManufacturer ? "" : " Missing TPM manufacturer.", foundModel ? "" : " Missing TPM model.", foundVersion ? "" : " Missing TPM version.");
        ExceptionUtil.assertTrue(cert.getExtendedKeyUsage() != null && cert.getExtendedKeyUsage().contains("2.23.133.8.3"), "Invalid TPM attestation certificate: extended key usage extension MUST contain the OID 2.23.133.8.3, but was: %s", cert.getExtendedKeyUsage());
        ExceptionUtil.assertTrue(cert.getBasicConstraints() == -1, "Invalid TPM attestation certificate: MUST NOT be a CA certificate, but was.", new Object[0]);
        CertificateParser.parseFidoAaguidExtension(cert).ifPresent(extensionAaguid -> ExceptionUtil.assertTrue(Arrays.equals(aaguid.getBytes(), extensionAaguid), "Invalid TPM attestation certificate: X.509 extension \"id-fido-gen-ce-aaguid\" is present but does not match the authenticator AAGUID.", new Object[0]));
    }

    private static class TpmEccCurve {
        private static final int NONE = 0;
        private static final int NIST_P256 = 3;
        private static final int NIST_P384 = 4;
        private static final int NIST_P521 = 5;

        private TpmEccCurve() {
        }
    }

    private static final class TpmtPublic {
        private final int signAlg;
        private final int nameAlg;
        private final Parameters parameters;
        private final Unique unique;
        private final ByteArray rawBytes;

        private static TpmtPublic parse(byte[] pubArea) throws IOException {
            try (ByteInputStream reader = new ByteInputStream(pubArea);){
                Unique unique;
                Parameters parameters;
                int signAlg = reader.readUnsignedShort();
                int nameAlg = reader.readUnsignedShort();
                int attributes = reader.readInt();
                ExceptionUtil.assertTrue((attributes & 0xFFF8F309) == 0, "Attributes contains 1 bits in reserved position(s): 0x%08x", attributes);
                reader.skipBytes(reader.readUnsignedShort());
                ExceptionUtil.assertTrue((attributes & 0x40000) == 262144, "Public key is expected to have the SIGN_ENCRYPT attribute set, attributes were: 0x%08x", attributes);
                if (signAlg == 1) {
                    parameters = TpmsRsaParms.parse(reader);
                    unique = Tpm2bPublicKeyRsa.parse(reader);
                } else if (signAlg == 35) {
                    parameters = TpmsEccParms.parse(reader);
                    unique = TpmsEccPoint.parse(reader);
                } else {
                    throw new UnsupportedOperationException("Signing algorithm not implemented: " + signAlg);
                }
                ExceptionUtil.assertTrue(reader.available() == 0, "%d remaining bytes in TPMT_PUBLIC buffer", reader.available());
                TpmtPublic tpmtPublic = new TpmtPublic(signAlg, nameAlg, parameters, unique, new ByteArray(pubArea));
                return tpmtPublic;
            }
        }

        private ByteArray name() {
            ByteArray hash;
            switch (this.nameAlg) {
                case 4: {
                    try {
                        hash = Crypto.sha1(this.rawBytes);
                        break;
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException("Failed to hash TPMU_ATTEST name.", e);
                    }
                }
                case 11: {
                    hash = Crypto.sha256(this.rawBytes);
                    break;
                }
                case 12: {
                    hash = Crypto.sha384(this.rawBytes);
                    break;
                }
                case 13: {
                    hash = Crypto.sha512(this.rawBytes);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown hash algorithm identifier: " + this.nameAlg);
                }
            }
            return new ByteArray(BinaryUtil.encodeUint16(this.nameAlg)).concat(hash);
        }

        @Generated
        public TpmtPublic(int signAlg, int nameAlg, Parameters parameters, Unique unique, ByteArray rawBytes) {
            this.signAlg = signAlg;
            this.nameAlg = nameAlg;
            this.parameters = parameters;
            this.unique = unique;
            this.rawBytes = rawBytes;
        }

        @Generated
        public int getSignAlg() {
            return this.signAlg;
        }

        @Generated
        public int getNameAlg() {
            return this.nameAlg;
        }

        @Generated
        public Parameters getParameters() {
            return this.parameters;
        }

        @Generated
        public Unique getUnique() {
            return this.unique;
        }

        @Generated
        public ByteArray getRawBytes() {
            return this.rawBytes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TpmtPublic)) {
                return false;
            }
            TpmtPublic other = (TpmtPublic)o;
            if (this.getSignAlg() != other.getSignAlg()) {
                return false;
            }
            if (this.getNameAlg() != other.getNameAlg()) {
                return false;
            }
            Parameters this$parameters = this.getParameters();
            Parameters other$parameters = other.getParameters();
            if (this$parameters == null ? other$parameters != null : !this$parameters.equals(other$parameters)) {
                return false;
            }
            Unique this$unique = this.getUnique();
            Unique other$unique = other.getUnique();
            if (this$unique == null ? other$unique != null : !this$unique.equals(other$unique)) {
                return false;
            }
            ByteArray this$rawBytes = this.getRawBytes();
            ByteArray other$rawBytes = other.getRawBytes();
            return !(this$rawBytes == null ? other$rawBytes != null : !((Object)this$rawBytes).equals(other$rawBytes));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSignAlg();
            result = result * 59 + this.getNameAlg();
            Parameters $parameters = this.getParameters();
            result = result * 59 + ($parameters == null ? 43 : $parameters.hashCode());
            Unique $unique = this.getUnique();
            result = result * 59 + ($unique == null ? 43 : $unique.hashCode());
            ByteArray $rawBytes = this.getRawBytes();
            result = result * 59 + ($rawBytes == null ? 43 : ((Object)$rawBytes).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TpmAttestationStatementVerifier.TpmtPublic(signAlg=" + this.getSignAlg() + ", nameAlg=" + this.getNameAlg() + ", parameters=" + this.getParameters() + ", unique=" + this.getUnique() + ", rawBytes=" + this.getRawBytes() + ")";
        }
    }

    private static final class TpmsAttest {
        private final ByteArray rawBytes;
        private final ByteArray extraData;
        private final ByteArray attestedName;

        private static TpmsAttest parse(byte[] certInfo) throws IOException {
            try (ByteInputStream reader = new ByteInputStream(certInfo);){
                ByteArray magic = new ByteArray(reader.read(4));
                ExceptionUtil.assertTrue(magic.equals(TPM_GENERATED_VALUE), "magic field is invalid: %s", magic);
                ByteArray type = new ByteArray(reader.read(2));
                ExceptionUtil.assertTrue(type.equals(TPM_ST_ATTEST_CERTIFY), "type field is invalid: %s", type);
                reader.skipBytes(reader.readUnsignedShort());
                ByteArray extraData = new ByteArray(reader.read(reader.readUnsignedShort()));
                reader.skipBytes(17);
                reader.skipBytes(8);
                ByteArray attestedName = new ByteArray(reader.read(reader.readUnsignedShort()));
                TpmsAttest tpmsAttest = new TpmsAttest(new ByteArray(certInfo), extraData, attestedName);
                return tpmsAttest;
            }
        }

        @Generated
        public TpmsAttest(ByteArray rawBytes, ByteArray extraData, ByteArray attestedName) {
            this.rawBytes = rawBytes;
            this.extraData = extraData;
            this.attestedName = attestedName;
        }

        @Generated
        public ByteArray getRawBytes() {
            return this.rawBytes;
        }

        @Generated
        public ByteArray getExtraData() {
            return this.extraData;
        }

        @Generated
        public ByteArray getAttestedName() {
            return this.attestedName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TpmsAttest)) {
                return false;
            }
            TpmsAttest other = (TpmsAttest)o;
            ByteArray this$rawBytes = this.getRawBytes();
            ByteArray other$rawBytes = other.getRawBytes();
            if (this$rawBytes == null ? other$rawBytes != null : !((Object)this$rawBytes).equals(other$rawBytes)) {
                return false;
            }
            ByteArray this$extraData = this.getExtraData();
            ByteArray other$extraData = other.getExtraData();
            if (this$extraData == null ? other$extraData != null : !((Object)this$extraData).equals(other$extraData)) {
                return false;
            }
            ByteArray this$attestedName = this.getAttestedName();
            ByteArray other$attestedName = other.getAttestedName();
            return !(this$attestedName == null ? other$attestedName != null : !((Object)this$attestedName).equals(other$attestedName));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteArray $rawBytes = this.getRawBytes();
            result = result * 59 + ($rawBytes == null ? 43 : ((Object)$rawBytes).hashCode());
            ByteArray $extraData = this.getExtraData();
            result = result * 59 + ($extraData == null ? 43 : ((Object)$extraData).hashCode());
            ByteArray $attestedName = this.getAttestedName();
            result = result * 59 + ($attestedName == null ? 43 : ((Object)$attestedName).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TpmAttestationStatementVerifier.TpmsAttest(rawBytes=" + this.getRawBytes() + ", extraData=" + this.getExtraData() + ", attestedName=" + this.getAttestedName() + ")";
        }
    }

    private static interface Parameters {
    }

    private static final class TpmsRsaParms
    implements Parameters {
        private final long exponent;

        private static TpmsRsaParms parse(ByteInputStream reader) throws IOException {
            int symmetric = reader.readUnsignedShort();
            ExceptionUtil.assertTrue(symmetric == 16, "RSA key is expected to have \"symmetric\" set to TPM_ALG_NULL, was: 0x%04x", symmetric);
            int scheme = reader.readUnsignedShort();
            ExceptionUtil.assertTrue(scheme == 20 || scheme == 16, "RSA key is expected to have \"scheme\" set to TPM_ALG_RSASSA or TPM_ALG_NULL, was: 0x%04x", scheme);
            reader.skipBytes(2);
            int exponent = reader.readInt();
            ExceptionUtil.assertTrue(exponent >= 0, "Exponent is too large and wrapped around to negative: %d", exponent);
            if (exponent == 0) {
                exponent = 65537;
            }
            return new TpmsRsaParms(exponent);
        }

        @Generated
        public TpmsRsaParms(long exponent) {
            this.exponent = exponent;
        }

        @Generated
        public long getExponent() {
            return this.exponent;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TpmsRsaParms)) {
                return false;
            }
            TpmsRsaParms other = (TpmsRsaParms)o;
            return this.getExponent() == other.getExponent();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $exponent = this.getExponent();
            result = result * 59 + (int)($exponent >>> 32 ^ $exponent);
            return result;
        }

        @Generated
        public String toString() {
            return "TpmAttestationStatementVerifier.TpmsRsaParms(exponent=" + this.getExponent() + ")";
        }
    }

    private static interface Unique {
    }

    private static final class Tpm2bPublicKeyRsa
    implements Unique {
        private final ByteArray bytes;

        private static Tpm2bPublicKeyRsa parse(ByteInputStream reader) throws IOException {
            return new Tpm2bPublicKeyRsa(new ByteArray(reader.read(reader.readUnsignedShort())));
        }

        @Generated
        public Tpm2bPublicKeyRsa(ByteArray bytes) {
            this.bytes = bytes;
        }

        @Generated
        public ByteArray getBytes() {
            return this.bytes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tpm2bPublicKeyRsa)) {
                return false;
            }
            Tpm2bPublicKeyRsa other = (Tpm2bPublicKeyRsa)o;
            ByteArray this$bytes = this.getBytes();
            ByteArray other$bytes = other.getBytes();
            return !(this$bytes == null ? other$bytes != null : !((Object)this$bytes).equals(other$bytes));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteArray $bytes = this.getBytes();
            result = result * 59 + ($bytes == null ? 43 : ((Object)$bytes).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TpmAttestationStatementVerifier.Tpm2bPublicKeyRsa(bytes=" + this.getBytes() + ")";
        }
    }

    private static final class TpmsEccParms
    implements Parameters {
        private final int curve_id;

        private static TpmsEccParms parse(ByteInputStream reader) throws IOException {
            int symmetric = reader.readUnsignedShort();
            int scheme = reader.readUnsignedShort();
            ExceptionUtil.assertTrue(symmetric == 16, "ECC key is expected to have \"symmetric\" set to TPM_ALG_NULL, was: 0x%04x", symmetric);
            ExceptionUtil.assertTrue(scheme == 16, "ECC key is expected to have \"scheme\" set to TPM_ALG_NULL, was: 0x%04x", scheme);
            int curve_id = reader.readUnsignedShort();
            reader.skipBytes(2);
            return new TpmsEccParms(curve_id);
        }

        @Generated
        public TpmsEccParms(int curve_id) {
            this.curve_id = curve_id;
        }

        @Generated
        public int getCurve_id() {
            return this.curve_id;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TpmsEccParms)) {
                return false;
            }
            TpmsEccParms other = (TpmsEccParms)o;
            return this.getCurve_id() == other.getCurve_id();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCurve_id();
            return result;
        }

        @Generated
        public String toString() {
            return "TpmAttestationStatementVerifier.TpmsEccParms(curve_id=" + this.getCurve_id() + ")";
        }
    }

    private static final class TpmsEccPoint
    implements Unique {
        private final ByteArray x;
        private final ByteArray y;

        private static TpmsEccPoint parse(ByteInputStream reader) throws IOException {
            ByteArray x = new ByteArray(reader.read(reader.readUnsignedShort()));
            ByteArray y = new ByteArray(reader.read(reader.readUnsignedShort()));
            return new TpmsEccPoint(x, y);
        }

        @Generated
        public TpmsEccPoint(ByteArray x, ByteArray y) {
            this.x = x;
            this.y = y;
        }

        @Generated
        public ByteArray getX() {
            return this.x;
        }

        @Generated
        public ByteArray getY() {
            return this.y;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TpmsEccPoint)) {
                return false;
            }
            TpmsEccPoint other = (TpmsEccPoint)o;
            ByteArray this$x = this.getX();
            ByteArray other$x = other.getX();
            if (this$x == null ? other$x != null : !((Object)this$x).equals(other$x)) {
                return false;
            }
            ByteArray this$y = this.getY();
            ByteArray other$y = other.getY();
            return !(this$y == null ? other$y != null : !((Object)this$y).equals(other$y));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteArray $x = this.getX();
            result = result * 59 + ($x == null ? 43 : ((Object)$x).hashCode());
            ByteArray $y = this.getY();
            result = result * 59 + ($y == null ? 43 : ((Object)$y).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TpmAttestationStatementVerifier.TpmsEccPoint(x=" + this.getX() + ", y=" + this.getY() + ")";
        }
    }

    static final class TpmRsaScheme {
        static final int RSASSA = 20;

        TpmRsaScheme() {
        }
    }

    static class TpmAlgHash {
        static final int SHA1 = 4;
        static final int SHA256 = 11;
        static final int SHA384 = 12;
        static final int SHA512 = 13;

        TpmAlgHash() {
        }
    }

    static final class TpmAlgAsym {
        static final int RSA = 1;
        static final int ECC = 35;

        TpmAlgAsym() {
        }
    }

    static final class Attributes {
        static final int SIGN_ENCRYPT = 262144;
        private static final int SHALL_BE_ZERO = -462071;

        Attributes() {
        }
    }
}

