/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.ICBORNumber;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;

class CBORInteger
implements ICBORNumber {
    CBORInteger() {
    }

    @Override
    public Object Abs(Object obj) {
        long val = (Long)obj;
        return val == Integer.MIN_VALUE ? EInteger.FromInt32(1).ShiftLeft(63) : (val < 0L ? Long.valueOf(-val) : obj);
    }

    @Override
    public EInteger AsEInteger(Object obj) {
        return EInteger.FromInt64((Long)obj);
    }

    @Override
    public double AsDouble(Object obj) {
        return ((Long)obj).longValue();
    }

    @Override
    public EDecimal AsEDecimal(Object obj) {
        return EDecimal.FromInt64((Long)obj);
    }

    @Override
    public EFloat AsEFloat(Object obj) {
        return EFloat.FromInt64((Long)obj);
    }

    @Override
    public ERational AsERational(Object obj) {
        return ERational.FromInt64((Long)obj);
    }

    @Override
    public int AsInt32(Object obj, int minValue, int maxValue) {
        long val = (Long)obj;
        if (val < (long)minValue || val > (long)maxValue) {
            throw new ArithmeticException("This Object's value is out of range");
        }
        return (int)val;
    }

    @Override
    public long AsInt64(Object obj) {
        return (Long)obj;
    }

    @Override
    public float AsSingle(Object obj) {
        return ((Long)obj).longValue();
    }

    @Override
    public boolean CanFitInDouble(Object obj) {
        long intItem = (Long)obj;
        if (intItem == Long.MIN_VALUE) {
            return true;
        }
        long l = intItem = intItem < 0L ? -intItem : intItem;
        while (intItem >= 0x20000000000000L && (intItem & 1L) == 0L) {
            intItem >>= 1;
        }
        return intItem < 0x20000000000000L;
    }

    @Override
    public boolean CanFitInInt32(Object obj) {
        long val = (Long)obj;
        return val >= Integer.MIN_VALUE && val <= Integer.MAX_VALUE;
    }

    @Override
    public boolean CanFitInInt64(Object obj) {
        return true;
    }

    @Override
    public boolean CanFitInSingle(Object obj) {
        long intItem = (Long)obj;
        if (intItem == Long.MIN_VALUE) {
            return true;
        }
        long l = intItem = intItem < 0L ? -intItem : intItem;
        while (intItem >= 0x1000000L && (intItem & 1L) == 0L) {
            intItem >>= 1;
        }
        return intItem < 0x1000000L;
    }

    @Override
    public boolean CanTruncatedIntFitInInt32(Object obj) {
        long val = (Long)obj;
        return val >= Integer.MIN_VALUE && val <= Integer.MAX_VALUE;
    }

    @Override
    public boolean CanTruncatedIntFitInUInt64(Object obj) {
        long val = (Long)obj;
        return val >= 0L;
    }

    @Override
    public boolean CanFitInUInt64(Object obj) {
        long val = (Long)obj;
        return val >= 0L;
    }

    @Override
    public boolean CanTruncatedIntFitInInt64(Object obj) {
        return true;
    }

    @Override
    public boolean IsInfinity(Object obj) {
        return false;
    }

    @Override
    public boolean IsIntegral(Object obj) {
        return true;
    }

    @Override
    public boolean IsNaN(Object obj) {
        return false;
    }

    @Override
    public boolean IsNegative(Object obj) {
        return (Long)obj < 0L;
    }

    @Override
    public boolean IsNegativeInfinity(Object obj) {
        return false;
    }

    @Override
    public boolean IsPositiveInfinity(Object obj) {
        return false;
    }

    @Override
    public boolean IsNumberZero(Object obj) {
        return (Long)obj == 0L;
    }

    @Override
    public Object Negate(Object obj) {
        return (Long)obj == Long.MIN_VALUE ? EInteger.FromInt32(1).ShiftLeft(63) : Long.valueOf(-((Long)obj).longValue());
    }

    @Override
    public int Sign(Object obj) {
        long val = (Long)obj;
        return val == 0L ? 0 : (val < 0L ? -1 : 1);
    }
}

