/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.validation;

import com.alphaserve.twofactor.core.services.XsrfTokenService;
import com.alphaserve.twofactor.core.validation.core.MultiValidator;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Named
public class XsrfTokenValidator
implements MultiValidator<HttpServletRequest, HttpServletResponse> {
    @ComponentImport
    private I18nResolver i18nResolver;
    private final XsrfTokenService xsrfTokenService;

    @Inject
    public XsrfTokenValidator(I18nResolver i18nResolver, XsrfTokenService xsrfTokenService) {
        this.i18nResolver = i18nResolver;
        this.xsrfTokenService = xsrfTokenService;
    }

    @Override
    public ValidationResult validate(HttpServletRequest request, HttpServletResponse response) {
        ValidationResult validationResult = ValidationResult.init(this.i18nResolver);
        String token = request.getParameter("atl_token");
        if (Objects.isNull(token) || !this.xsrfTokenService.generatedToken(request, response).equals(token)) {
            validationResult.addError("auth.text.error-xsrf");
        }
        return validationResult;
    }
}

