/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.validation;

import com.alphaserve.twofactor.core.dtolayer.dtos.U2FLoginDTO;
import com.alphaserve.twofactor.core.services.entities.U2FDeviceService;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.alphaserve.twofactor.core.validation.core.Validator;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;

@Named
public class U2FDeviceValidation
implements Validator<U2FLoginDTO> {
    private static final int MAX_U2F_DEVICE_NAME_LENGTH = 255;
    @ComponentImport
    private final I18nResolver i18nResolver;
    private final U2FDeviceService u2FDeviceService;

    @Inject
    public U2FDeviceValidation(I18nResolver i18nResolver, U2FDeviceService u2FDeviceService) {
        this.i18nResolver = i18nResolver;
        this.u2FDeviceService = u2FDeviceService;
    }

    @Override
    public ValidationResult validate(U2FLoginDTO U2FLoginDTO2) {
        ValidationResult validationResult = ValidationResult.init(this.i18nResolver);
        String u2fName = U2FLoginDTO2.getDeviceName();
        if (StringUtils.isBlank(u2fName) || u2fName.length() > 255) {
            validationResult.addError("auth.text.device_name_empty");
        }
        if (this.u2FDeviceService.getDeviceCountByName(u2fName) != 0L) {
            validationResult.addError("auth.text.you-have-device-name");
        }
        return validationResult;
    }
}

