/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.validation;

import com.alphaserve.twofactor.core.services.AuthLoginService;
import com.alphaserve.twofactor.core.services.PermissionService;
import com.alphaserve.twofactor.core.services.UserService;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.alphaserve.twofactor.core.validation.core.Validator;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpSession;

@Named
public class TrustedUserValidation
implements Validator<HttpSession> {
    @ComponentImport
    private final I18nResolver i18nResolver;
    private final AuthLoginService authLoginService;
    private final UserService userService;
    private final Validator<UserProfile> userProfileValidator;
    private final Validator<Option<PluginLicense>> pluginLicenseValidator;
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;
    private final PermissionService permissionService;

    @Inject
    public TrustedUserValidation(I18nResolver i18nResolver, AuthLoginService authLoginService, UserService userService, Validator<UserProfile> userProfileValidator, Validator<Option<PluginLicense>> pluginLicenseValidator, PluginLicenseManager pluginLicenseManager, PermissionService permissionService) {
        this.i18nResolver = i18nResolver;
        this.authLoginService = authLoginService;
        this.userService = userService;
        this.userProfileValidator = userProfileValidator;
        this.pluginLicenseValidator = pluginLicenseValidator;
        this.pluginLicenseManager = pluginLicenseManager;
        this.permissionService = permissionService;
    }

    @Override
    public ValidationResult validate(HttpSession session) {
        ValidationResult validationResult = ValidationResult.init(this.i18nResolver);
        if (!this.authLoginService.isPermitted(session)) {
            validationResult.addError("auth.text.not.permissions");
        }
        if (!this.permissionService.isTrusted(this.userService.getUserProfile())) {
            validationResult.addErrors(this.userProfileValidator.validate(this.userService.getUserProfile()).getErrors());
        }
        validationResult.addErrors(this.pluginLicenseValidator.validate((Option<PluginLicense>)this.pluginLicenseManager.getLicense()).getErrors());
        return validationResult;
    }
}

