/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.validation;

import com.alphaserve.twofactor.core.dtolayer.dtos.ConfigDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.IpFilterDTO;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.alphaserve.twofactor.core.validation.core.Validator;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;

@Named
public class AdminConfigValidation
implements Validator<ConfigDTO> {
    @ComponentImport
    private final I18nResolver i18nResolver;
    private Validator<IpFilterDTO> whitelistValidator;

    @Inject
    public AdminConfigValidation(I18nResolver i18nResolver, Validator<IpFilterDTO> whitelistValidator) {
        this.i18nResolver = i18nResolver;
        this.whitelistValidator = whitelistValidator;
    }

    @Override
    public ValidationResult validate(ConfigDTO configDTO) {
        ValidationResult validationResult = ValidationResult.init(this.i18nResolver);
        String label = configDTO.getAuthLabel();
        String keySize = configDTO.getAuthKeySize();
        String timeStep = configDTO.getAuthTimeStep();
        String forceType = configDTO.getAuthForceType();
        String expireHoursRememberMeString = configDTO.getRememberMeExpireHours();
        String[] groupsList = configDTO.getAuthForceGroupsList();
        String[] exceptGroupsList = configDTO.getAuthForceAllExceptGroupsList();
        boolean isRememberMeEnabled = Objects.nonNull(configDTO.getAuthRememberMeEnable());
        boolean isBruteForceEnabled = Objects.nonNull(configDTO.getAuthBruteForceEnable());
        String numberAttemptsString = configDTO.getNumberAttempts();
        String lockoutPeriodString = configDTO.getLockoutPeriod();
        this.validateTotp(validationResult, label, keySize, timeStep);
        this.validateRememberMe(validationResult, expireHoursRememberMeString, isRememberMeEnabled);
        this.validateForce(validationResult, forceType, groupsList, exceptGroupsList);
        this.validateBruteForce(validationResult, isBruteForceEnabled, numberAttemptsString, lockoutPeriodString);
        this.validateIpWhiteList(validationResult, configDTO.getWhitelistNameSetting(), configDTO.getWhitelistIpSetting(), configDTO.getWhitelistIpConfig());
        this.validatePermission(validationResult, configDTO.getAuthPermissionType(), configDTO.getAuthPermissionGroupsList(), configDTO.getAuthPermissionUsersList());
        return validationResult;
    }

    private void validateTotp(ValidationResult validationResult, String label, String keySize, String timeStep) {
        if (StringUtils.isBlank(label) || label.length() < 3) {
            validationResult.addError("auth.text.error-admin-config-label");
        }
        if (label.length() > 254) {
            validationResult.addError("auth.text.error-admin-config-label-wrong-size");
        }
        try {
            int size = Integer.parseInt(keySize);
            if (size > 254) {
                validationResult.addError("auth.text.error-admin-config-keysize-wrong-size");
            }
            if (size <= 0) {
                validationResult.addError("auth.text.error-admin-config-keysize");
            }
        }
        catch (NumberFormatException e) {
            validationResult.addError("auth.text.error-admin-config-keysize");
        }
        try {
            int step = Integer.parseInt(timeStep);
            if (step > 3600) {
                validationResult.addError("auth.text.error-admin-config-timestep-wrong-size");
            }
            if (step <= 0) {
                validationResult.addError("auth.text.error-admin-config-timestep");
            }
        }
        catch (NumberFormatException e) {
            validationResult.addError("auth.text.error-admin-config-timestep");
        }
    }

    private void validateRememberMe(ValidationResult validationResult, String expireHoursRememberMeString, boolean isRememberMeEnabled) {
        if (isRememberMeEnabled) {
            try {
                long rememberMeExpireHours = Long.parseLong(expireHoursRememberMeString);
                if (rememberMeExpireHours <= 0L) {
                    validationResult.addError("auth.text.error-admin-config-expire-remember-me");
                }
            }
            catch (NumberFormatException e) {
                validationResult.addError("auth.text.error-admin-config-expire-remember-me");
            }
        }
    }

    private void validateForce(ValidationResult validationResult, String forceType, String[] groupsList, String[] exceptGroupsList) {
        if (forceType.equals("forceGroups") && (Objects.isNull(groupsList) || groupsList.length == 0)) {
            validationResult.addError("auth.text.error-admin-config-zero-groups");
        }
        if (forceType.equals("forceAllExceptGroups") && (Objects.isNull(exceptGroupsList) || exceptGroupsList.length == 0)) {
            validationResult.addError("auth.text.error-admin-config-except-zero-groups");
        }
    }

    private void validateBruteForce(ValidationResult validationResult, boolean isBruteForceEnabled, String numberAttemptsString, String lockoutPeriodString) {
        if (isBruteForceEnabled) {
            try {
                long numberAttempts = Long.parseLong(numberAttemptsString);
                if (numberAttempts <= 0L) {
                    validationResult.addError("auth.text.error-admin-config-number-of-attempts");
                }
            }
            catch (NumberFormatException e) {
                validationResult.addError("auth.text.error-admin-config-number-of-attempts");
            }
            try {
                long lockoutPeriod = Long.parseLong(lockoutPeriodString);
                if (lockoutPeriod <= 0L) {
                    validationResult.addError("auth.text.error-admin-config-lockout-period");
                }
            }
            catch (NumberFormatException e) {
                validationResult.addError("auth.text.error-admin-config-lockout-period");
            }
        }
    }

    private void validateIpWhiteList(ValidationResult validationResult, String[] filterNames, String[] filterIps, Boolean[] filterLocalSet) {
        if (Objects.isNull(filterNames) || Objects.isNull(filterIps) || Objects.isNull(filterLocalSet)) {
            return;
        }
        for (int i = 0; i < filterIps.length; ++i) {
            ValidationResult validationIp = this.whitelistValidator.validate(IpFilterDTO.builder().ipName(filterNames[i]).ipConfig(filterIps[i]).local(filterLocalSet[i]).build());
            if (!validationIp.hasErrors()) continue;
            validationResult.addErrors(validationIp.getErrors());
            return;
        }
    }

    private void validatePermission(ValidationResult validationResult, String permissionType, String[] permissionGroups, String[] permissionUsers) {
        if (permissionType.equals("permissionGroups") && (Objects.isNull(permissionGroups) || permissionGroups.length == 0)) {
            validationResult.addError("auth.text.error-admin-config-zero-permission-groups");
        }
        if (permissionType.equals("permissionUsers") && (Objects.isNull(permissionUsers) || permissionUsers.length == 0)) {
            validationResult.addError("auth.text.error-admin-config-except-zero-permission-users");
        }
    }
}

