/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.utils;

import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class CookieUtils {
    private static String cookiePathFor(HttpServletRequest httpServletRequest) {
        String requestPath = httpServletRequest.getContextPath();
        return StringUtils.isNotEmpty(requestPath) ? requestPath : "/";
    }

    public static Cookie createCookie(String name, String value, HttpServletRequest currentRequest) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(CookieUtils.cookiePathFor(currentRequest));
        return cookie;
    }

    public static String getCookieValue(String cookieName, HttpServletRequest currentRequest) {
        if (Objects.isNull(cookieName)) {
            return null;
        }
        if (Objects.isNull(currentRequest)) {
            return null;
        }
        Cookie[] cookies = currentRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookieName.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }
}

