/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.servlets.impl;

import com.alphaserve.twofactor.core.Plugin2FACoreContext;
import com.alphaserve.twofactor.core.dtolayer.converter.DoForwardConverter;
import com.alphaserve.twofactor.core.dtolayer.dtos.IpFilterDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.TOTPRepresentation;
import com.alphaserve.twofactor.core.dtolayer.dtos.wrapper.ReactiveOptionalDto;
import com.alphaserve.twofactor.core.dtolayer.services.ServiceKeyDTOService;
import com.alphaserve.twofactor.core.model.entities.Auth2FA;
import com.alphaserve.twofactor.core.model.entities.IpFilter;
import com.alphaserve.twofactor.core.services.AtlassianPlatformManager;
import com.alphaserve.twofactor.core.services.AuthLoginService;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.Force2FAService;
import com.alphaserve.twofactor.core.services.PermissionService;
import com.alphaserve.twofactor.core.services.PluginInfoService;
import com.alphaserve.twofactor.core.services.TotpService;
import com.alphaserve.twofactor.core.services.UserService;
import com.alphaserve.twofactor.core.services.VersionService;
import com.alphaserve.twofactor.core.services.XsrfTokenService;
import com.alphaserve.twofactor.core.services.entities.CredentialService;
import com.alphaserve.twofactor.core.services.entities.FailLogin2FAService;
import com.alphaserve.twofactor.core.services.entities.IpFilterService;
import com.alphaserve.twofactor.core.services.entities.SecretKeyService;
import com.alphaserve.twofactor.core.services.entities.U2FDeviceService;
import com.alphaserve.twofactor.core.services.impl.DirectorySearchService;
import com.alphaserve.twofactor.core.services.servlets.ServletService;
import com.alphaserve.twofactor.core.utils.AppIdUtils;
import com.alphaserve.twofactor.core.utils.CacheUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Named
public class ServletServiceImpl
implements ServletService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServletServiceImpl.class);
    @ComponentImport
    protected final TemplateRenderer templateRenderer;
    protected final IpFilterService ipFilterService;
    protected final PluginInfoService pluginInfoService;
    protected final ConfigurationService configurationService;
    protected final DoForwardConverter<Auth2FA, TOTPRepresentation> dtoConverter2FA;
    protected final TotpService totpService;
    protected final Force2FAService force2FAService;
    protected final SecretKeyService secretKeyService;
    protected final ServiceKeyDTOService serviceKeyDTOService;
    protected final UserService userService;
    protected final U2FDeviceService u2FDeviceService;
    protected CredentialService credentialService;
    @ComponentImport
    protected final XsrfTokenAccessor tokenAccessor;
    @ComponentImport
    protected final UserManager userManager;
    protected final AtlassianPlatformManager atlassianPlatformManager;
    @ComponentImport
    protected final WebSudoManager webSudoManager;
    protected final FailLogin2FAService failLogin2FAService;
    protected final AuthLoginService authLoginService;
    protected final XsrfTokenService xsrfTokenService;
    protected final VersionService versionService;
    protected final PermissionService permissionService;
    protected final DoForwardConverter<IpFilter, IpFilterDTO> ipFilterConverter;
    protected final Plugin2FACoreContext pluginContext;
    protected final DirectorySearchService directorySearchService;
    protected final ReactiveOptionalDto<URL, MalformedURLException> canonicalBaseUrl;

    @Inject
    public ServletServiceImpl(TemplateRenderer templateRenderer, IpFilterService ipFilterService, PluginInfoService pluginInfoService, ConfigurationService configurationService, DoForwardConverter<Auth2FA, TOTPRepresentation> dtoConverter2FA, TotpService totpService, Force2FAService force2FAService, SecretKeyService secretKeyService, ServiceKeyDTOService serviceKeyDTOService, UserService userService, U2FDeviceService u2FDeviceService, XsrfTokenAccessor tokenAccessor, @Qualifier(value="userManager") UserManager userManager, AtlassianPlatformManager atlassianPlatformManager, WebSudoManager webSudoManager, FailLogin2FAService failLogin2FAService, AuthLoginService authLoginService, XsrfTokenService xsrfTokenService, VersionService versionService, PermissionService permissionService, CredentialService credentialService, DoForwardConverter<IpFilter, IpFilterDTO> ipFilterConverter, DirectorySearchService directorySearchService, Plugin2FACoreContext pluginContext) {
        this.templateRenderer = templateRenderer;
        this.ipFilterService = ipFilterService;
        this.pluginInfoService = pluginInfoService;
        this.configurationService = configurationService;
        this.dtoConverter2FA = dtoConverter2FA;
        this.totpService = totpService;
        this.force2FAService = force2FAService;
        this.secretKeyService = secretKeyService;
        this.serviceKeyDTOService = serviceKeyDTOService;
        this.userService = userService;
        this.u2FDeviceService = u2FDeviceService;
        this.tokenAccessor = tokenAccessor;
        this.userManager = userManager;
        this.atlassianPlatformManager = atlassianPlatformManager;
        this.webSudoManager = webSudoManager;
        this.failLogin2FAService = failLogin2FAService;
        this.authLoginService = authLoginService;
        this.xsrfTokenService = xsrfTokenService;
        this.versionService = versionService;
        this.permissionService = permissionService;
        this.credentialService = credentialService;
        this.ipFilterConverter = ipFilterConverter;
        this.directorySearchService = directorySearchService;
        this.pluginContext = pluginContext;
        this.canonicalBaseUrl = new ReactiveOptionalDto<URL, MalformedURLException>(() -> new URL(this.pluginContext.getBaseUrl(UrlMode.CANONICAL)), MalformedURLException.class);
    }

    @Override
    public void doGetAdminConfig(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGetAdminConfig(request, response, false);
    }

    @Override
    public void doGetAdminConfig(HttpServletRequest request, HttpServletResponse response, boolean isReadOnlyMode) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        if (!this.pluginInfoService.isAdministrator()) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
            return;
        }
        if (!this.pluginInfoService.isPluginLicensed()) {
            this.templateRenderer.render("/templates/admin/license/page.vm", (Writer)response.getWriter());
            return;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("authKeySize", this.configurationService.getAuthKeySize());
        context.put("authLabel", this.configurationService.getAuthLabel());
        context.put("authTimeStep", this.configurationService.getTimeStep());
        context.put("authForceGroupsList", this.configurationService.getAuthForceGroupsList());
        context.put("authForceType", this.configurationService.getAuthForceType());
        context.put("authLoggerEnable", this.configurationService.getAuthLoggerEnable());
        context.put("authIpWhitelistEnable", this.configurationService.getAuthIPWhitelistEnable());
        context.put("authU2FEnable", this.configurationService.getAuthU2FEnable());
        context.put("authRememberMeEnable", this.configurationService.getRememberMeFeatureEnable());
        context.put("rememberMeExpireHours", this.configurationService.getRememberMeExpireHours());
        context.put("authDuoEnable", this.configurationService.getAuthDuoEnable());
        context.put("oauthWhitelistEnable", this.configurationService.getOAuthWhitelistEnable());
        context.put("authForceAllExceptGroupsList", this.configurationService.getAuthForceAllExceptGroupsList());
        context.put("authIpFilters", this.ipFilterConverter.doForwardList(this.ipFilterService.getAll()));
        context.put("isReadOnlyMode", isReadOnlyMode);
        context.put("authBruteForceEnable", this.configurationService.getAuthBruteForceEnable());
        context.put("numberAttempts", this.configurationService.getNumberAttempts());
        context.put("lockoutPeriod", this.configurationService.getLockoutPeriod());
        context.put("atl_token", this.xsrfTokenService.generatedToken(request, response));
        context.put("autoLoginEnable", this.configurationService.getAutoLoginEnable());
        context.put("hideDeactivate2fa", this.configurationService.getHideDeactivate2fa());
        context.put("hide2faInServiceDesk", this.configurationService.getHide2faInServiceDesk());
        context.put("dialogOld", this.versionService.isAuiDialogOld());
        context.put("authPermissionType", this.configurationService.getAuthPermissionType());
        context.put("authPermissionGroupsList", this.configurationService.getAuthPermissionGroupsList());
        context.put("authPermissionUsersList", this.permissionService.preparePersons(this.configurationService.getAuthPermissionUsersList()));
        context.put("authTrustedBulkEnable", this.configurationService.getAuthTrustedBulkEnable());
        context.put("restEndpointsRestriction", this.configurationService.getRestEndpointsRestriction());
        context.put("webAuthnAttestationType", this.configurationService.getWebAuthnAttestationType());
        context.put("webAuthnAuthenticatorType", this.configurationService.getWebAuthnAuthenticatorType());
        context.put("webAuthnUserVerification", this.configurationService.getWebAuthnUserVerification());
        context.put("webAuthnResidentKey", this.configurationService.getWebAuthnResidentKey());
        context.put("whitelistUrls", this.configurationService.getWhitelistUrls());
        context.put("directoriesList", this.directorySearchService.findDirectories(this.configurationService.getAuthForceDirectoriesList()));
        context.put("authForceAllExceptDirectoriesList", this.directorySearchService.findDirectories(this.configurationService.getAuthForceAllExceptDirectoriesList()));
        context.put("allowedToSkimByPlugin", this.configurationService.getAllowedToSkimByPlugin());
        context.put("isServiceDesk", this.atlassianPlatformManager.isJiraServiceDeskEnabled());
        this.templateRenderer.render("/templates/admin/config/page.vm", context, (Writer)response.getWriter());
    }

    @Override
    public void doGetLogger(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        if (!this.pluginInfoService.isAdministrator()) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
            return;
        }
        if (!this.pluginInfoService.isPluginLicensed()) {
            this.templateRenderer.render("/templates/admin/license/page.vm", (Writer)response.getWriter());
            return;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("plugin_key", this.pluginContext.getPluginKey());
        context.put("atl_token", this.xsrfTokenService.generatedToken(request, response));
        context.put("dialogOld", this.versionService.isAuiDialogOld());
        this.templateRenderer.render("/templates/admin/logger/page.vm", context, (Writer)response.getWriter());
    }

    @Override
    public void doGetUserConfig(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGetUserConfig(request, response, false);
    }

    @Override
    public void doGetUserConfig(HttpServletRequest request, HttpServletResponse response, boolean isReadOnlyMode) throws IOException {
        this.getUserConfig(request, response, isReadOnlyMode, false);
    }

    private void getUserConfig(HttpServletRequest request, HttpServletResponse response, boolean isReadOnlyMode, boolean isServiceDesk) throws IOException {
        String target;
        response.setContentType("text/html;charset=UTF-8");
        UserProfile userProfile = this.userService.getUserProfile();
        if (userProfile == null) {
            CacheUtils.setNoCache(response);
            response.sendRedirect(request.getContextPath() + "/");
            return;
        }
        if (this.authLoginService.isUserHave2fa() && this.authLoginService.isLogged(request.getSession()) && !this.secretKeyService.isUserMustSeeCodes(userProfile) && Objects.nonNull(target = request.getParameter("targetUrl")) && target.contains("/servicedesk/customer/") && this.isSameUrl(target)) {
            CacheUtils.setNoCache(response);
            response.sendRedirect(target);
            return;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        TOTPRepresentation totpRepresentation = this.dtoConverter2FA.doForward(this.totpService.getByUser(userProfile));
        context.put("authDetails_userId", totpRepresentation.getUserId());
        context.put("authDetails_secretKey", totpRepresentation.getSecretKey());
        context.put("authDetails_active", totpRepresentation.isActive());
        context.put("authDetails_confirmed", totpRepresentation.isConfirmed());
        context.put("authDetails_userKey", totpRepresentation.getUserKey());
        context.put("authDetails_username", totpRepresentation.getUsername());
        context.put("isUserForced", this.force2FAService.isUserNeedToSetup2FA(userProfile));
        context.put("isUserMustSeeReserveCodes", this.secretKeyService.isUserMustSeeCodes(userProfile));
        context.put("reserveCodes", this.serviceKeyDTOService.transformList(this.secretKeyService.getByUser(userProfile)));
        context.put("isU2FEnabled", this.configurationService.getAuthU2FEnable());
        context.put("isAdmin", this.pluginInfoService.isAdministrator());
        context.put("baseUrl", AppIdUtils.getBaseUrl(request));
        context.put("contextPath", request.getContextPath());
        context.put("decorator", this.pluginContext.getUserDecorator());
        context.put("plugin_key", this.pluginContext.getPluginKey());
        context.put("isReadOnlyMode", isReadOnlyMode);
        context.put("atl_token", this.xsrfTokenService.generatedToken(request, response));
        context.put("showDisable2fa", !this.configurationService.getHideDeactivate2fa() || this.pluginInfoService.isAdministrator());
        context.put("dialogOld", this.versionService.isAuiDialogOld());
        context.put("isTrusted", this.permissionService.isTrusted(userProfile));
        context.put("isServiceDesk", isServiceDesk);
        context.put("hide2faInServiceDesk", this.configurationService.getHide2faInServiceDesk());
        context.put("authTrustedBulkEnable", this.configurationService.getAuthTrustedBulkEnable());
        this.templateRenderer.render("/templates/user/config/page.vm", context, (Writer)response.getWriter());
    }

    @Override
    public void doGetServiceDeskUserConfig(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.getUserConfig(request, response, false, true);
    }

    @Override
    public void doGetUserManager(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGetUserManager(request, response, false);
    }

    @Override
    public void doGet2FAUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        if (!this.pluginInfoService.isAdministrator()) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
            return;
        }
        if (!this.pluginInfoService.isPluginLicensed()) {
            this.templateRenderer.render("/templates/admin/license/page.vm", (Writer)response.getWriter());
            return;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("atl_token", this.xsrfTokenService.generatedToken(request, response));
        context.put("isPlatformSupportsSearchingByEmail", this.atlassianPlatformManager.isSupportSearchingByEmail());
        this.templateRenderer.render("/templates/admin/two-fa-users/page.vm", context, (Writer)response.getWriter());
    }

    @Override
    public void doGetUserManager(HttpServletRequest request, HttpServletResponse response, boolean isReadOnlyMode) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        if (!this.pluginInfoService.isAdministrator()) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
            return;
        }
        if (!this.pluginInfoService.isPluginLicensed()) {
            this.templateRenderer.render("/templates/admin/license/page.vm", (Writer)response.getWriter());
            return;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("isReadOnlyMode", isReadOnlyMode);
        context.put("atl_token", this.xsrfTokenService.generatedToken(request, response));
        this.templateRenderer.render("/templates/admin/manager/page.vm", context, (Writer)response.getWriter());
    }

    @Override
    public void doGetLoginPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        UserProfile remoteUser = this.userManager.getRemoteUser(request);
        if (Objects.isNull(remoteUser)) {
            CacheUtils.setNoCache(response);
            response.sendRedirect(request.getContextPath() + "/");
            return;
        }
        if (!this.authLoginService.isUserHave2fa()) {
            this.redirect(request, response);
            return;
        }
        if (this.authLoginService.isLogged(request.getSession())) {
            this.redirect(request, response);
            return;
        }
        Map<String, Object> context = this.getLoginContext(request, response);
        this.templateRenderer.render("/templates/user/login/page.vm", context, (Writer)response.getWriter());
    }

    protected Map<String, Object> getLoginContext(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("atlToken", this.tokenAccessor.getXsrfToken(request, response, true));
        context.put("logoutAction", "logout.action");
        context.put("baseUrl", request.getContextPath());
        context.put("isLicensed", this.pluginInfoService.isPluginLicensed());
        context.put("isU2FEnabled", this.configurationService.getAuthU2FEnable());
        context.put("isRememberMeFeatureEnabled", this.configurationService.getRememberMeFeatureEnable());
        context.put("hasUserU2F", this.u2FDeviceService.hasRemoteUserU2FDevice() || this.credentialService.hasRemoteUserU2FDevice());
        context.put("rememberMeExpireHours", this.configurationService.getRememberMeExpireHours());
        context.put("decorator", this.pluginContext.getUserDecorator());
        context.put("plugin_key", this.pluginContext.getPluginKey());
        context.put("isTotp", this.isTotpLogin(request));
        context.put("isU2F", this.isU2FLogin(request));
        context.put("isReserve", this.isReserveLogin(request));
        context.put("size", this.configurationService.getAuthKeySize());
        context.put("atl_token", this.xsrfTokenService.generatedToken(request, response));
        context.put("is_new_U2F_exist", this.credentialService.hasRemoteUserU2FDevice());
        context.put("autoLoginEnable", this.configurationService.getAutoLoginEnable());
        return context;
    }

    protected boolean isTotpLogin(HttpServletRequest request) {
        String way = request.getParameter("enter_2fa_way");
        return Objects.isNull(way) && (!this.configurationService.getAuthU2FEnable() || !this.u2FDeviceService.hasRemoteUserU2FDevice()) || Objects.nonNull(way) && way.equals("totp-login-way");
    }

    protected boolean isU2FLogin(HttpServletRequest request) {
        String way = request.getParameter("enter_2fa_way");
        return Objects.isNull(way) && this.configurationService.getAuthU2FEnable() && this.u2FDeviceService.hasRemoteUserU2FDevice() || Objects.nonNull(way) && way.equals("u2f-login-way");
    }

    protected boolean isReserveLogin(HttpServletRequest request) {
        String way = request.getParameter("enter_2fa_way");
        return Objects.nonNull(way) && way.equals("reserve-key-way");
    }

    protected void redirect(HttpServletRequest request, HttpServletResponse response) throws IOException {
        CacheUtils.setNoCache(response);
        String targetUrl = request.getParameter("targetUrl");
        if (Objects.nonNull(targetUrl) && this.isSameUrl(targetUrl)) {
            response.sendRedirect(this.removeXSS(targetUrl));
        } else {
            response.sendRedirect(request.getContextPath() + "/");
        }
    }

    @Override
    public void doGetLockedPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        HashMap<String, Object> context = new HashMap<String, Object>();
        response.setHeader("ALPHA_SERVE_LOCKED", "true");
        UserProfile remoteUser = this.userManager.getRemoteUser(request);
        if (Objects.isNull(remoteUser) || !this.configurationService.getAuthBruteForceEnable() || !this.failLogin2FAService.isLocked(remoteUser.getUserKey().getStringValue(), request)) {
            CacheUtils.setNoCache(response);
            response.sendRedirect(request.getContextPath() + "/");
            return;
        }
        context.put("lockoutPeriod", this.configurationService.getLockoutPeriod());
        context.put("decorator", this.pluginContext.getUserDecorator());
        context.put("atl_token", this.xsrfTokenService.generatedToken(request, response));
        this.templateRenderer.render("/templates/user/locked/page.vm", context, (Writer)response.getWriter());
    }

    protected String removeXSS(String link) {
        if (!StringUtils.isEmpty(link)) {
            Pattern pattern = Pattern.compile("<script>(.*?)</script>", 2);
            link = pattern.matcher(link).replaceAll("");
            pattern = Pattern.compile("src[\r\n]*=[\r\n]*'(.*?)'", 42);
            link = pattern.matcher(link).replaceAll("");
            pattern = Pattern.compile("src[\r\n]*=[\r\n]*\"(.*?)\"", 42);
            link = pattern.matcher(link).replaceAll("");
            pattern = Pattern.compile("</script>", 2);
            link = pattern.matcher(link).replaceAll("");
            pattern = Pattern.compile("<script(.*?)>", 42);
            link = pattern.matcher(link).replaceAll("");
            pattern = Pattern.compile("eval\\((.*?)\\)", 42);
            link = pattern.matcher(link).replaceAll("");
            pattern = Pattern.compile("expression\\((.*?)\\)", 42);
            link = pattern.matcher(link).replaceAll("");
            pattern = Pattern.compile("javascript:", 2);
            link = pattern.matcher(link).replaceAll("");
            pattern = Pattern.compile("vbscript:", 2);
            link = pattern.matcher(link).replaceAll("");
            pattern = Pattern.compile("onload(.*?)=", 42);
            link = pattern.matcher(link).replaceAll("");
        }
        return link;
    }

    protected boolean isSameUrl(String url) {
        try {
            URL urlOne = this.canonicalBaseUrl.getOrThrow();
            URL urlTwo = new URL(url);
            if (urlOne.getProtocol().equals(urlTwo.getProtocol()) && urlOne.getHost().equals(urlTwo.getHost()) && urlOne.getPort() == urlTwo.getPort()) {
                return true;
            }
        }
        catch (MalformedURLException e) {
            log.error("Not valid url: " + e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

