/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.rest.impl;

import com.alphaserve.twofactor.core.dtolayer.dtos.GroupDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.UsernameDTO;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.UserActionService;
import com.alphaserve.twofactor.core.services.rest.UserManagerRestService;
import com.alphaserve.twofactor.core.validation.AdminPermittedValidation;
import com.alphaserve.twofactor.core.validation.TrustedUserValidation;
import com.alphaserve.twofactor.core.validation.XsrfTokenValidator;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.gson.Gson;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Named
@Component
public class UserManagerRestServiceImpl
implements UserManagerRestService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserManagerRestServiceImpl.class);
    private final AdminPermittedValidation adminPermittedValidation;
    private final UserActionService userActionService;
    private final XsrfTokenValidator xsrfTokenValidator;
    private final TrustedUserValidation trustedUserValidation;
    private final ConfigurationService configurationService;

    @Inject
    public UserManagerRestServiceImpl(AdminPermittedValidation adminPermittedValidation, UserActionService userActionService, XsrfTokenValidator xsrfTokenValidator, TrustedUserValidation trustedUserValidation, ConfigurationService configurationService) {
        this.adminPermittedValidation = adminPermittedValidation;
        this.userActionService = userActionService;
        this.xsrfTokenValidator = xsrfTokenValidator;
        this.trustedUserValidation = trustedUserValidation;
        this.configurationService = configurationService;
    }

    @Override
    public Response findUsers(HttpServletRequest request, HttpServletResponse response, UsernameDTO usernameDTO) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, response);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        validationResult = this.trustedUserValidation.validate(request.getSession());
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        return this.ok(new Gson().toJson(this.userActionService.findUsers(usernameDTO.getUsername())));
    }

    @Override
    public Response findGroups(HttpServletRequest request, HttpServletResponse response, GroupDTO groupDTO) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, response);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        validationResult = this.configurationService.getAuthTrustedBulkEnable() ? this.trustedUserValidation.validate(request.getSession()) : this.adminPermittedValidation.validate(request.getSession());
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        return this.ok(new Gson().toJson(this.userActionService.findGroups(groupDTO.getName())));
    }

    @Override
    public Response logout(HttpServletRequest request, HttpServletResponse response) {
        this.userActionService.logout(request, response);
        return this.ok();
    }

    private Response getBadValidationResponse(ValidationResult validationResult) {
        try {
            return this.badRequest(mapper.writeValueAsString(validationResult.getErrors()));
        }
        catch (JsonProcessingException e) {
            log.error("Can't convert errors to JSON", (Throwable)e);
            return this.badRequest();
        }
    }
}

