/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.rest.impl;

import com.alphaserve.twofactor.core.model.entities.Auth2FA;
import com.alphaserve.twofactor.core.model.exceptions.NoReserveCodesException;
import com.alphaserve.twofactor.core.services.AuthLoginService;
import com.alphaserve.twofactor.core.services.UserService;
import com.alphaserve.twofactor.core.services.entities.Auth2FAService;
import com.alphaserve.twofactor.core.services.entities.SecretKeyService;
import com.alphaserve.twofactor.core.services.rest.RecoveryCodesRestService;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;

@Named
public class RecoveryCodesRestServiceImpl
implements RecoveryCodesRestService {
    private final Auth2FAService auth2FAService;
    private final SecretKeyService secretKeyService;
    private final AuthLoginService authLoginService;
    private UserService userService;

    @Inject
    public RecoveryCodesRestServiceImpl(Auth2FAService auth2FAService, SecretKeyService secretKeyService, AuthLoginService authLoginService, UserService userService) {
        this.auth2FAService = auth2FAService;
        this.secretKeyService = secretKeyService;
        this.authLoginService = authLoginService;
        this.userService = userService;
    }

    @Override
    public Response getCodes(HttpServletRequest request, HttpServletResponse response) {
        Auth2FA auth2FA = this.auth2FAService.getByUserKey(this.userService.getUserProfile().getUserKey());
        if (!this.secretKeyService.isAllowedToDownload(request, auth2FA) || !this.authLoginService.isLogged2fa(request.getSession())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.secretKeyService.downloadCodes(auth2FA, response);
            return Response.ok().build();
        }
        catch (NoReserveCodesException e) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (IOException e) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
    }
}

