/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.rest.impl;

import com.alphaserve.twofactor.core.dtolayer.dtos.U2FLoginDTO;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.LoginActionService;
import com.alphaserve.twofactor.core.services.U2fService;
import com.alphaserve.twofactor.core.services.UserService;
import com.alphaserve.twofactor.core.services.rest.DeviceRestService;
import com.alphaserve.twofactor.core.utils.AppIdUtils;
import com.alphaserve.twofactor.core.validation.AppIdValidation;
import com.alphaserve.twofactor.core.validation.LoggedTwoFactorValidation;
import com.alphaserve.twofactor.core.validation.User2faEnabledValidation;
import com.alphaserve.twofactor.core.validation.XsrfTokenValidator;
import com.alphaserve.twofactor.core.validation.core.ValidationResult;
import com.alphaserve.twofactor.core.validation.core.Validator;
import com.atlassian.sal.api.user.UserProfile;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.gson.Gson;
import com.yubico.u2f.exceptions.U2fAuthenticationException;
import com.yubico.u2f.exceptions.U2fBadInputException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DeviceRestServiceImpl
implements DeviceRestService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceRestServiceImpl.class);
    private final UserService userService;
    private final LoggedTwoFactorValidation loggedTwoFactorValidation;
    private final ConfigurationService configurationService;
    private final U2fService u2fService;
    private final LoginActionService loginActionService;
    private final AppIdValidation appIdValidation;
    private final User2faEnabledValidation user2faEnabledValidation;
    private final XsrfTokenValidator xsrfTokenValidator;

    @Inject
    public DeviceRestServiceImpl(UserService userService, LoggedTwoFactorValidation loggedTwoFactorValidation, ConfigurationService configurationService, U2fService u2fService, LoginActionService loginActionService, Validator<U2FLoginDTO> u2FDeviceValidator, AppIdValidation appIdValidation, User2faEnabledValidation user2faEnabledValidation, XsrfTokenValidator xsrfTokenValidator) {
        this.userService = userService;
        this.loggedTwoFactorValidation = loggedTwoFactorValidation;
        this.configurationService = configurationService;
        this.u2fService = u2fService;
        this.loginActionService = loginActionService;
        this.appIdValidation = appIdValidation;
        this.user2faEnabledValidation = user2faEnabledValidation;
        this.xsrfTokenValidator = xsrfTokenValidator;
    }

    @Override
    public Response getCurrentUserU2FDevices(HttpServletRequest request) {
        UserProfile userProfile = this.userService.getUserProfile();
        return Response.ok((Object)new Gson().toJson(this.u2fService.getUserU2FDevices(userProfile))).build();
    }

    @Override
    public Response deleteCurrentUserU2FDevice(HttpServletRequest request, HttpServletResponse response, String id) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, response);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        validationResult = this.loggedTwoFactorValidation.validate(request.getSession());
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        UserProfile userProfile = this.userService.getUserProfile();
        this.u2fService.deleteDevice(userProfile, Integer.parseInt(id), request);
        return Response.ok((Object)new Gson().toJson(this.u2fService.getUserU2FDevices(userProfile))).build();
    }

    @Override
    public Response initU2fLogin(HttpServletRequest request) {
        if (!this.configurationService.getAuthU2FEnable()) {
            return Response.ok((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST)).build();
        }
        ValidationResult validationResult = this.appIdValidation.validate(AppIdUtils.getAppId(request));
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        UserProfile userProfile = this.userService.getUserProfile();
        try {
            return Response.ok((Object)new Gson().toJson(this.u2fService.initLogin(userProfile, request))).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
    }

    @Override
    public Response loginWithU2F(HttpServletRequest request, HttpServletResponse response, U2FLoginDTO u2FLoginDTO) {
        ValidationResult validationResult = this.xsrfTokenValidator.validate(request, response);
        if (validationResult.hasErrors()) {
            return this.getNotFoundValidationResponse(validationResult);
        }
        UserProfile userProfile = this.userService.getUserProfile();
        validationResult = this.user2faEnabledValidation.validate();
        if (validationResult.hasErrors()) {
            return this.getBadValidationResponse(validationResult);
        }
        try {
            this.u2fService.login(userProfile, request, response, u2FLoginDTO.getTokenResponse(), u2FLoginDTO.isRememberMe());
        }
        catch (U2fBadInputException e) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        catch (U2fAuthenticationException e) {
            this.loginActionService.failLogin(userProfile, request);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.ok().build();
    }

    @Override
    @Deprecated
    public Response initU2fDeviceRegistration(HttpServletRequest request) {
        return this.badRequest();
    }

    @Override
    @Deprecated
    public Response registerU2fDevice(HttpServletRequest request, HttpServletResponse response, U2FLoginDTO u2FLoginDTO) {
        return this.badRequest();
    }

    private Response getBadValidationResponse(ValidationResult validationResult) {
        try {
            return this.badRequest(mapper.writeValueAsString(validationResult.getErrors()));
        }
        catch (JsonProcessingException e) {
            log.error("Can't convert errors to JSON", (Throwable)e);
            return this.badRequest();
        }
    }
}

