/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.impl;

import com.alphaserve.twofactor.core.dtolayer.converter.DoForwardConverter;
import com.alphaserve.twofactor.core.dtolayer.dtos.CredentialDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.U2FDeviceRepresentation;
import com.alphaserve.twofactor.core.dtolayer.services.U2FDeviceDTOService;
import com.alphaserve.twofactor.core.model.AuthType;
import com.alphaserve.twofactor.core.model.LogActionType;
import com.alphaserve.twofactor.core.model.entities.Credential;
import com.alphaserve.twofactor.core.model.entities.U2FDevice;
import com.alphaserve.twofactor.core.services.LoginActionService;
import com.alphaserve.twofactor.core.services.U2fService;
import com.alphaserve.twofactor.core.services.entities.CredentialService;
import com.alphaserve.twofactor.core.services.entities.IpFilterService;
import com.alphaserve.twofactor.core.services.entities.LoggerActionService;
import com.alphaserve.twofactor.core.services.entities.U2FDeviceService;
import com.alphaserve.twofactor.core.utils.AppIdUtils;
import com.atlassian.sal.api.user.UserProfile;
import com.yubico.u2f.U2F;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.RegisterRequestData;
import com.yubico.u2f.data.messages.RegisterResponse;
import com.yubico.u2f.data.messages.SignRequestData;
import com.yubico.u2f.data.messages.SignResponse;
import com.yubico.u2f.exceptions.U2fAuthenticationException;
import com.yubico.u2f.exceptions.U2fBadInputException;
import com.yubico.u2f.exceptions.U2fRegistrationException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Named
public class U2fServiceImpl
implements U2fService {
    private final U2FDeviceService u2FDeviceService;
    private final U2FDeviceDTOService u2FDeviceDTOService;
    private final LoginActionService loginActionService;
    private final LoggerActionService loggerActionService;
    private final IpFilterService ipFilterService;
    private static final Logger log = LoggerFactory.getLogger(U2fServiceImpl.class);
    private Map<String, SignRequestData> signRequestData = new HashMap<String, SignRequestData>();
    private String loginRequestId;
    private final U2F u2f;
    private DoForwardConverter<Credential, CredentialDTO> converter;
    private CredentialService credentialService;
    private DoForwardConverter<Credential, U2FDeviceRepresentation> doForwardConverter;

    @Inject
    public U2fServiceImpl(U2FDeviceService u2FDeviceService, U2FDeviceDTOService u2FDeviceDTOService, LoginActionService loginActionService, LoggerActionService loggerActionService, IpFilterService ipFilterService, DoForwardConverter<Credential, CredentialDTO> converter, CredentialService credentialService, DoForwardConverter<Credential, U2FDeviceRepresentation> doForwardConverter) {
        this.loginActionService = loginActionService;
        this.loggerActionService = loggerActionService;
        this.ipFilterService = ipFilterService;
        this.converter = converter;
        this.credentialService = credentialService;
        this.doForwardConverter = doForwardConverter;
        this.u2f = new U2F();
        this.u2FDeviceService = u2FDeviceService;
        this.u2FDeviceDTOService = u2FDeviceDTOService;
    }

    @Override
    public List<U2FDeviceRepresentation> getUserU2FDevices(UserProfile userProfile) {
        List<U2FDeviceRepresentation> u2FDeviceRepresentations = this.u2FDeviceDTOService.getByUserKey(userProfile.getUserKey());
        List<U2FDeviceRepresentation> credentials = this.doForwardConverter.doForwardList(this.credentialService.getByUserKey(userProfile.getUserKey().getStringValue()));
        if (Objects.nonNull(credentials)) {
            u2FDeviceRepresentations.addAll(credentials);
        }
        return u2FDeviceRepresentations;
    }

    @Override
    public SignRequestData initLogin(UserProfile userProfile, HttpServletRequest request) throws Exception {
        SignRequestData u2fRequest = this.u2f.startSignature(AppIdUtils.getAppId(request), this.getRegistrations(userProfile));
        this.loginRequestId = u2fRequest.getRequestId();
        this.signRequestData.put(this.loginRequestId, u2fRequest);
        return u2fRequest;
    }

    @Override
    public RegisterRequestData initRegister(UserProfile userProfile, HttpServletRequest request) throws Exception {
        Iterable<DeviceRegistration> registrations = this.getRegistrations(userProfile);
        return this.u2f.startRegistration(AppIdUtils.getAppId(request), registrations);
    }

    @Override
    public DeviceRegistration register(UserProfile userProfile, HttpServletRequest req, RegisterRequestData registerRequestData, String tokenResponse, String deviceName) throws U2fBadInputException, U2fRegistrationException {
        RegisterResponse registerResponse = RegisterResponse.fromJson(tokenResponse);
        DeviceRegistration registration = this.u2f.finishRegistration(registerRequestData, registerResponse);
        this.u2FDeviceService.add(userProfile.getUserKey().getStringValue(), deviceName, new Date(System.currentTimeMillis()), registration.toJson());
        this.loggerActionService.add(userProfile.getUsername(), LogActionType.U2FADD, this.ipFilterService.getClientIpAddress(req));
        return registration;
    }

    @Override
    public void login(UserProfile userProfile, HttpServletRequest req, HttpServletResponse resp, String tokenResponse, boolean rememberMe) throws U2fBadInputException, U2fAuthenticationException {
        SignResponse signResponse = SignResponse.fromJson(tokenResponse);
        this.u2f.finishSignature(this.signRequestData.get(signResponse.getRequestId()), signResponse, this.getRegistrations(userProfile));
        this.loginActionService.login(userProfile, req, resp, AuthType.U2F_DEVICE, rememberMe);
    }

    @Override
    public void deleteDevice(UserProfile userProfile, int id, HttpServletRequest req) throws NoSuchElementException {
        for (U2FDevice device : this.u2FDeviceService.getByUserKey(userProfile.getUserKey())) {
            if (device.getID() != id) continue;
            log.info("User " + userProfile.getUsername() + " deleted device " + device.getName());
            this.loggerActionService.add(userProfile.getUsername(), LogActionType.U2FDELETE, this.ipFilterService.getClientIpAddress(req));
            this.u2FDeviceService.delete(device);
            return;
        }
    }

    @Override
    public void reset(UserProfile userProfile) {
        for (U2FDevice device : this.u2FDeviceService.getByUserKey(userProfile.getUserKey())) {
            this.u2FDeviceService.delete(device);
        }
    }

    private Iterable<DeviceRegistration> getRegistrations(UserProfile userProfile) throws U2fBadInputException {
        ArrayList<DeviceRegistration> registrations = new ArrayList<DeviceRegistration>();
        for (U2FDevice u2FDevice : this.u2FDeviceService.getByUserKey(userProfile.getUserKey())) {
            registrations.add(DeviceRegistration.fromJson(u2FDevice.getRegisterDataJson()));
        }
        return registrations;
    }
}

