/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.impl;

import com.alphaserve.twofactor.core.model.entities.cache.wraper.Auth2FACacheWrapper;
import com.alphaserve.twofactor.core.security.AuthFilterManager;
import com.alphaserve.twofactor.core.security.FilterState;
import com.alphaserve.twofactor.core.services.AuthLoginService;
import com.alphaserve.twofactor.core.services.ClusterService;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.Force2FAService;
import com.alphaserve.twofactor.core.services.ServiceDeskService;
import com.alphaserve.twofactor.core.services.entities.Auth2FAService;
import com.alphaserve.twofactor.core.services.entities.FailLogin2FAService;
import com.alphaserve.twofactor.core.services.entities.IpFilterService;
import com.alphaserve.twofactor.core.services.entities.LoggerActionService;
import com.alphaserve.twofactor.core.services.entities.RememberMeService;
import com.alphaserve.twofactor.core.utils.UrlUtils;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Qualifier;

@Named
public class ServiceDeskServiceImpl
implements ServiceDeskService {
    private final AuthLoginService authLoginService;
    private final LoggerActionService loggerActionService;
    private final RememberMeService rememberMeService;
    private final IpFilterService ipFilterService;
    private final Auth2FAService auth2FAService;
    private final Force2FAService force2FAService;
    private final ConfigurationService configurationService;
    @ComponentImport
    private final UserManager userManager;
    private final FailLogin2FAService failLogin2FAService;
    private final AuthFilterManager authFilterManager;
    @ComponentImport
    private final PluginAccessor pluginAccessor;
    private final ClusterService clusterService;

    @Inject
    public ServiceDeskServiceImpl(AuthLoginService authLoginService, LoggerActionService loggerActionService, RememberMeService rememberMeService, IpFilterService ipFilterService, Auth2FAService auth2FAService, Force2FAService force2FAService, ConfigurationService configurationService, @Qualifier(value="userManager") UserManager userManager, FailLogin2FAService failLogin2FAService, PluginAccessor pluginAccessor, ClusterService clusterService, AuthFilterManager authFilterManager) {
        this.authLoginService = authLoginService;
        this.loggerActionService = loggerActionService;
        this.rememberMeService = rememberMeService;
        this.ipFilterService = ipFilterService;
        this.auth2FAService = auth2FAService;
        this.force2FAService = force2FAService;
        this.configurationService = configurationService;
        this.userManager = userManager;
        this.failLogin2FAService = failLogin2FAService;
        this.pluginAccessor = pluginAccessor;
        this.authFilterManager = authFilterManager;
        this.clusterService = clusterService;
    }

    @Override
    public boolean isRequired2fa(HttpServletRequest request, HttpServletResponse response) {
        UserProfile remoteUser = this.userManager.getRemoteUser();
        Auth2FACacheWrapper auth2FA = this.auth2FAService.getWrappedEntityByUserKey(remoteUser.getUserKey());
        FilterState authResult = this.authFilterManager.getAuthResult(this.auth2FAService, this.authLoginService, this.loggerActionService, this.rememberMeService, this.ipFilterService, request, this.force2FAService, this.configurationService, this.failLogin2FAService, this.pluginAccessor, auth2FA, remoteUser, this.clusterService, UrlUtils.getRequestPath(request.getRequestURI()));
        switch (authResult) {
            case FORCE: 
            case NOT_ALLOWED: 
            case LOCKED: {
                return true;
            }
        }
        return false;
    }
}

