/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.impl;

import com.alphaserve.twofactor.core.dtolayer.dtos.IpRepresentation;
import com.alphaserve.twofactor.core.model.LogActionType;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.PublicKeyService;
import com.alphaserve.twofactor.core.services.entities.CredentialService;
import com.alphaserve.twofactor.core.services.entities.IpFilterService;
import com.alphaserve.twofactor.core.services.entities.LoggerActionService;
import com.alphaserve.twofactor.core.services.entities.impl.JiraCredentialRepository;
import com.alphaserve.twofactor.core.utils.StringUsefulUtils;
import com.alphaserve.twofactor.core.utils.UrlUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.yubico.webauthn.AssertionRequest;
import com.yubico.webauthn.AssertionResult;
import com.yubico.webauthn.FinishAssertionOptions;
import com.yubico.webauthn.FinishRegistrationOptions;
import com.yubico.webauthn.RegistrationResult;
import com.yubico.webauthn.RelyingParty;
import com.yubico.webauthn.StartAssertionOptions;
import com.yubico.webauthn.StartRegistrationOptions;
import com.yubico.webauthn.data.AttestationConveyancePreference;
import com.yubico.webauthn.data.AuthenticatorAssertionResponse;
import com.yubico.webauthn.data.AuthenticatorAttachment;
import com.yubico.webauthn.data.AuthenticatorAttestationResponse;
import com.yubico.webauthn.data.AuthenticatorSelectionCriteria;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.ClientAssertionExtensionOutputs;
import com.yubico.webauthn.data.ClientRegistrationExtensionOutputs;
import com.yubico.webauthn.data.PublicKeyCredential;
import com.yubico.webauthn.data.PublicKeyCredentialCreationOptions;
import com.yubico.webauthn.data.RelyingPartyIdentity;
import com.yubico.webauthn.data.ResidentKeyRequirement;
import com.yubico.webauthn.data.UserIdentity;
import com.yubico.webauthn.data.UserVerificationRequirement;
import com.yubico.webauthn.exception.AssertionFailedException;
import com.yubico.webauthn.exception.RegistrationFailedException;
import com.yubico.webauthn.extension.appid.AppId;
import com.yubico.webauthn.extension.appid.InvalidAppIdException;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Named
@Component
public class PublicKeyServiceImpl
implements PublicKeyService {
    private final int TIMEOUT = 60000;
    private String url;
    private static final Logger log = LoggerFactory.getLogger(PublicKeyServiceImpl.class);
    public static final String PUBLIC_KEY_CREDENTIAL_KEY = "publicKey_credential_creation_options";
    public static final String PUBLIC_KEY_CREDENTIAL_NAME_KEY = "publicKey_credential_name";
    public static final String ASSERTION_REQUEST_KEY = "assertion_request";
    private final ConfigurationService configurationService;
    private final CredentialService credentialService;
    private JiraCredentialRepository jiraCredentialRepository;
    @ComponentImport(value="com.atlassian.sal.api.ApplicationProperties")
    private final ApplicationProperties applicationProperties;
    @ComponentImport
    private final UserManager salUserManager;
    private LoggerActionService loggerActionService;
    private final IpFilterService ipFilterService;

    @Inject
    public PublicKeyServiceImpl(ConfigurationService configurationService, CredentialService credentialService, JiraCredentialRepository jiraCredentialRepository, ApplicationProperties applicationProperties, @Qualifier(value="userManager") UserManager salUserManager, LoggerActionService loggerActionService, IpFilterService ipFilterService) {
        this.configurationService = configurationService;
        this.credentialService = credentialService;
        this.jiraCredentialRepository = jiraCredentialRepository;
        this.applicationProperties = applicationProperties;
        this.salUserManager = salUserManager;
        this.loggerActionService = loggerActionService;
        this.ipFilterService = ipFilterService;
        this.init();
    }

    protected void init() {
        this.url = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
    }

    private Optional<AppId> buildAppId(String appId) {
        try {
            return Optional.of(new AppId(appId));
        }
        catch (InvalidAppIdException e) {
            log.debug("The server is not using HTTPS");
            return Optional.empty();
        }
    }

    public RelyingParty generateRelyingParty() {
        RelyingPartyIdentity partyIdentity = RelyingPartyIdentity.builder().id(UrlUtils.getDomain(this.url)).name(this.configurationService.getAuthLabel()).build();
        return RelyingParty.builder().identity(partyIdentity).credentialRepository(this.jiraCredentialRepository).appId(this.buildAppId(this.url)).allowOriginPort(true).allowOriginSubdomain(true).attestationConveyancePreference(AttestationConveyancePreference.valueOf(this.configurationService.getWebAuthnAttestationType())).build();
    }

    @Override
    public String getPublicKey(HttpServletRequest request, String name) throws JsonProcessingException {
        UserProfile remoteUser = this.salUserManager.getRemoteUser();
        PublicKeyCredentialCreationOptions registrationRequest = this.generateRelyingParty().startRegistration(StartRegistrationOptions.builder().user(UserIdentity.builder().name(remoteUser.getUsername()).displayName(remoteUser.getFullName()).id(new ByteArray(this.generateBytes(remoteUser.getUserKey().getStringValue()))).build()).authenticatorSelection(AuthenticatorSelectionCriteria.builder().authenticatorAttachment(this.getAuthenticatorAttachment()).residentKey(this.configurationService.getWebAuthnResidentKey() ? ResidentKeyRequirement.REQUIRED : ResidentKeyRequirement.DISCOURAGED).userVerification(UserVerificationRequirement.valueOf(this.configurationService.getWebAuthnUserVerification())).build()).build());
        this.setAttributeToSession(request, PUBLIC_KEY_CREDENTIAL_KEY, registrationRequest);
        this.setAttributeToSession(request, PUBLIC_KEY_CREDENTIAL_NAME_KEY, name);
        return registrationRequest.toJson();
    }

    private Optional<AuthenticatorAttachment> getAuthenticatorAttachment() {
        if (Objects.isNull(this.configurationService.getWebAuthnAuthenticatorType()) || this.configurationService.getWebAuthnAuthenticatorType().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(AuthenticatorAttachment.valueOf(this.configurationService.getWebAuthnAuthenticatorType()));
    }

    @Override
    public boolean finishRegistration(HttpServletRequest request, String response, boolean isReadOnlyMode) throws IOException, RegistrationFailedException {
        PublicKeyCredentialCreationOptions registrationRequest = (PublicKeyCredentialCreationOptions)this.getAttributeFromSession(request, PUBLIC_KEY_CREDENTIAL_KEY);
        UserProfile remoteUser = this.salUserManager.getRemoteUser();
        if (Objects.isNull(remoteUser) || Objects.isNull(registrationRequest)) {
            return false;
        }
        PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> pkc = PublicKeyCredential.parseRegistrationResponseJson(response);
        RegistrationResult result = this.generateRelyingParty().finishRegistration(FinishRegistrationOptions.builder().request(registrationRequest).response(pkc).build());
        this.credentialService.add(remoteUser.getUserKey().getStringValue(), result.getPublicKeyCose().getBase64Url(), result.getKeyId().getType().getId(), result.getKeyId().getId().getBase64Url(), registrationRequest.getUser().getId().getBase64Url(), (String)this.getAttributeFromSession(request, PUBLIC_KEY_CREDENTIAL_NAME_KEY), new Date(System.currentTimeMillis()));
        this.cleanAttributeToSession(request, PUBLIC_KEY_CREDENTIAL_KEY);
        this.cleanAttributeToSession(request, PUBLIC_KEY_CREDENTIAL_NAME_KEY);
        List<String> clientIpAddresses = this.ipFilterService.getClientIpAddress(request).stream().map(IpRepresentation::getIp).collect(Collectors.toList());
        this.loggerActionService.add(remoteUser.getUsername(), LogActionType.U2FADD, StringUsefulUtils.getComaSplitStringFromList(clientIpAddresses));
        return true;
    }

    @Override
    public String initAssertion(HttpServletRequest request, String username) throws JsonProcessingException {
        AssertionRequest assertionRequest = this.generateRelyingParty().startAssertion(StartAssertionOptions.builder().username(username).timeout(60000L).userVerification(UserVerificationRequirement.valueOf(this.configurationService.getWebAuthnUserVerification())).build());
        this.setAttributeToSession(request, ASSERTION_REQUEST_KEY, assertionRequest);
        return assertionRequest.toJson();
    }

    @Override
    public AssertionResult finishAssertion(HttpServletRequest request, String responseJson) throws IOException, AssertionFailedException {
        PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> pkc = PublicKeyCredential.parseAssertionResponseJson(responseJson);
        AssertionRequest assertionRequest = (AssertionRequest)this.getAttributeFromSession(request, ASSERTION_REQUEST_KEY);
        if (Objects.isNull(assertionRequest)) {
            throw new NullPointerException("Empty ASSERTION_REQUEST_KEY in session");
        }
        AssertionResult result = this.generateRelyingParty().finishAssertion(FinishAssertionOptions.builder().request(assertionRequest).response(pkc).build());
        this.cleanAttributeToSession(request, ASSERTION_REQUEST_KEY);
        return result;
    }

    protected byte[] generateBytes(String userKey) {
        return DigestUtils.md5Hex(userKey).getBytes();
    }

    protected void setAttributeToSession(HttpServletRequest request, String name, Object object) {
        request.getSession().setAttribute(name, object);
    }

    protected Object getAttributeFromSession(HttpServletRequest request, String name) {
        return request.getSession().getAttribute(name);
    }

    protected void cleanAttributeToSession(HttpServletRequest request, String name) {
        request.getSession().removeAttribute(name);
    }
}

