/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.impl;

import com.alphaserve.twofactor.core.Plugin2FACoreContext;
import com.alphaserve.twofactor.core.model.entities.Auth2FA;
import com.alphaserve.twofactor.core.model.entities.Credential;
import com.alphaserve.twofactor.core.model.entities.FailLogin2FA;
import com.alphaserve.twofactor.core.model.entities.IpFilter;
import com.alphaserve.twofactor.core.model.entities.LogAction;
import com.alphaserve.twofactor.core.model.entities.RememberMe;
import com.alphaserve.twofactor.core.model.entities.SecretKey;
import com.alphaserve.twofactor.core.model.entities.U2FDevice;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.PluginInfoService;
import com.alphaserve.twofactor.core.services.cache.Auth2FACacheManager;
import com.alphaserve.twofactor.core.utils.StringUsefulUtils;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.beans.factory.annotation.Qualifier;

@Named
public class PluginInfoServiceImpl
implements PluginInfoService {
    public static final String DELETE_ALL_QUERY = "ID > ?";
    private static boolean IS_SYSTEM_ADMIN = false;
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;
    private final ConfigurationService configurationService;
    @ComponentImport
    private final ActiveObjects ao;
    @ComponentImport
    private final UserManager userManager;
    private final Plugin2FACoreContext pluginContext;
    private final Auth2FACacheManager auth2FACacheManager;

    @Inject
    public PluginInfoServiceImpl(PluginLicenseManager pluginLicenseManager, ConfigurationService configurationService, ActiveObjects ao, @Qualifier(value="userManager") UserManager userManager, Plugin2FACoreContext pluginContext, Auth2FACacheManager auth2FACacheManager) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.configurationService = configurationService;
        this.ao = ao;
        this.userManager = userManager;
        this.pluginContext = pluginContext;
        this.auth2FACacheManager = auth2FACacheManager;
    }

    @Override
    public boolean isPluginLicensed() {
        return this.pluginLicenseManager.getLicense().isDefined() && !((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined();
    }

    @Override
    public boolean isAdministrator() {
        UserProfile remoteUser = this.userManager.getRemoteUser();
        if (IS_SYSTEM_ADMIN) {
            return true;
        }
        if (Objects.isNull(remoteUser)) {
            return false;
        }
        return this.userManager.isAdmin(remoteUser.getUserKey()) || this.userManager.isSystemAdmin(remoteUser.getUserKey());
    }

    @Override
    public void deleteAllData() {
        this.ao.deleteWithSQL(Auth2FA.class, DELETE_ALL_QUERY, new Object[]{0});
        this.ao.deleteWithSQL(IpFilter.class, DELETE_ALL_QUERY, new Object[]{0});
        this.ao.deleteWithSQL(LogAction.class, DELETE_ALL_QUERY, new Object[]{0});
        this.ao.deleteWithSQL(SecretKey.class, DELETE_ALL_QUERY, new Object[]{0});
        this.ao.deleteWithSQL(U2FDevice.class, DELETE_ALL_QUERY, new Object[]{0});
        this.ao.deleteWithSQL(RememberMe.class, DELETE_ALL_QUERY, new Object[]{0});
        this.ao.deleteWithSQL(FailLogin2FA.class, DELETE_ALL_QUERY, new Object[]{0});
        this.ao.deleteWithSQL(Credential.class, DELETE_ALL_QUERY, new Object[]{0});
        this.auth2FACacheManager.deleteAll();
        this.configurationService.setAuthForceType(this.pluginContext.getDefaultForceType());
        this.configurationService.setAuthIPWhitelistEnable(false);
        this.configurationService.setTimeStep(this.pluginContext.getDefaultTimeStep() + "");
        this.configurationService.setAuthLoggerEnable(true);
        this.configurationService.setAuthForceGroupsList(StringUsefulUtils.splitToList(this.pluginContext.getDefaultForceGroupsList(), ",").toArray(new String[0]), "forceGroups");
        this.configurationService.setAuthForceAllExceptGroupsList(new String[0], "forceAllExceptGroups");
        this.configurationService.setAuthLabel(this.pluginContext.getDefaultAuthLabel());
        this.configurationService.setAuthKeySize(Integer.toString(this.pluginContext.getDefaultKeySize()));
        this.configurationService.setRememberMeFeatureEnable(false);
        this.configurationService.setAuthU2FEnable(true);
        this.configurationService.setRememberMeExpireHours(String.valueOf(this.pluginContext.getDefaultRememberMeExpireHours()));
        this.configurationService.setAuthDuoEnable(false);
        this.configurationService.setOAuthWhitelistEnable(false);
        this.configurationService.setAuthBruteForceEnable(false);
        this.configurationService.setNumberAttempts(String.valueOf(3));
        this.configurationService.setLockoutPeriod(String.valueOf(15));
        this.configurationService.setAutoLoginEnable(false);
        this.configurationService.setHideDeactivate2fa(false);
        this.configurationService.setHide2faInServiceDesk(false);
        this.configurationService.setAuthPermissionType("permissionNone");
        this.configurationService.setAuthPermissionGroupsList(new String[0], "permissionGroups");
        this.configurationService.setAuthPermissionUsersList(new String[0], "permissionUsers");
        this.configurationService.setAuthTrustedBulkEnable(false);
        this.configurationService.setRestEndpointsRestriction(false);
        this.configurationService.setWebAuthnAttestationType(this.pluginContext.getDefaultAttestationType());
        this.configurationService.setWebAuthnAuthenticatorType(this.pluginContext.getDefaultAttestationType());
        this.configurationService.setWebAuthnUserVerification(this.pluginContext.getDefaultUserVerification());
        this.configurationService.setWebAuthnResidentKey(this.pluginContext.getDefaultResidentKey());
        this.configurationService.setWhitelistUrls("");
        this.configurationService.setAllowedToSkimByPlugin(false);
        this.configurationService.setAuthForceDirectoriesList(new String[0], "forceDirectories");
        this.configurationService.setAuthForceAllExceptDirectoriesList(new String[0], "forceAllExceptDirectories");
    }

    @Override
    public void setIsSystemAdmin(boolean isSystemAdmin) {
        IS_SYSTEM_ADMIN = isSystemAdmin;
    }

    @Override
    public boolean isSystemAdmin() {
        return IS_SYSTEM_ADMIN;
    }
}

