/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.impl;

import com.alphaserve.twofactor.core.dtolayer.converter.DoForwardConverter;
import com.alphaserve.twofactor.core.dtolayer.dtos.PaginationWrapper;
import com.alphaserve.twofactor.core.dtolayer.dtos.logger.LogActionDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.logger.LogActionFilterDTO;
import com.alphaserve.twofactor.core.model.IpHeaderModels;
import com.alphaserve.twofactor.core.model.LogActionType;
import com.alphaserve.twofactor.core.model.LoggerDate;
import com.alphaserve.twofactor.core.model.entities.LogAction;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.LoggerService;
import com.alphaserve.twofactor.core.services.entities.LoggerActionService;
import com.alphaserve.twofactor.core.utils.IpUtils;
import com.alphaserve.twofactor.core.utils.StringUsefulUtils;
import com.atlassian.sal.api.user.UserProfile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import net.java.ao.Query;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Named
@Component
public class LoggerServiceImpl
implements LoggerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoggerServiceImpl.class);
    private static final int ENTRIES_IN_PAGE = 12;
    private LoggerActionService loggerActionService;
    private DoForwardConverter<LogAction, LogActionDTO> converter;
    private ConfigurationService configurationService;

    @Inject
    public LoggerServiceImpl(LoggerActionService loggerActionService, DoForwardConverter<LogAction, LogActionDTO> converter, ConfigurationService configurationService) {
        this.loggerActionService = loggerActionService;
        this.converter = converter;
        this.configurationService = configurationService;
    }

    @Override
    public PaginationWrapper<LogActionDTO> getPage(LogActionFilterDTO filterDTO) {
        Query query = this.getQuery(filterDTO).order("DATE DESC").offset((filterDTO.getPage() - 1) * 12).limit(12);
        long count = 1L + (this.loggerActionService.getCount(this.getQuery(filterDTO)) - 1L) / 12L;
        return PaginationWrapper.builder().entities(this.converter.doForwardList(this.loggerActionService.getByQuery(query))).pageCount(count).build();
    }

    @Override
    public void addLog(LogActionType actionType, HttpServletRequest request, UserProfile userProfile) {
        if (Objects.nonNull(userProfile)) {
            this.addLog(actionType, request, userProfile.getUsername());
        }
    }

    @Override
    public void addLog(LogActionType actionType, HttpServletRequest request, String username) {
        if (Objects.nonNull(username)) {
            List<String> clientIpAddresses = this.getClientIpAddress(request);
            this.loggerActionService.add(username, actionType, StringUsefulUtils.getComaSplitStringFromList(clientIpAddresses));
        }
    }

    private Query getQuery(LogActionFilterDTO filter) {
        ArrayList<Pair<String, Object>> queries = new ArrayList<Pair<String, Object>>();
        String username = filter.getUsername();
        Date startDate = filter.getStartDate();
        Date finishDate = filter.getFinishDate();
        String action = filter.getAction();
        String userIp = filter.getUserIp();
        queries.add(Pair.of("ACTIONTYPE != ?", "Undefined"));
        queries.add(Pair.of("ACTIONTYPE != ?", "Enter"));
        if (StringUtils.isNoneBlank(username)) {
            queries.add(Pair.of("USERNAME LIKE ?", username));
        }
        boolean isStartNotNull = Objects.nonNull(startDate);
        boolean isFinishNotNull = Objects.nonNull(finishDate);
        if (isStartNotNull) {
            queries.add(Pair.of("DATE >= ?", startDate));
        }
        if (isFinishNotNull) {
            queries.add(Pair.of("DATE <= ?", finishDate));
        }
        if (Objects.nonNull(action) && !action.equals("All")) {
            queries.add(Pair.of("(ACTIONTYPE = 'Add' OR ACTIONTYPE = ?)", action.toUpperCase()));
        }
        if (StringUtils.isNoneBlank(userIp)) {
            queries.add(Pair.of("USERIP = ?", userIp));
        }
        Query query = Query.select();
        if (!queries.isEmpty()) {
            String queryKeysText = queries.stream().map(Pair::getLeft).collect(Collectors.joining(" AND "));
            Object[] queryArgs = queries.stream().map(Pair::getRight).toArray();
            query = query.where(queryKeysText, queryArgs);
        }
        return query;
    }

    @Override
    public List<String> getClientIpAddress(HttpServletRequest request) {
        ArrayList<String> ipAddresses = new ArrayList<String>();
        for (String header : IpHeaderModels.IP_HEADER_ALL_CANDIDATES) {
            String ip = request.getHeader(header);
            ipAddresses.addAll(this.getValidIpAddresses(ip, header));
        }
        ipAddresses.add(request.getRemoteAddr());
        return ipAddresses;
    }

    @Override
    public void deleteLogs(LoggerDate loggerDate) {
        if (loggerDate.equals((Object)LoggerDate.ALL)) {
            this.loggerActionService.deleteAll();
        } else {
            this.loggerActionService.deleteEarlierThan(new Date(Timestamp.valueOf(this.generateLocalDataTimeForDelete(loggerDate)).getTime()));
        }
    }

    @Override
    public List<LogActionDTO> getAllLogs(LogActionFilterDTO filterDTO) {
        Query query = this.getQuery(filterDTO).order("DATE DESC");
        return this.converter.doForwardList(this.loggerActionService.getByQuery(query));
    }

    private LocalDateTime generateLocalDataTimeForDelete(LoggerDate loggerDate) {
        if (!loggerDate.isMonth()) {
            return LocalDateTime.now().minusDays(loggerDate.getValue());
        }
        return LocalDateTime.now().minusMonths(loggerDate.getValue());
    }

    private List<String> getValidIpAddresses(String headerIp, String header) {
        String[] split;
        ArrayList<String> validIpAddresses = new ArrayList<String>();
        if (Objects.isNull(headerIp)) {
            return validIpAddresses;
        }
        for (String ipEntry : split = headerIp.split(", ")) {
            if (!Objects.nonNull(ipEntry) || ipEntry.length() == 0 || "unknown".equalsIgnoreCase(ipEntry)) continue;
            try {
                ipEntry = IpUtils.substringPort(ipEntry);
                InetAddress.getByName(ipEntry);
                validIpAddresses.add(ipEntry);
            }
            catch (UnknownHostException e) {
                log.error("Wrong IP", (Throwable)e);
            }
        }
        return validIpAddresses;
    }
}

