/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.impl;

import com.alphaserve.twofactor.core.model.entities.cache.wraper.Auth2FACacheWrapper;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.Force2FAService;
import com.alphaserve.twofactor.core.services.entities.Auth2FAService;
import com.alphaserve.twofactor.core.services.entities.impl.DirectoryServiceImpl;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Named
@Service
public class Force2FAServiceImpl
implements Force2FAService {
    private final ConfigurationService configurationService;
    private final Auth2FAService auth2FAService;
    @ComponentImport
    private final UserManager userManager;
    private final DirectoryServiceImpl directoryService;

    @Inject
    public Force2FAServiceImpl(ConfigurationService configurationService, Auth2FAService auth2FAService, @Qualifier(value="userManager") UserManager userManager, DirectoryServiceImpl directoryService) {
        this.configurationService = configurationService;
        this.auth2FAService = auth2FAService;
        this.userManager = userManager;
        this.directoryService = directoryService;
    }

    @Override
    public boolean isUserNeedToSetup2FA(UserProfile userProfile) {
        return this.isUserInForce(userProfile);
    }

    @Override
    public boolean isUserInForce(UserProfile userProfile) {
        if (Objects.isNull(userProfile)) {
            return false;
        }
        Auth2FACacheWrapper auth2FA = this.auth2FAService.getWrappedEntityByUserKey(userProfile.getUserKey());
        return this.isUserInForce(userProfile, auth2FA);
    }

    @Override
    public boolean isUserInForce(UserProfile userProfile, Auth2FACacheWrapper auth2FA) {
        if (Objects.isNull(userProfile)) {
            return false;
        }
        if (!auth2FA.isActive() && !auth2FA.isConfirmed()) {
            switch (this.configurationService.getAuthForceType()) {
                case "forceAll": {
                    return true;
                }
                case "forceGroups": {
                    return this.isUserInGroups(userProfile, this.configurationService.getAuthForceGroupsList());
                }
                case "forceAllExceptGroups": {
                    return !this.isUserInGroups(userProfile, this.configurationService.getAuthForceAllExceptGroupsList());
                }
                case "forceDirectories": {
                    return this.directoryService.isUserInDirectories(this.userManager.getRemoteUser().getUsername(), this.configurationService.getAuthForceDirectoriesList());
                }
                case "forceAllExceptDirectories": {
                    return !this.directoryService.isUserInDirectories(this.userManager.getRemoteUser().getUsername(), this.configurationService.getAuthForceAllExceptDirectoriesList());
                }
            }
            return false;
        }
        return false;
    }

    private boolean isUserInGroups(UserProfile userProfile, String[] groupsList) {
        for (String group : groupsList) {
            if (!this.userManager.isUserInGroup(userProfile.getUserKey(), group)) continue;
            return true;
        }
        return false;
    }
}

