/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.impl;

import com.alphaserve.twofactor.core.dtolayer.converter.DoForwardConverter;
import com.alphaserve.twofactor.core.dtolayer.dtos.CredentialDTO;
import com.alphaserve.twofactor.core.dtolayer.dtos.IpRepresentation;
import com.alphaserve.twofactor.core.model.LogActionType;
import com.alphaserve.twofactor.core.model.entities.Credential;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.LoggerService;
import com.alphaserve.twofactor.core.services.UserService;
import com.alphaserve.twofactor.core.services.entities.CredentialService;
import com.alphaserve.twofactor.core.services.entities.IpFilterService;
import com.alphaserve.twofactor.core.services.entities.LoggerActionService;
import com.alphaserve.twofactor.core.utils.StringUsefulUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Named
@Component
public class DefaultUserServiceImpl
implements UserService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultUserServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(UserService.class);
    private ConfigurationService configurationService;
    private LoggerActionService loggerActionService;
    private LoggerService loggerService;
    private CredentialService credentialService;
    private DoForwardConverter<Credential, CredentialDTO> converter;
    private final IpFilterService ipFilterService;
    @ComponentImport
    private final UserManager salUserManager;

    @Inject
    public DefaultUserServiceImpl(@Qualifier(value="userManager") UserManager salUserManager, CredentialService credentialService, DoForwardConverter<Credential, CredentialDTO> converter, ConfigurationService configurationService, LoggerService loggerService, LoggerActionService loggerActionService, IpFilterService ipFilterService) {
        this.salUserManager = salUserManager;
        this.credentialService = credentialService;
        this.converter = converter;
        this.configurationService = configurationService;
        this.loggerService = loggerService;
        this.loggerActionService = loggerActionService;
        this.ipFilterService = ipFilterService;
    }

    @Override
    public UserProfile getUserProfile() {
        return this.salUserManager.getRemoteUser();
    }

    @Override
    public UserProfile getUserProfile(String username) {
        return this.salUserManager.getUserProfile(username);
    }

    @Override
    public boolean isUserHasDevice(String username) {
        String userKey = this.getUserKey(username);
        return Objects.nonNull(userKey) && this.credentialService.getByUserKey(userKey).size() > 0;
    }

    @Override
    public String getUserKey(String username) {
        try {
            return this.getUser(username).getUserKey().getStringValue();
        }
        catch (NullPointerException e) {
            logger.info("User not found by username", (Throwable)e);
            return null;
        }
    }

    protected UserProfile getUser(String username) throws NullPointerException {
        UserProfile userByName = this.salUserManager.getUserProfile(username);
        if (Objects.isNull(userByName)) {
            throw new NullPointerException("User not found");
        }
        return userByName;
    }

    @Override
    public List<CredentialDTO> geUserCredentialsDTO() throws NullPointerException {
        return this.converter.doForwardList(this.credentialService.getByUserKey(this.getUser().getUserKey().getStringValue()));
    }

    @Override
    public boolean deleteCredential(HttpServletRequest request, String id, boolean isReadOnlyMode) throws NullPointerException {
        boolean isDeleted = this.credentialService.deleteByIdAndUserKey(Long.parseLong(id), this.getUser().getUserKey().getStringValue());
        if (isDeleted) {
            List<String> clientIpAddresses = this.ipFilterService.getClientIpAddress(request).stream().map(IpRepresentation::getIp).collect(Collectors.toList());
            this.loggerActionService.add(this.getUser().getUsername(), LogActionType.U2FDELETE, StringUsefulUtils.getComaSplitStringFromList(clientIpAddresses));
        }
        return isDeleted;
    }

    @Override
    public Long getCredentialCountByName(String name) {
        return this.credentialService.getCredentialCountByName(name, this.getUser().getUserKey().getStringValue());
    }

    protected UserProfile getUser() throws NullPointerException {
        UserProfile remoteUser = this.getUserProfile();
        if (Objects.isNull(remoteUser)) {
            throw new NullPointerException("Can't get current user. UserProfile = null");
        }
        return remoteUser;
    }
}

