/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.entities.impl;

import com.alphaserve.twofactor.core.model.entities.U2FDevice;
import com.alphaserve.twofactor.core.services.entities.U2FDeviceService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class U2FDeviceServiceImpl
implements U2FDeviceService {
    @ComponentImport
    protected final ActiveObjects ao;
    @ComponentImport
    protected final UserManager salUserManager;

    public U2FDeviceServiceImpl(ActiveObjects ao, @Qualifier(value="userManager") UserManager salUserManager) {
        this.ao = Preconditions.checkNotNull(ao);
        this.salUserManager = salUserManager;
    }

    @Override
    public U2FDevice add(String userKey, String name, Date createdAt, String registerJson) {
        return (U2FDevice)this.ao.executeInTransaction(() -> {
            U2FDevice u2FD = (U2FDevice)this.ao.create(U2FDevice.class, new DBParam[0]);
            u2FD.setCreatedAt(createdAt);
            u2FD.setName(name);
            u2FD.setUserKey(userKey);
            u2FD.setRegisterDataJson(registerJson);
            u2FD.save();
            return u2FD;
        });
    }

    @Override
    public U2FDevice getById(int id) {
        return (U2FDevice)this.ao.executeInTransaction(() -> (U2FDevice)this.ao.get(U2FDevice.class, (Object)id));
    }

    @Override
    public List<U2FDevice> getByUserKey(UserKey userKey) {
        Query query = Query.select().where("USERKEY = ?", new Object[]{userKey.getStringValue()});
        U2FDevice[] userAuthSetting = (U2FDevice[])this.ao.executeInTransaction(() -> (U2FDevice[])this.ao.find(U2FDevice.class, query));
        if (Objects.isNull(userAuthSetting)) {
            return new ArrayList<U2FDevice>();
        }
        return Lists.newArrayList(userAuthSetting);
    }

    @Override
    public void delete(U2FDevice auth2FA) {
        this.ao.delete(new RawEntity[]{auth2FA});
    }

    @Override
    public boolean hasRemoteUserU2FDevice() {
        UserProfile remoteUser = this.salUserManager.getRemoteUser();
        if (Objects.isNull(remoteUser)) {
            return false;
        }
        return (Integer)this.ao.executeInTransaction(() -> this.ao.count(U2FDevice.class, Query.select().where("USERKEY = ?", new Object[]{remoteUser.getUserKey().getStringValue()}))) > 0;
    }

    @Override
    public long getDeviceCountByName(String name) {
        UserProfile remoteUser = this.salUserManager.getRemoteUser();
        if (Objects.isNull(remoteUser)) {
            return 0L;
        }
        return ((Integer)this.ao.executeInTransaction(() -> this.ao.count(U2FDevice.class, Query.select().where("NAME = ? AND USERKEY = ?", new Object[]{name, remoteUser.getUserKey().getStringValue()})))).intValue();
    }

    @Override
    public void deleteAll() {
        this.ao.deleteWithSQL(U2FDevice.class, "ID > ?", new Object[]{0});
    }

    @Override
    public void deleteByUserKey(String userKey) {
        this.ao.deleteWithSQL(U2FDevice.class, "USERKEY = ?", new Object[]{userKey});
    }
}

