/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.entities.impl;

import com.alphaserve.twofactor.core.model.entities.RememberMe;
import com.alphaserve.twofactor.core.model.exceptions.NotFoundException;
import com.alphaserve.twofactor.core.services.ClusterService;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.entities.RememberMeService;
import com.alphaserve.twofactor.core.utils.CookieUtils;
import com.alphaserve.twofactor.core.utils.DateUtils;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Qualifier;

@Named
public class RememberMeServiceImpl
implements RememberMeService {
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final ActiveObjects ao;
    private final ConfigurationService configurationService;
    public static final String REMEMBER_ME_PREFIX = "remember-";
    public static final String REMEMBER_SESSION_PREFIX = "remember-session-";
    private SimpleDateFormat formatTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final ClusterService clusterService;

    @Inject
    public RememberMeServiceImpl(@Qualifier(value="userManager") UserManager userManager, ActiveObjects ao, ConfigurationService configurationService, ClusterService clusterService) {
        this.userManager = userManager;
        this.ao = ao;
        this.configurationService = configurationService;
        this.clusterService = clusterService;
    }

    @Override
    public RememberMe add(Date expiredDate, String userKey) {
        return (RememberMe)this.ao.executeInTransaction(() -> {
            String date = this.formatTime.format(expiredDate);
            RememberMe rememberMe = (RememberMe)this.ao.create(RememberMe.class, new DBParam[0]);
            rememberMe.setUserKey(userKey);
            rememberMe.setHash(this.invokeHash(userKey, date));
            rememberMe.setExpiredDate(expiredDate);
            rememberMe.save();
            return rememberMe;
        });
    }

    private String invokeHash(String userKey, String date) {
        return DigestUtils.md5Hex(date + userKey);
    }

    @Override
    public RememberMe getByUserKey(String userKey, String hash) throws NotFoundException {
        RememberMe[] rememberMes = (RememberMe[])this.ao.executeInTransaction(() -> (RememberMe[])this.ao.find(RememberMe.class, Query.select().where("USER_KEY = ? AND HASH = ? AND EXPIRED_DATE > ?", new Object[]{userKey, hash, new Date()}).limit(1)));
        if (rememberMes == null || rememberMes.length == 0) {
            throw new NotFoundException();
        }
        return rememberMes[0];
    }

    @Override
    public void deleteByExpiredDate() {
        this.ao.executeInTransaction(() -> this.ao.deleteWithSQL(RememberMe.class, "EXPIRED_DATE <= ?", new Object[]{new Date()}));
    }

    @Override
    public void deleteRememberedUserClusterByUserKey(String userKey) {
        this.ao.executeInTransaction(() -> this.ao.deleteWithSQL(RememberMe.class, "USER_KEY = ?", new Object[]{"remember-session-::" + userKey}));
    }

    @Override
    public void deleteRememberedUserClusterByUserKey(HttpSession httpSession, String userKey) {
        this.deleteRememberedUserClusterByUserKey(userKey);
        httpSession.removeAttribute(REMEMBER_SESSION_PREFIX + DigestUtils.md5Hex(userKey));
    }

    @Override
    public void rememberUser(HttpServletRequest request, HttpServletResponse response, boolean rememberMe) {
        if (this.configurationService.getRememberMeFeatureEnable() && rememberMe) {
            UserProfile userProfile = this.userManager.getRemoteUser();
            if (Objects.isNull(userProfile)) {
                return;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5));
            calendar.set(10, calendar.get(10) + this.configurationService.getRememberMeExpireHours());
            RememberMe newRemember = this.add(calendar.getTime(), userProfile.getUserKey().getStringValue());
            String userKey = userProfile.getUserKey().getStringValue();
            Cookie cookie = CookieUtils.createCookie(REMEMBER_ME_PREFIX + DigestUtils.md5Hex(userKey), newRemember.getHash(), request);
            int cookieHoldSeconds = new Long(DateUtils.getMinutesBetweenDates(new Date(), newRemember.getExpiredDate())).intValue();
            if (cookieHoldSeconds > 0) {
                cookie.setMaxAge(cookieHoldSeconds);
                response.addCookie(cookie);
            }
        }
    }

    @Override
    public void rememberUserClusterSession(HttpServletRequest request, HttpServletResponse response) {
        UserProfile userProfile = this.userManager.getRemoteUser();
        if (Objects.isNull(userProfile) || !this.clusterService.isClustered()) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5));
        calendar.set(13, calendar.get(13) + request.getSession().getMaxInactiveInterval());
        RememberMe newRemember = this.add(calendar.getTime(), "remember-session-::" + userProfile.getUserKey().getStringValue());
        String userKey = userProfile.getUserKey().getStringValue();
        Cookie cookie = CookieUtils.createCookie(REMEMBER_SESSION_PREFIX + DigestUtils.md5Hex(userKey), newRemember.getHash(), request);
        int cookieHoldSeconds = (int)DateUtils.getMinutesBetweenDates(new Date(), newRemember.getExpiredDate());
        if (cookieHoldSeconds > 0) {
            cookie.setMaxAge(cookieHoldSeconds);
            response.addCookie(cookie);
        }
    }

    @Override
    public boolean isUserRemembered(HttpServletRequest request, UserProfile userProfile) {
        RememberMe remember;
        if (Objects.isNull(userProfile)) {
            return false;
        }
        String userKey = userProfile.getUserKey().getStringValue();
        String cookieValue = CookieUtils.getCookieValue(REMEMBER_ME_PREFIX + DigestUtils.md5Hex(userKey), request);
        try {
            remember = this.getByUserKey(userKey, cookieValue);
        }
        catch (NotFoundException e) {
            return false;
        }
        return remember.getHash().equals(cookieValue);
    }

    @Override
    public boolean isUserClusterSessionRemembered(HttpServletRequest request, UserProfile userProfile) {
        RememberMe remember;
        if (Objects.isNull(userProfile)) {
            return false;
        }
        String userKey = userProfile.getUserKey().getStringValue();
        String cookieValue = CookieUtils.getCookieValue(REMEMBER_SESSION_PREFIX + DigestUtils.md5Hex(userKey), request);
        try {
            remember = this.getByUserKey("remember-session-::" + userKey, cookieValue);
        }
        catch (NotFoundException e) {
            return false;
        }
        return remember.getHash().equals(cookieValue);
    }
}

