/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.entities.impl;

import com.alphaserve.twofactor.core.dtolayer.converter.DoForwardConverter;
import com.alphaserve.twofactor.core.dtolayer.dtos.IpRepresentation;
import com.alphaserve.twofactor.core.dtolayer.dtos.logger.LogActionDTO;
import com.alphaserve.twofactor.core.model.FiltersAggregate;
import com.alphaserve.twofactor.core.model.LogActionType;
import com.alphaserve.twofactor.core.model.entities.LogAction;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.entities.LoggerActionService;
import com.alphaserve.twofactor.core.utils.StringUsefulUtils;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Qualifier;

@Named
public class LoggerActionServiceImpl
implements LoggerActionService {
    private static final int ENTRIES_IN_PAGE = 12;
    @ComponentImport
    private final ActiveObjects ao;
    private final ConfigurationService configurationService;
    private final DoForwardConverter<LogAction, LogActionDTO> dtoConverter;
    @ComponentImport
    private final UserManager userManager;

    @Inject
    public LoggerActionServiceImpl(ActiveObjects ao, ConfigurationService configurationService, DoForwardConverter<LogAction, LogActionDTO> dtoConverter, @Qualifier(value="userManager") UserManager userManager) {
        this.ao = ao;
        this.configurationService = configurationService;
        this.dtoConverter = dtoConverter;
        this.userManager = userManager;
    }

    @Override
    public List<LogAction> getPage(int page, FiltersAggregate filters) {
        Query finalQuery = this.getQuery(filters).order("DATE DESC").offset((page - 1) * 12).limit(12);
        LogAction[] logActions = (LogAction[])this.ao.executeInTransaction(() -> (LogAction[])this.ao.find(LogAction.class, finalQuery));
        if (Objects.isNull(logActions)) {
            return new ArrayList<LogAction>();
        }
        return Lists.newArrayList(logActions);
    }

    private Query getQuery(FiltersAggregate filters) {
        ArrayList<Pair<String, Object>> queries = new ArrayList<Pair<String, Object>>();
        String username = filters.getUsername();
        Date startDate = filters.getStartDate();
        Date finishDate = filters.getFinishDate();
        String action = filters.getAction();
        String userIp = filters.getUserIp();
        queries.add(Pair.of("ACTIONTYPE != ?", "Undefined"));
        queries.add(Pair.of("ACTIONTYPE != ?", "Enter"));
        if (StringUtils.isNoneBlank(username)) {
            queries.add(Pair.of("USERNAME LIKE ?", username));
        }
        boolean isStartNotNull = Objects.nonNull(startDate);
        boolean isFinishNotNull = Objects.nonNull(finishDate);
        if (isStartNotNull) {
            queries.add(Pair.of("DATE >= ?", startDate));
        }
        if (isFinishNotNull) {
            queries.add(Pair.of("DATE <= ?", finishDate));
        }
        if (Objects.nonNull(action) && !action.equals("All")) {
            queries.add(Pair.of("(ACTIONTYPE = 'Add' OR ACTIONTYPE = ?)", action.toUpperCase()));
        }
        if (StringUtils.isNoneBlank(userIp)) {
            queries.add(Pair.of("USERIP = ?", userIp));
        }
        Query query = Query.select();
        if (!queries.isEmpty()) {
            String queryKeysText = queries.stream().map(Pair::getLeft).collect(Collectors.joining(" AND "));
            Object[] queryArgs = queries.stream().map(Pair::getRight).toArray();
            query = query.where(queryKeysText, queryArgs);
        }
        return query;
    }

    @Override
    public long getCount(Query queryFilter) {
        return ((Integer)this.ao.executeInTransaction(() -> this.ao.count(LogAction.class, queryFilter))).intValue();
    }

    @Override
    public List<LogAction> getByQuery(Query queryFilter) {
        LogAction[] logActions = (LogAction[])this.ao.executeInTransaction(() -> (LogAction[])this.ao.find(LogAction.class, queryFilter));
        if (Objects.isNull(logActions)) {
            return new ArrayList<LogAction>();
        }
        return Arrays.asList(logActions);
    }

    @Override
    public void add(String username, LogActionType actionType, String userIP) {
        if (this.configurationService.getAuthLoggerEnable()) {
            this.ao.executeInTransaction(() -> {
                LogAction logAction = (LogAction)this.ao.create(LogAction.class, new DBParam[0]);
                logAction.setUsername(username);
                logAction.setDate(new Date(System.currentTimeMillis()));
                logAction.setActionType(actionType.name());
                logAction.setUserIP(userIP);
                if (actionType.equals((Object)LogActionType.RESET_BY_ADMIN) && Objects.nonNull(this.userManager.getRemoteUser())) {
                    logAction.setAdminUsername(this.userManager.getRemoteUser().getUsername());
                }
                logAction.save();
                return logAction;
            });
        }
    }

    @Override
    public void add(String username, LogActionType actionType, List<IpRepresentation> userIP) {
        List<String> collectedIp = userIP.stream().map(IpRepresentation::getIp).collect(Collectors.toList());
        this.add(username, actionType, StringUsefulUtils.getComaSplitStringFromList(collectedIp));
    }

    @Override
    public void deleteEarlierThan(Date purgeDate) {
        this.ao.executeInTransaction(() -> this.ao.deleteWithSQL(LogAction.class, "DATE < ?", new Object[]{purgeDate}));
    }

    @Override
    public void deleteAll() {
        this.ao.executeInTransaction(() -> this.ao.deleteWithSQL(LogAction.class, "ID > ?", new Object[]{0}));
    }

    @Override
    public List<LogActionDTO> getPages(int pageNumber, FiltersAggregate filters) {
        return this.getPage(pageNumber, filters).stream().map(this.dtoConverter::doForward).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

