/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.entities.impl;

import com.alphaserve.twofactor.core.model.entities.Credential;
import com.alphaserve.twofactor.core.services.UserService;
import com.alphaserve.twofactor.core.services.entities.CredentialService;
import com.yubico.webauthn.CredentialRepository;
import com.yubico.webauthn.RegisteredCredential;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import com.yubico.webauthn.data.exception.Base64UrlException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Named
@Component
public class JiraCredentialRepository
implements CredentialRepository {
    private static final Logger logger = LoggerFactory.getLogger(JiraCredentialRepository.class);
    private final CredentialService credentialService;
    private final UserService userService;

    @Inject
    public JiraCredentialRepository(CredentialService credentialService, UserService userService) {
        this.credentialService = credentialService;
        this.userService = userService;
    }

    @Override
    public Set<PublicKeyCredentialDescriptor> getCredentialIdsForUsername(String username) {
        HashSet<PublicKeyCredentialDescriptor> descriptors = new HashSet<PublicKeyCredentialDescriptor>();
        String userKey = this.userService.getUserKey(username);
        if (Objects.nonNull(userKey)) {
            for (Credential credential : this.credentialService.getSetByUserKey(userKey)) {
                ByteArray byteArray;
                try {
                    byteArray = ByteArray.fromBase64Url(credential.getKeyId());
                }
                catch (Base64UrlException e) {
                    logger.error("Can't convert KeyId to ByteArray", (Throwable)e);
                    continue;
                }
                descriptors.add(PublicKeyCredentialDescriptor.builder().id(byteArray).build());
            }
        }
        return descriptors;
    }

    @Override
    public Optional<ByteArray> getUserHandleForUsername(String username) {
        ByteArray byteArray = null;
        String userKey = this.userService.getUserKey(username);
        if (Objects.nonNull(userKey) && !this.credentialService.getByUserKey(userKey).isEmpty()) {
            byteArray = new ByteArray(DigestUtils.md5Hex(userKey).getBytes());
        }
        return Optional.ofNullable(byteArray);
    }

    @Override
    public Optional<String> getUsernameForUserHandle(ByteArray byteArray) {
        List<Credential> byUserIdentityId = this.credentialService.getByUserIdentityId(byteArray.getBase64Url());
        if (!byUserIdentityId.isEmpty()) {
            String s2 = byUserIdentityId.get(0).getUserKey();
            return Optional.of(s2);
        }
        return Optional.empty();
    }

    @Override
    public Optional<RegisteredCredential> lookup(ByteArray credentialId, ByteArray userHandle) {
        List<Credential> byUserIdentityIdAndKeyId = this.credentialService.getByUserIdentityIdAndKeyId(userHandle.getBase64Url(), credentialId.getBase64Url());
        if (!byUserIdentityIdAndKeyId.isEmpty()) {
            Credential credential = byUserIdentityIdAndKeyId.get(0);
            RegisteredCredential converted = this.convert(credential);
            return Optional.ofNullable(converted);
        }
        return Optional.empty();
    }

    @Override
    public Set<RegisteredCredential> lookupAll(ByteArray credentialId) {
        List<Credential> byKeyId = this.credentialService.getByKeyId(credentialId.getBase64Url());
        HashSet<RegisteredCredential> registeredCredentials = new HashSet<RegisteredCredential>();
        if (!byKeyId.isEmpty()) {
            for (Credential credential : this.credentialService.getByKeyId(credentialId.getBase64Url())) {
                RegisteredCredential converted = this.convert(credential);
                if (!Objects.nonNull(converted)) continue;
                registeredCredentials.add(converted);
            }
        }
        return registeredCredentials;
    }

    private RegisteredCredential convert(Credential credential) {
        try {
            ByteArray keyId = ByteArray.fromBase64Url(credential.getKeyId());
            ByteArray userIdentityId = ByteArray.fromBase64Url(credential.getUserIdentityId());
            ByteArray publicKeyCose = ByteArray.fromBase64Url(credential.getPublicKeyCose());
            return RegisteredCredential.builder().credentialId(keyId).userHandle(userIdentityId).publicKeyCose(publicKeyCose).build();
        }
        catch (Base64UrlException e) {
            logger.error("Can't convert keyId/userIdentityId/publicKeyCose to ByteArray", (Throwable)e);
            return null;
        }
    }
}

