/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.entities.impl;

import com.alphaserve.twofactor.core.dtolayer.dtos.IpRepresentation;
import com.alphaserve.twofactor.core.model.entities.FailLogin2FA;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.entities.FailLogin2FAService;
import com.alphaserve.twofactor.core.services.entities.IpFilterService;
import com.alphaserve.twofactor.core.utils.StringUsefulUtils;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.commons.lang3.time.DateUtils;

@Named
public class FailLogin2FAServiceImpl
implements FailLogin2FAService {
    @ComponentImport
    private final ActiveObjects ao;
    private final ConfigurationService configurationService;
    private final IpFilterService ipFilterService;

    @Inject
    public FailLogin2FAServiceImpl(ActiveObjects ao, ConfigurationService configurationService, IpFilterService ipFilterService) {
        this.ao = ao;
        this.configurationService = configurationService;
        this.ipFilterService = ipFilterService;
    }

    @Override
    public FailLogin2FA add(String userKey, String ipAddress) {
        if (this.configurationService.getAuthBruteForceEnable()) {
            return (FailLogin2FA)this.ao.executeInTransaction(() -> {
                FailLogin2FA failLogin2FA = (FailLogin2FA)this.ao.create(FailLogin2FA.class, new DBParam[0]);
                failLogin2FA.setIpAddress(ipAddress);
                failLogin2FA.setUserKey(userKey);
                failLogin2FA.setCreatedAt(new Date(System.currentTimeMillis()));
                failLogin2FA.save();
                return failLogin2FA;
            });
        }
        return null;
    }

    @Override
    public boolean isLocked(String userKey, HttpServletRequest request) {
        if (this.configurationService.getAuthBruteForceEnable()) {
            String ipAddress = this.convertIpToString(this.ipFilterService.getClientIpAddress(request));
            int attempts = this.configurationService.getNumberAttempts();
            int period = this.configurationService.getLockoutPeriod();
            Date date = DateUtils.addMinutes(new Date(System.currentTimeMillis()), -period);
            Query query = Query.select().where("USERKEY = ? AND IP_ADDRESS = ? AND CREATEDAT >= ?", new Object[]{userKey, ipAddress, date});
            return (Integer)this.ao.executeInTransaction(() -> this.ao.count(FailLogin2FA.class, query)) >= attempts;
        }
        return false;
    }

    @Override
    public String convertIpToString(List<IpRepresentation> ipRepresentations) {
        List<String> collectedIp = ipRepresentations.stream().map(ipRepresentation -> ipRepresentation.getHeader() + ":" + ipRepresentation.getIp()).collect(Collectors.toList());
        return StringUsefulUtils.getComaSplitStringFromList(collectedIp);
    }
}

