/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.entities.impl;

import com.alphaserve.twofactor.core.model.entities.Credential;
import com.alphaserve.twofactor.core.services.entities.CredentialService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Named
@Component
public class CredentialServiceImpl
implements CredentialService {
    @ComponentImport
    private final ActiveObjects ao;
    @ComponentImport
    protected final UserManager salUserManager;

    @Inject
    public CredentialServiceImpl(ActiveObjects ao, @Qualifier(value="userManager") UserManager salUserManager) {
        this.ao = ao;
        this.salUserManager = salUserManager;
    }

    @Override
    public Credential add(String userKey, String publicKeyCose, String type, String keyId, String userIdentityId, String name, Date createdAt) {
        return (Credential)this.ao.executeInTransaction(() -> {
            Credential credential = (Credential)this.ao.create(Credential.class, new DBParam[0]);
            credential.setUserKey(userKey);
            credential.setPublicKeyCose(publicKeyCose);
            credential.setType(type);
            credential.setKeyId(keyId);
            credential.setCreatedAt(createdAt);
            credential.setUserIdentityId(userIdentityId);
            credential.setName(name);
            credential.save();
            return credential;
        });
    }

    @Override
    public Credential getById(int id) {
        return (Credential)this.ao.executeInTransaction(() -> (Credential)this.ao.get(Credential.class, (Object)id));
    }

    @Override
    public boolean deleteByIdAndUserKey(Long id, String userKey) {
        return this.ao.deleteWithSQL(Credential.class, "ID = ? AND USER_KEY = ?", new Object[]{id, userKey}) > 0;
    }

    @Override
    public List<Credential> getByUserKey(String userKey) {
        Query query = Query.select().where("USER_KEY = ?", new Object[]{userKey});
        Credential[] userCredentials = (Credential[])this.ao.executeInTransaction(() -> (Credential[])this.ao.find(Credential.class, query));
        return this.getResult(userCredentials);
    }

    @Override
    public Set<Credential> getSetByUserKey(String userKey) {
        return new HashSet<Credential>(this.getByUserKey(userKey));
    }

    @Override
    public List<Credential> getByUserIdentityId(String identityId) {
        Query query = this.isPostgreSQL() ? Query.select().where("to_char(USER_IDENTITY_ID) = ?", new Object[]{identityId}) : Query.select().where("USER_IDENTITY_ID = ?", new Object[]{identityId});
        Credential[] userCredentials = (Credential[])this.ao.executeInTransaction(() -> (Credential[])this.ao.find(Credential.class, query));
        return this.getResult(userCredentials);
    }

    @Override
    public List<Credential> getByUserIdentityIdAndKeyId(String userIdentityId, String keyId) {
        Query query = this.isPostgreSQL() ? Query.select().where("to_char(USER_IDENTITY_ID) = ? AND to_char(KEY_ID) = ?", new Object[]{userIdentityId, keyId}) : Query.select().where("USER_IDENTITY_ID = ? AND KEY_ID = ?", new Object[]{userIdentityId, keyId});
        Credential[] userCredentials = (Credential[])this.ao.executeInTransaction(() -> (Credential[])this.ao.find(Credential.class, query));
        return this.getResult(userCredentials);
    }

    @Override
    public List<Credential> getByKeyId(String keyId) {
        Query query = this.isPostgreSQL() ? Query.select().where("to_char(KEY_ID) = ?", new Object[]{keyId}) : Query.select().where("KEY_ID = ?", new Object[]{keyId});
        Credential[] userCredentials = (Credential[])this.ao.executeInTransaction(() -> (Credential[])this.ao.find(Credential.class, query));
        return this.getResult(userCredentials);
    }

    @Override
    public void delete(Credential credential) {
        this.ao.delete(new RawEntity[]{credential});
    }

    private List<Credential> getResult(Credential[] credentials) {
        if (Objects.isNull(credentials)) {
            return new ArrayList<Credential>();
        }
        return Arrays.asList(credentials);
    }

    @Override
    public long getCredentialCountByName(String name, String userKey) {
        return ((Integer)this.ao.executeInTransaction(() -> this.ao.count(Credential.class, Query.select().where("NAME = ? AND USER_KEY = ?", new Object[]{name, userKey})))).intValue();
    }

    @Override
    public void deleteList(List<Credential> credentials) {
        for (Credential credential : credentials) {
            this.delete(credential);
        }
    }

    @Override
    public boolean hasRemoteUserU2FDevice() {
        UserProfile remoteUser = this.salUserManager.getRemoteUser();
        if (Objects.isNull(remoteUser)) {
            return false;
        }
        return (Integer)this.ao.executeInTransaction(() -> this.ao.count(Credential.class, Query.select().where("USER_KEY = ?", new Object[]{remoteUser.getUserKey().getStringValue()}))) > 0;
    }

    @Override
    public void deleteByUserKey(String userKey) {
        this.ao.deleteWithSQL(Credential.class, "USER_KEY = ?", new Object[]{userKey});
    }

    private boolean isPostgreSQL() {
        return this.ao.moduleMetaData().getDatabaseType().equals((Object)DatabaseType.ORACLE);
    }
}

