/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.services.entities.impl;

import com.alphaserve.twofactor.core.model.entities.Auth2FA;
import com.alphaserve.twofactor.core.model.entities.cache.wraper.Auth2FACacheWrapper;
import com.alphaserve.twofactor.core.services.cache.Auth2FACacheManager;
import com.alphaserve.twofactor.core.services.entities.Auth2FAService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class Auth2FAServiceImpl
implements Auth2FAService {
    @ComponentImport
    protected final ActiveObjects ao;
    @ComponentImport
    protected final UserManager salUserManager;
    protected final Auth2FACacheManager auth2FACacheManager;

    protected Auth2FAServiceImpl(ActiveObjects ao, @Qualifier(value="userManager") UserManager salUserManager, Auth2FACacheManager auth2FACacheManager) {
        this.ao = Preconditions.checkNotNull(ao);
        this.salUserManager = salUserManager;
        this.auth2FACacheManager = auth2FACacheManager;
    }

    @Override
    public Auth2FA add(String userKey, String key, boolean tfaEnable) {
        return (Auth2FA)this.ao.executeInTransaction(() -> {
            Auth2FA auth2FA = (Auth2FA)this.ao.create(Auth2FA.class, new DBParam[0]);
            auth2FA.setUserKey(userKey);
            auth2FA.setKey(key);
            auth2FA.setConfirmed(false);
            auth2FA.setActive(tfaEnable);
            auth2FA.save();
            this.auth2FACacheManager.cacheEntity(userKey, new Auth2FACacheWrapper(auth2FA));
            return auth2FA;
        });
    }

    @Override
    public Auth2FA getByUserKey(UserKey userKey) {
        return this.getByUserKey(userKey.getStringValue());
    }

    @Override
    public void delete(Auth2FA auth2FA) {
        this.ao.delete(new RawEntity[]{auth2FA});
        this.auth2FACacheManager.deleteByKey(auth2FA.getUserKey());
    }

    @Override
    public void deleteAll() {
        this.ao.deleteWithSQL(Auth2FA.class, "ID > ?", new Object[]{0});
        this.auth2FACacheManager.deleteAll();
    }

    @Override
    public void finishRegistration(UserProfile userProfile) {
        this.ao.executeInTransaction(() -> {
            Auth2FA auth2FA = this.getByUserKey(userProfile.getUserKey());
            auth2FA.setActive(true);
            auth2FA.setUserKey(userProfile.getUserKey().getStringValue());
            auth2FA.setConfirmed(true);
            auth2FA.save();
            this.auth2FACacheManager.cacheEntity(userProfile.getUserKey().getStringValue(), new Auth2FACacheWrapper(auth2FA));
            return auth2FA;
        });
    }

    @Override
    public boolean isUserAllowedToFinishRegistration(UserProfile userProfile) {
        Auth2FACacheWrapper auth2FA = this.getWrappedEntityByUserKey(userProfile.getUserKey());
        return !auth2FA.isConfirmed() && auth2FA.isActive();
    }

    @Override
    public boolean isUserHasEnabled2fa(UserKey userKey) {
        Auth2FACacheWrapper auth2FA = this.getWrappedEntityByUserKey(userKey);
        return this.isUserHasEnabled2fa(auth2FA);
    }

    @Override
    public boolean isUserHasEnabled2fa(Auth2FA auth2FA) {
        return Objects.nonNull(auth2FA) && auth2FA.getActive() && auth2FA.getConfirmed();
    }

    @Override
    public boolean isUserHasEnabled2fa(Auth2FACacheWrapper auth2FA) {
        return auth2FA.isActive() && auth2FA.isConfirmed();
    }

    @Override
    public Auth2FA getByUsername(String username) {
        UserProfile userProfile = this.salUserManager.getUserProfile(username);
        return Objects.nonNull(userProfile) ? this.getByUserKey(userProfile.getUserKey()) : null;
    }

    @Override
    public void enable2fa(Auth2FA auth2FA) {
        this.ao.executeInTransaction(() -> {
            auth2FA.setActive(true);
            auth2FA.save();
            this.auth2FACacheManager.cacheEntity(auth2FA.getUserKey(), new Auth2FACacheWrapper(auth2FA));
            return auth2FA;
        });
    }

    @Override
    public Auth2FA getByUserKey(String userKey) {
        Auth2FA[] auth2FA = (Auth2FA[])this.ao.executeInTransaction(() -> (Auth2FA[])this.ao.find(Auth2FA.class, Query.select().where("USERKEY = ?", new Object[]{userKey}).limit(2)));
        if (auth2FA.length > 0) {
            return auth2FA[0];
        }
        return null;
    }

    @Override
    public List<Auth2FA> getAll() {
        Auth2FA[] auth2FA = (Auth2FA[])this.ao.executeInTransaction(() -> (Auth2FA[])this.ao.find(Auth2FA.class, Query.select()));
        if (auth2FA == null) {
            return new ArrayList<Auth2FA>();
        }
        return Lists.newArrayList(auth2FA);
    }

    @Override
    public Auth2FA[] getByUserKeys(Object ... userKeys) {
        if (userKeys.length == 0) {
            return new Auth2FA[0];
        }
        ArrayList<Object> args = new ArrayList<Object>(Arrays.asList(userKeys));
        StringBuilder clause = new StringBuilder("(USERKEY = ?");
        args.add(true);
        for (int i = 1; i < userKeys.length; ++i) {
            clause.append(" OR USERKEY = ?");
        }
        return (Auth2FA[])this.ao.executeInTransaction(() -> (Auth2FA[])this.ao.find(Auth2FA.class, Query.select().where(clause + ") AND ACTIVE = ?", args.toArray())));
    }

    @Override
    public Auth2FACacheWrapper getWrappedEntityByUserKey(UserKey userKey) {
        return this.auth2FACacheManager.getByKey(userKey).orElseGet(() -> {
            Auth2FA entity = this.getByUserKey(userKey);
            Auth2FACacheWrapper auth2FA = new Auth2FACacheWrapper(entity);
            this.auth2FACacheManager.cacheEntity(userKey, auth2FA);
            return auth2FA;
        });
    }
}

