/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.security;

import com.alphaserve.twofactor.core.Plugin2FACoreContext;
import com.alphaserve.twofactor.core.dtolayer.dtos.wrapper.UrlRecord;
import com.alphaserve.twofactor.core.factory.UrlRecordFactory;
import com.alphaserve.twofactor.core.model.LogActionType;
import com.alphaserve.twofactor.core.model.entities.Auth2FA;
import com.alphaserve.twofactor.core.model.entities.cache.wraper.Auth2FACacheWrapper;
import com.alphaserve.twofactor.core.security.FilterState;
import com.alphaserve.twofactor.core.services.AuthLoginService;
import com.alphaserve.twofactor.core.services.ClusterService;
import com.alphaserve.twofactor.core.services.ConfigurationService;
import com.alphaserve.twofactor.core.services.Force2FAService;
import com.alphaserve.twofactor.core.services.entities.Auth2FAService;
import com.alphaserve.twofactor.core.services.entities.FailLogin2FAService;
import com.alphaserve.twofactor.core.services.entities.IpFilterService;
import com.alphaserve.twofactor.core.services.entities.LoggerActionService;
import com.alphaserve.twofactor.core.services.entities.RememberMeService;
import com.alphaserve.twofactor.core.utils.StringUsefulUtils;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class AuthFilterManager {
    public static final String AUTH_IP_FILTER = "ip_filter";
    private static final String REST = "/rest/";
    protected final Plugin2FACoreContext pluginContext;
    protected final UrlRecord restUrlProperty;
    protected final UrlRecord[] whiteListPrefixes;
    protected final UrlRecord[] whiteListContains;
    protected final UrlRecord[] securityPrefixes;
    protected final UrlRecord[] endSecurityUrls;
    protected final UrlRecord[] blackList;

    protected AuthFilterManager(Plugin2FACoreContext pluginContext) {
        this.restUrlProperty = UrlRecordFactory.createUrlRecord(pluginContext.getBaseUrl(UrlMode.RELATIVE), REST);
        this.pluginContext = pluginContext;
        this.whiteListPrefixes = pluginContext.getDefaultUrlWhitelistPrefixes();
        this.whiteListContains = pluginContext.getDefaultUrlWhitelistContains();
        this.securityPrefixes = pluginContext.getSecurityPrefixes();
        this.endSecurityUrls = pluginContext.getEndSecurityUrls();
        this.blackList = pluginContext.getDefaultUrlBlacklistUnlogged();
    }

    private boolean noneMatchSecurityPrefixes(String url) {
        return Arrays.stream(this.securityPrefixes).noneMatch(prefix -> prefix.containsRawUrlInSource(url));
    }

    public FilterState getAuthResult(Auth2FAService user2faService, AuthLoginService loginService, LoggerActionService loggerActionService, RememberMeService rememberMeService, IpFilterService ipFilterService, HttpServletRequest req, Force2FAService force2FAService, ConfigurationService configurationService, FailLogin2FAService failLogin2FAService, PluginAccessor pluginAccessor, Auth2FACacheWrapper auth2FA, UserProfile remoteUser, ClusterService clusterService, String requestPath) {
        Optional<FilterState> filterState;
        if (clusterService.isClustered() && rememberMeService.isUserClusterSessionRemembered(req, remoteUser)) {
            return FilterState.PASS;
        }
        if (configurationService.getOAuthWhitelistEnable()) {
            if (Objects.nonNull(req.getAttribute("os_authstatus")) && req.getAttribute("os_authstatus").equals("success") && (Objects.nonNull(req.getAttribute("com.atlassian.oath.request-flag")) || Objects.nonNull(req.getAttribute("com.atlassian.oath.consumer-key"))) || Objects.nonNull(req.getAttribute("com.atlassian.oath.request-flag")) && Objects.nonNull(req.getAttribute("com.atlassian.oath.consumer-key")) || this.isMiniOrangeOAuthInstalled(pluginAccessor) && this.isLoggedWithMiniOrange(req)) {
                loginService.login2fa(req.getSession(), remoteUser);
                return FilterState.LOGGED_IN;
            }
            for (UrlRecord whitelistEntry : this.pluginContext.getWhitelistOnOAuthEnabled()) {
                if (!whitelistEntry.containsUrlPartInSource(requestPath)) continue;
                return FilterState.PASS;
            }
        }
        if (Objects.isNull(remoteUser)) {
            for (UrlRecord blacklistEntry : this.blackList) {
                if (!blacklistEntry.containsUrlPartInSource(requestPath)) continue;
                return FilterState.BREAK;
            }
            return FilterState.PASS;
        }
        if (this.isUserInIPList(req, remoteUser.getUserKey().getStringValue(), configurationService)) {
            return FilterState.LOGGED_IN;
        }
        boolean isUserHasEnabled2fa = user2faService.isUserHasEnabled2fa(auth2FA);
        if (!isUserHasEnabled2fa) {
            for (UrlRecord whitelistEntry : this.pluginContext.getWhitelistOnForce()) {
                if (!whitelistEntry.containsUrlPartInSource(requestPath)) continue;
                return FilterState.PASS;
            }
        } else if (!failLogin2FAService.isLocked(remoteUser.getUserKey().getStringValue(), req)) {
            for (UrlRecord whitelistEntry : this.pluginContext.getWhitelistOnUserEnabled2fa()) {
                if (!whitelistEntry.containsUrlPartInSource(requestPath)) continue;
                return FilterState.PASS;
            }
        }
        if (auth2FA.isActive()) {
            if (this.pluginContext.getDefaultBlacklistNotLogged2fa().containsUrlPartInSource(requestPath)) {
                return FilterState.BREAK;
            }
            Optional<UrlRecord[]> blacklist = this.pluginContext.getDefaultUrlBlacklistUnlogged2faOptional();
            if (blacklist.isPresent()) {
                for (UrlRecord urlRecord : blacklist.get()) {
                    if (!urlRecord.containsUrlPartInSource(requestPath)) continue;
                    return FilterState.NOT_ALLOWED;
                }
            }
        }
        boolean tfaLogged = loginService.isLogged2fa(req.getSession(), remoteUser);
        if (isUserHasEnabled2fa && requestPath.contains(REST) && !requestPath.contains("/login") && configurationService.getRestEndpointsRestriction() && !tfaLogged) {
            return FilterState.NOT_ALLOWED;
        }
        for (UrlRecord urlRecord : this.whiteListPrefixes) {
            if (!urlRecord.startsWithRawUrlInSource(requestPath)) continue;
            return FilterState.PASS;
        }
        if (configurationService.getRememberMeFeatureEnable() && !tfaLogged && rememberMeService.isUserRemembered(req, remoteUser)) {
            loginService.login2fa(req.getSession(), remoteUser);
            loggerActionService.add(remoteUser.getUsername(), LogActionType.PASS_2FA_REMEMBER, ipFilterService.getClientIpAddress(req));
        } else if (isUserHasEnabled2fa && !tfaLogged) {
            for (UrlRecord urlRecord : this.endSecurityUrls) {
                if (!urlRecord.containsUrlPartInSource(requestPath)) continue;
                return FilterState.BREAK;
            }
        }
        if (this.restUrlProperty.startsWithRawUrlInSource(requestPath) && !configurationService.getRestEndpointsRestriction()) {
            return FilterState.PASS;
        }
        for (UrlRecord urlRecord : this.whiteListContains) {
            if (!urlRecord.containsUrlPartInSource(requestPath) || urlRecord.startsWithRawUrlInSource(requestPath) || !this.noneMatchSecurityPrefixes(requestPath)) continue;
            return FilterState.PASS;
        }
        String whitelistUrls = configurationService.getWhitelistUrls();
        if (StringUtils.isNotEmpty(whitelistUrls)) {
            List<String> customWhitelist = StringUsefulUtils.splitToList(whitelistUrls, "\n");
            for (String string : customWhitelist) {
                String trimEntry = string.trim();
                if (StringUtils.isEmpty(trimEntry) || !requestPath.contains(StringUtils.strip(trimEntry))) continue;
                return FilterState.PASS;
            }
        }
        if (this.isSKimEnabled() && (filterState = this.checkKimFailed(remoteUser, configurationService)).isPresent()) {
            return filterState.get();
        }
        tfaLogged = loginService.isLogged2fa(req.getSession(), remoteUser);
        if (failLogin2FAService.isLocked(remoteUser.getUserKey().getStringValue(), req)) {
            return FilterState.LOCKED;
        }
        if (auth2FA.isActive() && !tfaLogged) {
            return FilterState.BREAK;
        }
        if (force2FAService.isUserInForce(remoteUser, auth2FA)) {
            return FilterState.FORCE;
        }
        return FilterState.LOGGED_IN;
    }

    public FilterState getAuthMobileResult(Auth2FAService user2faService, HttpServletRequest req, ConfigurationService configurationService, UserManager userService, FailLogin2FAService failLogin2FAService, Force2FAService force2FAService, UserKey userKey, String requestPath) {
        Optional<UrlRecord[]> blacklist;
        Auth2FA authSetting;
        UserProfile userProfile = userService.getUserProfile(userKey);
        if (Objects.isNull(userProfile)) {
            for (UrlRecord whitelistEntry : this.blackList) {
                if (!whitelistEntry.containsUrlPartInSource(requestPath)) continue;
                return FilterState.BREAK;
            }
        }
        if (this.isUserInIPList(req, userKey.getStringValue(), configurationService)) {
            return FilterState.LOGGED_IN;
        }
        if (!user2faService.isUserHasEnabled2fa(userKey)) {
            for (UrlRecord whitelistEntry : this.pluginContext.getWhitelistOnForce()) {
                if (!whitelistEntry.containsUrlPartInSource(requestPath)) continue;
                return FilterState.PASS;
            }
        } else if (!failLogin2FAService.isLocked(userKey.getStringValue(), req)) {
            for (UrlRecord whitelistEntry : this.pluginContext.getWhitelistOnUserEnabled2fa()) {
                if (!whitelistEntry.containsUrlPartInSource(requestPath)) continue;
                return FilterState.PASS;
            }
        }
        if (Objects.nonNull(authSetting = user2faService.getByUserKey(userKey)) && authSetting.getActive() && (blacklist = this.pluginContext.getDefaultUrlBlacklistUnlogged2faOptional()).isPresent()) {
            for (UrlRecord entry : blacklist.get()) {
                if (!entry.containsUrlPartInSource(requestPath)) continue;
                return FilterState.NOT_ALLOWED;
            }
        }
        if (failLogin2FAService.isLocked(userKey.getStringValue(), req)) {
            return FilterState.LOCKED;
        }
        if (Objects.nonNull(authSetting) && authSetting.getActive()) {
            return FilterState.BREAK;
        }
        if (force2FAService.isUserInForce(userProfile)) {
            return FilterState.FORCE;
        }
        return FilterState.LOGGED_IN;
    }

    public boolean isUserInIPList(HttpServletRequest req, String userKey, ConfigurationService configurationService) {
        String ipFilter = (String)req.getSession().getAttribute(AUTH_IP_FILTER + userKey);
        if (ipFilter == null) {
            req.getSession().setAttribute(AUTH_IP_FILTER + userKey, (Object)Boolean.toString(configurationService.isUserInIpWhitelist(req)));
            return this.isUserInIPList(req, userKey, configurationService);
        }
        return Boolean.toString(true).equals(ipFilter);
    }

    protected boolean isLoggedWithMiniOrange(HttpServletRequest req) {
        Cookie[] cookies;
        for (Cookie cookie : cookies = req.getCookies()) {
            if ((!cookie.getName().equals("mo.confluence-oauth.LOGOUTCOOKIE") || !cookie.getValue().equals("LogoutCookie")) && !cookie.getName().equals("mo.jira-oauth.logoutcookie") && (!cookie.getName().equals("mo.bamboo-oauth.logoutcookie") || !cookie.getValue().equals("mo.bamboo-oauth.logoutcookie"))) continue;
            return true;
        }
        return false;
    }

    protected boolean isMiniOrangeOAuthInstalled(PluginAccessor pluginAccessor) {
        return pluginAccessor.isPluginEnabled("com.miniorange.oauth.confluence-oauth") || pluginAccessor.isPluginEnabled("com.miniorange.oauth.jira-oauth") || pluginAccessor.isPluginEnabled("com.miniorange.oauth.bamboo-oauth");
    }

    protected Optional<FilterState> checkKimFailed(UserProfile remoteUser, ConfigurationService configurationService) {
        return Optional.empty();
    }

    protected boolean isSKimEnabled() {
        return false;
    }

    public static List<String> splitAuthPropertyValue(String src) {
        return Objects.nonNull(src) ? StringUsefulUtils.splitToList(src, ",") : Collections.emptyList();
    }
}

